/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.toms_mobs.registry;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.types.Type;
import de.tomalbrc.toms_mobs.ModConfig;
import de.tomalbrc.toms_mobs.entity.hostile.IceCluster;
import de.tomalbrc.toms_mobs.entity.hostile.IceSpike;
import de.tomalbrc.toms_mobs.entity.hostile.IceSpikeSmall;
import de.tomalbrc.toms_mobs.entity.hostile.Iceologer;
import de.tomalbrc.toms_mobs.entity.hostile.Sculkling;
import de.tomalbrc.toms_mobs.entity.hostile.Showmaster;
import de.tomalbrc.toms_mobs.entity.hostile.Snake;
import de.tomalbrc.toms_mobs.entity.passive.Capybara;
import de.tomalbrc.toms_mobs.entity.passive.Elephant;
import de.tomalbrc.toms_mobs.entity.passive.Firemoth;
import de.tomalbrc.toms_mobs.entity.passive.Lobster;
import de.tomalbrc.toms_mobs.entity.passive.Mantaray;
import de.tomalbrc.toms_mobs.entity.passive.Nautilus;
import de.tomalbrc.toms_mobs.entity.passive.Penguin;
import de.tomalbrc.toms_mobs.entity.passive.Seagull;
import de.tomalbrc.toms_mobs.entity.passive.Tuna;
import de.tomalbrc.toms_mobs.entity.passive.butterfly.AbstractButterfly;
import de.tomalbrc.toms_mobs.entity.passive.butterfly.Butterfly;
import de.tomalbrc.toms_mobs.entity.passive.butterfly.LargeButterfly;
import de.tomalbrc.toms_mobs.item.TexturedPolymerSpawnEggItem;
import de.tomalbrc.toms_mobs.item.VanillaPolymerSpawnEggItem;
import de.tomalbrc.toms_mobs.util.BiomeHelper;
import de.tomalbrc.toms_mobs.util.Util;
import eu.pb4.polymer.core.api.entity.PolymerEntityUtils;
import eu.pb4.polymer.core.api.item.PolymerItemGroupUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityType;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags;
import net.minecraft.class_1208;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1429;
import net.minecraft.class_155;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2542;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3486;
import net.minecraft.class_3551;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9169;

public class MobRegistry {
    public static final class_1299<Penguin> PENGUIN = MobRegistry.register(Penguin.ID, FabricEntityType.Builder.createMob(Penguin::new, (class_1311)class_1311.field_6294, x -> x.defaultAttributes(Penguin::createAttributes).spawnRestriction(class_9169.field_48745, class_2902.class_2903.field_13203, class_1308::method_20636)).method_17687(0.6f, 1.05f));
    public static final class_1299<Elephant> ELEPHANT = MobRegistry.register(Elephant.ID, FabricEntityType.Builder.createMob(Elephant::new, (class_1311)class_1311.field_6294, x -> x.defaultAttributes(Elephant::createAttributes).spawnRestriction(class_9169.field_48745, class_2902.class_2903.field_13203, class_1429::method_20663)).method_17687(3.0f, 3.65f));
    public static final class_1299<Capybara> CAPYBARA = MobRegistry.register(Capybara.ID, FabricEntityType.Builder.createMob(Capybara::new, (class_1311)class_1311.field_6294, x -> x.defaultAttributes(Capybara::createAttributes).spawnRestriction(class_9169.field_48745, class_2902.class_2903.field_13203, class_1429::method_20663)).method_17687(0.9f, 1.1f));
    public static final class_1299<Seagull> SEAGULL = MobRegistry.register(Seagull.ID, FabricEntityType.Builder.createMob(Seagull::new, (class_1311)class_1311.field_6294, x -> x.defaultAttributes(Seagull::createAttributes).spawnRestriction(class_9169.field_48745, class_2902.class_2903.field_13203, class_1429::method_20663)).method_17687(0.8f, 0.9f));
    public static final class_1299<Nautilus> NAUTILUS = MobRegistry.register(Nautilus.ID, FabricEntityType.Builder.createMob(Nautilus::new, (class_1311)class_1311.field_6300, x -> x.defaultAttributes(Nautilus::createAttributes).spawnRestriction(class_9169.field_48743, class_2902.class_2903.field_13203, Nautilus::checkDeepWaterSpawnRules)).method_55687(0.1f).method_17687(1.0f, 1.0f));
    public static final class_1299<Mantaray> MANTARAY = MobRegistry.register(Mantaray.ID, FabricEntityType.Builder.createMob(Mantaray::new, (class_1311)class_1311.field_6300, x -> x.defaultAttributes(Mantaray::createAttributes).spawnRestriction(class_9169.field_48743, class_2902.class_2903.field_13203, Nautilus::checkDeepWaterSpawnRules)).method_17687(1.4f, 0.4f));
    public static final class_1299<Tuna> TUNA = MobRegistry.register(Tuna.ID, FabricEntityType.Builder.createMob(Tuna::new, (class_1311)class_1311.field_24460, x -> x.defaultAttributes(Tuna::createAttributes).spawnRestriction(class_9169.field_48743, class_2902.class_2903.field_13200, Nautilus::checkDeepWaterSpawnRules)).method_17687(0.55f, 0.55f));
    public static final class_1299<Lobster> LOBSTER = MobRegistry.register(Lobster.ID, FabricEntityType.Builder.createMob(Lobster::new, (class_1311)class_1311.field_24460, x -> x.defaultAttributes(Lobster::createAttributes).spawnRestriction(class_9169.field_48742, class_2902.class_2903.field_13200, (xx, levelAccessor, z, blockPos, r) -> r.method_43048(4) == 2 && blockPos.method_10264() < levelAccessor.method_8615() + 3 && (class_2542.method_10831((class_1922)levelAccessor, (class_2338)blockPos) || levelAccessor.method_8320(blockPos).method_26227().method_15767(class_3486.field_15517)) && levelAccessor.method_22335(blockPos, 0) > 1)).method_17687(0.65f, 0.35f));
    public static final class_1299<Firemoth> FIREMOTH = MobRegistry.register(Firemoth.ID, FabricEntityType.Builder.createMob(Firemoth::new, (class_1311)class_1311.field_6303, x -> x.defaultAttributes(Firemoth::createAttributes).spawnRestriction(class_9169.field_48742, class_2902.class_2903.field_13197, Firemoth::checkFiremothSpawnRules)).method_17687(0.5f, 0.5f));
    public static final class_1299<Butterfly> BUTTERFLY = MobRegistry.register(Butterfly.ID, FabricEntityType.Builder.createMob(Butterfly::new, (class_1311)class_1311.field_6303, x -> x.defaultAttributes(AbstractButterfly::createAttributes).spawnRestriction(class_9169.field_48745, class_2902.class_2903.field_13197, Butterfly::checkButterflySpawnRules)).method_17687(0.25f, 0.25f));
    public static final class_1299<LargeButterfly> EMPEROR_BUTTERFLY = MobRegistry.register(Util.id("emperor_butterfly"), FabricEntityType.Builder.createMob(LargeButterfly::new, (class_1311)class_1311.field_6303, x -> x.defaultAttributes(LargeButterfly::createAttributes).spawnRestriction(class_9169.field_48745, class_2902.class_2903.field_13197, LargeButterfly::checkLargeButterflySpawnRules)).method_17687(0.6f, 0.6f));
    public static final class_1299<Snake> SNAKE = MobRegistry.register(Snake.ID, FabricEntityType.Builder.createMob(Snake::new, (class_1311)class_1311.field_6294, x -> x.defaultAttributes(Snake::createAttributes).spawnRestriction(class_9169.field_48745, class_2902.class_2903.field_13203, class_1429::method_20663)).method_17687(0.9f, 0.4f));
    public static final class_1299<Sculkling> SCULKLING = MobRegistry.register(Sculkling.ID, FabricEntityType.Builder.createMob(Sculkling::new, (class_1311)class_1311.field_6302, x -> x.defaultAttributes(Sculkling::createAttributes).spawnRestriction(class_9169.field_48745, class_2902.class_2903.field_13203, Sculkling::checkSculklingSpawnRules)).method_17687(0.5f, 0.9f));
    public static final class_1299<Showmaster> SHOWMASTER = MobRegistry.register(Showmaster.ID, FabricEntityType.Builder.createMob(Showmaster::new, (class_1311)class_1311.field_6302, x -> x.defaultAttributes(Showmaster::createAttributes).spawnRestriction(class_9169.field_48745, class_2902.class_2903.field_13203, class_1308::method_20636)).method_17687(0.7f, 1.8f));
    public static final class_1299<Iceologer> ICEOLOGER = MobRegistry.register(Iceologer.ID, FabricEntityType.Builder.createMob(Iceologer::new, (class_1311)class_1311.field_6302, x -> x.defaultAttributes(Iceologer::createAttributes).spawnRestriction(class_9169.field_48745, class_2902.class_2903.field_13203, Iceologer::checkIceologerSpawnRules)).method_17687(0.7f, 1.8f));
    public static final class_1299<IceSpike> ICE_SPIKE = MobRegistry.register(IceSpike.ID, class_1299.class_1300.method_5903(IceSpike::new, (class_1311)class_1311.field_17715).method_17687(1.0f, 2.0f));
    public static final class_1299<IceSpikeSmall> ICE_SPIKE_SMALL = MobRegistry.register(IceSpikeSmall.ID, class_1299.class_1300.method_5903(IceSpikeSmall::new, (class_1311)class_1311.field_17715).method_17687(1.2f, 0.8f));
    public static final class_1299<IceCluster> ICE_CLUSTER = MobRegistry.register(IceCluster.ID, class_1299.class_1300.method_5903(IceCluster::new, (class_1311)class_1311.field_17715).method_17687(2.0f, 1.0f));
    public static final Object2ObjectOpenHashMap<class_2960, class_1792> SPAWN_EGGS = new Object2ObjectOpenHashMap();
    public static final class_1761 ITEM_GROUP = new class_1761.class_7913(null, -1).method_47321((class_2561)class_2561.method_43470((String)"Toms Mobs").method_27692(class_124.field_1077)).method_47320(() -> ((class_1792)class_1802.field_8727).method_7854()).method_47317((parameters, output) -> SPAWN_EGGS.values().forEach(arg_0 -> ((class_1761.class_7704)output).method_45421(arg_0))).method_47324();

    private static <T extends class_1297> class_1299<T> register(class_2960 id, class_1299.class_1300<T> builder) {
        Map types = class_3551.method_15450().getSchema(DataFixUtils.makeKey((int)class_155.method_16673().comp_4026().comp_4038())).findChoiceType(class_1208.field_5729).types();
        types.put(id.toString(), (Type)types.get(class_7923.field_41177.method_10221((Object)class_1299.field_6051).toString()));
        class_1299 type = builder.method_5905(class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)id));
        PolymerEntityUtils.registerType((class_1299[])new class_1299[]{type});
        return (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)id, (Object)type);
    }

    public static void registerMobs() {
        if (!ModConfig.getInstance().disabledMobs.contains(Penguin.ID)) {
            BiomeHelper.addSpawn(PENGUIN, 9, 2, 5, BiomeSelectors.spawnsOneOf((class_1299[])new class_1299[]{class_1299.field_6042}).or(BiomeSelectors.tag((class_6862)class_6908.field_41756)).or(BiomeSelectors.tag((class_6862)class_6908.field_36521)).or(BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9478, class_1972.field_9453})));
        }
        if (!ModConfig.getInstance().disabledMobs.contains(Snake.ID)) {
            BiomeHelper.addSpawn(SNAKE, 9, 1, 2, BiomeSelectors.spawnsOneOf((class_1299[])new class_1299[]{class_1299.field_6071}).and(BiomeSelectors.tag((class_6862)ConventionalBiomeTags.IS_JUNGLE).or(BiomeSelectors.tag((class_6862)ConventionalBiomeTags.IS_JUNGLE)).or(BiomeSelectors.tag((class_6862)class_6908.field_36520)).or(BiomeSelectors.tag((class_6862)class_6908.field_36496)).or(BiomeSelectors.tag((class_6862)class_6908.field_36529)).or(BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9471, class_1972.field_38748}))));
        }
        if (!ModConfig.getInstance().disabledMobs.contains(Elephant.ID)) {
            BiomeHelper.addSpawn(ELEPHANT, 18, 1, 3, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9449, class_1972.field_9430}).or(BiomeSelectors.tag((class_6862)ConventionalBiomeTags.IS_JUNGLE)));
        }
        if (!ModConfig.getInstance().disabledMobs.contains(Sculkling.ID)) {
            BiomeHelper.addSpawn(SCULKLING, 15, 2, 4, BiomeSelectors.spawnsOneOf((class_1299[])new class_1299[]{class_1299.field_6051}).and(BiomeSelectors.excludeByKey((class_5321[])new class_5321[]{class_1972.field_29218})));
        }
        if (!ModConfig.getInstance().disabledMobs.contains(Firemoth.ID)) {
            BiomeHelper.addSpawn(FIREMOTH, 5, 2, 3, BiomeSelectors.foundInTheNether().and(BiomeSelectors.excludeByKey((class_5321[])new class_5321[]{class_1972.field_23859})));
        }
        if (!ModConfig.getInstance().disabledMobs.contains(Butterfly.ID)) {
            BiomeHelper.addSpawn(BUTTERFLY, 25, 2, 5, BiomeSelectors.foundInOverworld().and(BiomeHelper.excludeTag((class_6862<class_1959>)ConventionalBiomeTags.IS_OCEAN).or(BiomeHelper.excludeTag((class_6862<class_1959>)ConventionalBiomeTags.IS_RIVER)).or(BiomeHelper.excludeTag((class_6862<class_1959>)class_6908.field_41756))));
        }
        if (!ModConfig.getInstance().disabledMobs.contains(LargeButterfly.ID)) {
            BiomeHelper.addSpawn(EMPEROR_BUTTERFLY, 2, 1, 1, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9414}).and(BiomeHelper.excludeTag((class_6862<class_1959>)ConventionalBiomeTags.IS_OCEAN).or(BiomeHelper.excludeTag((class_6862<class_1959>)ConventionalBiomeTags.IS_RIVER)).or(BiomeHelper.excludeTag((class_6862<class_1959>)class_6908.field_41756))));
        }
        if (!ModConfig.getInstance().disabledMobs.contains(Capybara.ID)) {
            BiomeHelper.addSpawn(CAPYBARA, 8, 1, 3, BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9471, class_1972.field_38748, class_1972.field_9438}));
        }
        if (!ModConfig.getInstance().disabledMobs.contains(Iceologer.ID)) {
            BiomeHelper.addSpawn(ICEOLOGER, 1, 1, 3, BiomeSelectors.foundInOverworld().and(BiomeSelectors.tag((class_6862)ConventionalBiomeTags.IS_MOUNTAIN)));
        }
        if (!ModConfig.getInstance().disabledMobs.contains(Mantaray.ID)) {
            BiomeHelper.addSpawn(MANTARAY, 1, 1, 1, BiomeSelectors.tag((class_6862)ConventionalBiomeTags.IS_OCEAN));
        }
        if (!ModConfig.getInstance().disabledMobs.contains(Tuna.ID)) {
            BiomeHelper.addSpawn(TUNA, 1, 1, 2, BiomeSelectors.tag((class_6862)ConventionalBiomeTags.IS_OCEAN));
        }
        if (!ModConfig.getInstance().disabledMobs.contains(Nautilus.ID)) {
            BiomeHelper.addSpawn(NAUTILUS, 1, 1, 1, BiomeSelectors.tag((class_6862)ConventionalBiomeTags.IS_OCEAN));
        }
        if (!ModConfig.getInstance().disabledMobs.contains(Lobster.ID)) {
            BiomeHelper.addSpawn(LOBSTER, 1, 1, 3, BiomeSelectors.spawnsOneOf((class_1299[])new class_1299[]{class_1299.field_6113}).and(BiomeSelectors.tag((class_6862)ConventionalBiomeTags.IS_BEACH).or(BiomeSelectors.tag((class_6862)ConventionalBiomeTags.IS_OCEAN))));
        }
        MobRegistry.addSpawnEgg(PENGUIN, class_1802.field_8346);
        MobRegistry.addSpawnEggModeled(ELEPHANT, Util.id("elephant_spawn_egg"));
        MobRegistry.addSpawnEgg(FIREMOTH, class_1802.field_8274);
        MobRegistry.addSpawnEgg(SEAGULL, class_1802.field_16314);
        MobRegistry.addSpawnEgg(BUTTERFLY, class_1802.field_40865);
        MobRegistry.addSpawnEgg(EMPEROR_BUTTERFLY, class_1802.field_40865);
        MobRegistry.addSpawnEggModeled(CAPYBARA, Util.id("capybara_spawn_egg"));
        MobRegistry.addSpawnEgg(MANTARAY, class_1802.field_38219);
        MobRegistry.addSpawnEgg(NAUTILUS, class_1802.field_8117);
        MobRegistry.addSpawnEgg(TUNA, class_1802.field_8661);
        MobRegistry.addSpawnEgg(LOBSTER, class_1802.field_8274);
        MobRegistry.addSpawnEgg(SCULKLING, class_1802.field_38219);
        MobRegistry.addSpawnEggModeled(SNAKE, Util.id("snake_spawn_egg"));
        MobRegistry.addSpawnEgg(SHOWMASTER, class_1802.field_8510);
        MobRegistry.addSpawnEgg(ICEOLOGER, class_1802.field_8235);
        PolymerItemGroupUtils.registerPolymerItemGroup((class_2960)Util.id("spawn-eggs"), (class_1761)ITEM_GROUP);
    }

    private static void addSpawnEggModeled(class_1299<? extends class_1308> type, class_2960 model) {
        MobRegistry.register(Util.id(class_1299.method_5890(type).method_12832() + "_spawn_egg"), (class_1792.class_1793 properties) -> new TexturedPolymerSpawnEggItem(type, (class_1792.class_1793)properties, model));
    }

    private static void addSpawnEgg(class_1299<? extends class_1308> type, class_1792 vanillaItem) {
        MobRegistry.register(Util.id(class_1299.method_5890(type).method_12832() + "_spawn_egg"), (class_1792.class_1793 properties) -> new VanillaPolymerSpawnEggItem(type, vanillaItem, (class_1792.class_1793)properties));
    }

    public static <T extends class_1792> void register(class_2960 identifier, Function<class_1792.class_1793, T> function) {
        class_1792 x = (class_1792)function.apply(new class_1792.class_1793().method_7889(64).method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)identifier)));
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)identifier, (Object)x);
        SPAWN_EGGS.putIfAbsent((Object)identifier, (Object)x);
    }
}

