/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.data.fabric.builder;

import com.chefmooon.ubesdelight.common.crafting.ingredient.ChanceResult;
import com.chefmooon.ubesdelight.common.registry.fabric.UbesDelightRecipeSerializersImpl;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class BakingMatRecipeJsonBuilder
implements class_5797 {
    private final List<class_1856> ingredientList;
    private final List<class_1856> processStages;
    private final List<ChanceResult> resultList = new ArrayList<ChanceResult>(4);
    private final class_1856 tool;
    private String soundEventID;

    private BakingMatRecipeJsonBuilder(List<class_1856> ingredientList, @Nullable List<class_1856> processStages, class_1856 tool, class_1799 mainResult, int count, float chance) {
        this.ingredientList = ingredientList;
        this.processStages = processStages;
        this.resultList.add(new ChanceResult(new class_1799((class_1935)mainResult.method_7909(), count), chance));
        this.tool = tool;
    }

    public static BakingMatRecipeJsonBuilder create(List<class_1856> ingredientList, @Nullable List<class_1856> processStages, class_1856 tool, class_1792 mainResult) {
        return new BakingMatRecipeJsonBuilder(ingredientList, processStages, tool, new class_1799((class_1935)mainResult), 1, 1.0f);
    }

    public static BakingMatRecipeJsonBuilder create(List<class_1856> ingredientList, @Nullable List<class_1856> processStages, class_1856 tool, class_1792 mainResult, int count) {
        return new BakingMatRecipeJsonBuilder(ingredientList, processStages, tool, new class_1799((class_1935)mainResult), count, 1.0f);
    }

    public BakingMatRecipeJsonBuilder addOutput(class_1792 item) {
        return this.addOutput(item, 1, Float.valueOf(1.0f));
    }

    public BakingMatRecipeJsonBuilder addOutput(class_1792 item, Integer count, Float chance) {
        this.resultList.add(new ChanceResult(new class_1799((class_1935)item, count.intValue()), chance.floatValue()));
        return this;
    }

    public BakingMatRecipeJsonBuilder input(class_6862<class_1792> tag) {
        return this.input(class_1856.method_8106(tag));
    }

    public BakingMatRecipeJsonBuilder input(class_6862<class_1792> tag, int size) {
        return this.input(class_1856.method_8106(tag), size);
    }

    public BakingMatRecipeJsonBuilder input(class_1935 itemProvider) {
        return this.input(class_1856.method_8091((class_1935[])new class_1935[]{itemProvider}));
    }

    public BakingMatRecipeJsonBuilder input(class_1935 itemProvider, int size) {
        return this.input(class_1856.method_8091((class_1935[])new class_1935[]{itemProvider}), size);
    }

    public BakingMatRecipeJsonBuilder input(class_1856 ingredient) {
        return this.input(ingredient, 1);
    }

    public BakingMatRecipeJsonBuilder input(class_1856 ingredient, int size) {
        for (int i = 0; i < size; ++i) {
            this.ingredientList.add(ingredient);
        }
        return this;
    }

    public BakingMatRecipeJsonBuilder addSound(String soundEventID) {
        this.soundEventID = soundEventID;
        return this;
    }

    public class_5797 method_33530(String criterionName, class_184 criterionTrigger) {
        return this;
    }

    public class_5797 method_33529(@Nullable String groupName) {
        return null;
    }

    public class_1792 method_36441() {
        if (!this.resultList.isEmpty()) {
            return this.resultList.get(0).stack().method_7909();
        }
        return null;
    }

    public void method_17972(Consumer<class_2444> finishedRecipeConsumer, class_2960 recipeId) {
        finishedRecipeConsumer.accept(new Result(recipeId.method_45138("baking_mat/"), this.ingredientList, this.processStages, this.resultList, this.tool, this.soundEventID == null ? "" : this.soundEventID));
    }

    public static class Result
    implements class_2444 {
        private final class_2960 id;
        private final List<class_1856> ingredientList;
        private final List<class_1856> processStages;
        private final List<ChanceResult> resultList;
        private final class_1856 tool;
        private String soundEventID;

        public Result(class_2960 id, List<class_1856> ingredientList, @Nullable List<class_1856> processStages, List<ChanceResult> resultList, class_1856 tool, String soundEventID) {
            this.id = id;
            this.ingredientList = ingredientList;
            this.processStages = processStages;
            this.resultList = resultList;
            this.tool = tool;
            this.soundEventID = soundEventID;
        }

        public void method_10416(JsonObject json) {
            JsonArray arrayIngredients = new JsonArray();
            for (class_1856 class_18562 : this.ingredientList) {
                arrayIngredients.add(class_18562.method_8089());
            }
            json.add("ingredients", (JsonElement)arrayIngredients);
            JsonArray arrayProcessStages = new JsonArray();
            if (this.processStages != null) {
                for (class_1856 processStage : this.processStages) {
                    arrayProcessStages.add(processStage.method_8089());
                }
            }
            json.add("processing_stages", (JsonElement)arrayProcessStages);
            JsonArray jsonArray = new JsonArray();
            for (ChanceResult result : this.resultList) {
                jsonArray.add(result.serialize());
            }
            json.add("result", (JsonElement)jsonArray);
            json.add("tool", this.tool.method_8089());
            if (!this.soundEventID.isEmpty()) {
                json.addProperty("sound", this.soundEventID);
            }
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return UbesDelightRecipeSerializersImpl.BAKING_MAT.get();
        }

        @Nullable
        public JsonObject method_10415() {
            return null;
        }

        @Nullable
        public class_2960 method_10418() {
            return null;
        }
    }
}

