/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block.entity.forge;

import com.chefmooon.ubesdelight.common.block.entity.BakingMatBlockEntity;
import com.chefmooon.ubesdelight.common.block.forge.BakingMatBlockImpl;
import com.chefmooon.ubesdelight.common.crafting.forge.BakingMatRecipeImpl;
import com.chefmooon.ubesdelight.common.mixin.accessor.RecipeManagerAccessor;
import com.chefmooon.ubesdelight.common.registry.UbesDelightAdvancements;
import com.chefmooon.ubesdelight.common.registry.UbesDelightSounds;
import com.chefmooon.ubesdelight.common.registry.forge.UbesDelightBlockEntityTypesImpl;
import com.chefmooon.ubesdelight.common.registry.forge.UbesDelightRecipeTypesImpl;
import com.chefmooon.ubesdelight.common.tag.CommonTags;
import com.chefmooon.ubesdelight.common.utility.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;

public class BakingMatBlockEntityImpl
extends SyncedBlockEntity {
    public static final int MAX_INGREDIENTS = 9;
    public static final int MAX_PROCESSING_STAGES = 5;
    public static final int MAX_RESULTS = 4;
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> this.inventory);
    private ResourceLocation lastRecipeId;

    public BakingMatBlockEntityImpl(BlockPos pos, BlockState state) {
        super((BlockEntityType)UbesDelightBlockEntityTypesImpl.BAKING_MAT_BAMBOO.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    public boolean processItemUsingTool(ItemStack tool, @Nullable Player player) {
        if (this.f_58857_ == null) {
            return false;
        }
        Optional<BakingMatRecipeImpl> matchingRecipe = this.getMatchingRecipe(new RecipeWrapper((IItemHandlerModifiable)this.inventory), tool, player);
        matchingRecipe.ifPresent(recipe -> {
            NonNullList<Ingredient> processStages = recipe.getProcessStages();
            List<ItemStack> ingredientContainers = this.getInventoryContainers(this.inventory);
            BlockPos blockPos = this.m_58899_();
            if (!recipe.getProcessStages().isEmpty()) {
                if (!((Boolean)this.m_58900_().m_61143_((Property)BakingMatBlockImpl.PROCESSING)).booleanValue()) {
                    if (!ingredientContainers.isEmpty()) {
                        this.spawnResults(ingredientContainers);
                    }
                    this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BakingMatBlockImpl.PROCESSING, (Comparable)Boolean.valueOf(true)));
                    this.clearInventory();
                    ItemStack itemStack = Arrays.stream(((Ingredient)processStages.get(0)).m_43908_()).findFirst().orElse(ItemStack.f_41583_);
                    this.inventory.setStackInSlot(0, itemStack);
                    BakingMatBlockEntityImpl.spawnParticles(this.f_58857_, this.m_58899_(), itemStack, 5);
                    this.inventoryChanged();
                } else if (((Boolean)this.m_58900_().m_61143_((Property)BakingMatBlockImpl.PROCESSING)).booleanValue()) {
                    int currentStage = this.getProcessStage(this.inventory.getStackInSlot(0), (List<Ingredient>)processStages);
                    if (currentStage < recipe.getProcessStages().size() - 1) {
                        ItemStack currentStageItem = this.inventory.getStackInSlot(0);
                        int nextStage = this.getNextProcessStage(currentStageItem, (List<Ingredient>)processStages);
                        if (!((Ingredient)processStages.get(nextStage)).m_43947_()) {
                            this.clearInventory();
                            ItemStack nextStageItem = Arrays.stream(((Ingredient)processStages.get(nextStage)).m_43908_()).findFirst().orElse(ItemStack.f_41583_);
                            BakingMatBlockEntityImpl.spawnParticles(this.f_58857_, this.m_58899_(), nextStageItem, 5);
                            this.inventory.setStackInSlot(0, nextStageItem);
                            this.inventoryChanged();
                        }
                    } else if (currentStage == recipe.getProcessStages().size() - 1) {
                        this.spawnRolledResults((BakingMatRecipeImpl)recipe, blockPos, this.f_58857_, tool, null);
                        this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BakingMatBlockImpl.PROCESSING, (Comparable)Boolean.valueOf(false)));
                    }
                }
            } else {
                this.spawnRolledResults((BakingMatRecipeImpl)recipe, blockPos, this.f_58857_, tool, ingredientContainers);
            }
            this.triggerAdvancement(player);
            this.damagetool(tool, player);
            this.playProcessingSound(recipe.getSoundEvent(), tool);
        });
        return matchingRecipe.isPresent();
    }

    private Optional<BakingMatRecipeImpl> getMatchingRecipe(RecipeWrapper recipeWrapper, ItemStack toolStack, @Nullable Player player) {
        Recipe recipe;
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        if (this.lastRecipeId != null && (recipe = ((RecipeManagerAccessor)this.f_58857_.m_7465_()).getRecipeMap((RecipeType)UbesDelightRecipeTypesImpl.BAKING_MAT.get()).get(this.lastRecipeId)) instanceof BakingMatRecipeImpl && recipe.m_5818_((Container)recipeWrapper, this.f_58857_) && ((BakingMatRecipeImpl)recipe).getTool().test(toolStack)) {
            return Optional.of((BakingMatRecipeImpl)recipe);
        }
        List recipeList = this.f_58857_.m_7465_().m_44056_((RecipeType)UbesDelightRecipeTypesImpl.BAKING_MAT.get(), (Container)recipeWrapper, this.f_58857_);
        if (recipeList.isEmpty()) {
            if (player != null) {
                player.m_5661_((Component)TextUtils.getTranslatable("tooltip.baking_mat.invalid_item", new Object[0]), true);
            }
            return Optional.empty();
        }
        Optional<BakingMatRecipeImpl> recipe2 = recipeList.stream().filter(bakingMatRecipeImpl -> bakingMatRecipeImpl.getTool().test(toolStack)).findFirst();
        if (recipe2.isEmpty()) {
            if (player != null) {
                player.m_5661_((Component)TextUtils.getTranslatable("tooltip.baking_mat.invalid_tool", new Object[0]), true);
            }
            return Optional.empty();
        }
        this.lastRecipeId = recipe2.get().m_6423_();
        return recipe2;
    }

    private void spawnRolledResults(BakingMatRecipeImpl recipe, BlockPos blockPos, Level level, ItemStack tool, @Nullable List<ItemStack> containers) {
        List<ItemStack> results = recipe.getRollResults(level.f_46441_, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)tool));
        if (containers != null && !containers.isEmpty()) {
            results.addAll(containers);
        }
        if (!results.isEmpty()) {
            BakingMatBlockEntityImpl.spawnParticles(level, blockPos, results.get(0).m_41777_(), 5);
            this.spawnResults(results);
            this.clearInventory();
        }
    }

    private void spawnResults(List<ItemStack> results) {
        for (ItemStack result : results) {
            Direction direction = ((Direction)this.m_58900_().m_61143_((Property)BakingMatBlockImpl.FACING)).m_122428_();
            ItemEntity entity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.2, (double)this.f_58858_.m_123342_() + 0.2, (double)this.f_58858_.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.2, result.m_41777_());
            entity.m_20334_((double)((float)direction.m_122429_() * 0.2f), 0.0, (double)((float)direction.m_122431_() * 0.2f));
            this.f_58857_.m_7967_((Entity)entity);
        }
    }

    private void playProcessingSound(String soundEventID, ItemStack tool) {
        this.playProcessingSound(soundEventID, tool, null);
    }

    private void playProcessingSound(String soundEventID, ItemStack tool, @Nullable ItemStack item) {
        SoundEvent sound = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(new ResourceLocation(soundEventID));
        if (sound != null) {
            this.playSound(sound, 1.0f, 1.0f);
        } else if (tool.m_204117_(CommonTags.C_TOOLS_ROLLING_PINS)) {
            this.playSound(UbesDelightSounds.BLOCK_BAKING_MAT_ROLLING_PIN.get(), 1.0f, 0.8f);
        }
    }

    private void playSound(SoundEvent sound, float volume, float pitch) {
        if (this.f_58857_ != null) {
            this.f_58857_.m_6263_(null, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f), sound, SoundSource.BLOCKS, volume, pitch);
        }
    }

    private void damagetool(ItemStack tool, Player player) {
        if (player != null) {
            tool.m_41622_(1, (LivingEntity)player, user -> user.m_21166_(EquipmentSlot.MAINHAND));
        } else if (tool.m_220157_(1, this.f_58857_.f_46441_, null)) {
            tool.m_41764_(0);
        }
    }

    private void triggerAdvancement(Player player) {
        if (player instanceof ServerPlayer) {
            UbesDelightAdvancements.BAKING_MAT.trigger((ServerPlayer)player);
        }
    }

    public static void spawnParticles(Level level, BlockPos pos, ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 vec3d = new Vec3(((double)level.f_46441_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)level.f_46441_.m_188501_() - 0.5) * 0.1);
            if (level instanceof ServerLevel) {
                ((ServerLevel)level).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.1f), (double)((float)pos.m_123343_() + 0.5f), 1, vec3d.f_82479_, vec3d.f_82480_ + 0.05, vec3d.f_82481_, 0.0);
                continue;
            }
            level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.1f), (double)((float)pos.m_123343_() + 0.5f), vec3d.f_82479_, vec3d.f_82480_ + 0.05, vec3d.f_82481_);
        }
    }

    private Integer getProcessStage(ItemStack itemStack, List<Ingredient> processStages) {
        Integer stage = 0;
        for (int i = 0; i < processStages.size(); ++i) {
            if (processStages.get(i).m_43947_()) continue;
            if (itemStack.m_150930_(Arrays.stream(processStages.get(i).m_43908_()).findFirst().get().m_41720_())) {
                return stage;
            }
            Integer n = stage;
            stage = stage + 1;
        }
        return stage;
    }

    private Integer getNextProcessStage(ItemStack itemStack, List<Ingredient> processStages) {
        Integer stage = 0;
        for (int i = 0; i < processStages.size(); ++i) {
            if (processStages.get(i).m_43947_()) continue;
            if (itemStack.m_150930_(Arrays.stream(processStages.get(i).m_43908_()).findFirst().get().m_41720_())) {
                if (i == processStages.size() - 1) {
                    return stage;
                }
                return stage + 1;
            }
            Integer n = stage;
            stage = stage + 1;
        }
        return stage;
    }

    private List<ItemStack> getInventoryContainers(ItemStackHandler inventory) {
        ArrayList<ItemStack> ingredientContainers = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemStack = inventory.getStackInSlot(i);
            if (itemStack.m_41619_() || itemStack.getCraftingRemainingItem().m_150930_(Items.f_41852_)) continue;
            ingredientContainers.add(itemStack.getCraftingRemainingItem());
        }
        return ingredientContainers;
    }

    public void clearInventory() {
        for (int i = 0; i < 9; ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public void setInventory(NonNullList<ItemStack> list) {
        for (int i = 0; i < 8; ++i) {
            this.inventory.setStackInSlot(i, (ItemStack)list.get(i));
        }
    }

    public int getContainerSize() {
        return 9;
    }

    public NonNullList<ItemStack> getItems() {
        NonNullList items = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
        for (int i = 0; i < 9; ++i) {
            items.set(i, (Object)this.inventory.getStackInSlot(i));
        }
        return items;
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).m_41619_();
    }

    public boolean isFull() {
        return !this.inventory.getStackInSlot(8).m_41619_();
    }

    public boolean addItem(ItemStack itemStack) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack inventoryStack = this.inventory.getStackInSlot(i);
            if (!inventoryStack.m_41619_()) continue;
            this.inventory.setStackInSlot(i, itemStack.m_41620_(1));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public ItemStack removeItem() {
        for (int i = 8; i >= 0; --i) {
            ItemStack itemStack = this.inventory.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
            this.inventoryChanged();
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public int getItemsQuantity() {
        int items = 0;
        for (int i = 0; i <= 8; ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.m_41619_()) continue;
            ++items;
        }
        return items;
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public Vec2 getItemOffset(int index) {
        return BakingMatBlockEntity.getItemOffset(index);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)ForgeCapabilities.ITEM_HANDLER)) {
            return this.inputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.inputHandler.invalidate();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(9){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                BakingMatBlockEntityImpl.this.inventoryChanged();
            }
        };
    }
}

