/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.crafting.ingredient;

import com.chefmooon.ubesdelight.UbesDelight;
import com.chefmooon.ubesdelight.common.Configuration;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record ChanceResult(ItemStack stack, float chance) {
    public static final ChanceResult EMPTY = new ChanceResult(ItemStack.f_41583_, 1.0f);

    public ItemStack rollOutput(RandomSource rand, int fortuneLevel) {
        int outputAmount = this.stack.m_41613_();
        double fortuneBonus = Configuration.bakingMatFortuneBonus() * (double)fortuneLevel;
        for (int roll = 0; roll < this.stack.m_41613_(); ++roll) {
            if (!((double)rand.m_188501_() > (double)this.chance + fortuneBonus)) continue;
            --outputAmount;
        }
        if (outputAmount == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack out = this.stack.m_41777_();
        out.m_41764_(outputAmount);
        return out;
    }

    public ItemStack rollStackOutput(RandomSource rand, int fortuneLevel) {
        int outputAmount = this.stack.m_41613_();
        double fortuneBonus = Configuration.bakingMatFortuneBonus() * (double)fortuneLevel;
        if ((double)rand.m_188501_() < (double)this.chance + fortuneBonus) {
            return new ItemStack((ItemLike)this.stack.m_41777_().m_41720_(), outputAmount);
        }
        return ItemStack.f_41583_;
    }

    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        ResourceLocation resourceLocation = BuiltInRegistries.f_257033_.m_7981_((Object)this.stack.m_41720_());
        json.addProperty("item", resourceLocation.toString());
        int count = this.stack.m_41613_();
        if (count != 1) {
            json.addProperty("count", (Number)count);
        }
        if (this.stack.m_41782_()) {
            json.add("nbt", new JsonParser().parse(this.stack.m_41783_().toString()));
        }
        if (this.chance != 1.0f) {
            json.addProperty("chance", (Number)Float.valueOf(this.chance));
        }
        return json;
    }

    public static ChanceResult deserialize(JsonElement je) {
        if (!je.isJsonObject()) {
            throw new JsonSyntaxException("Must be a json object");
        }
        JsonObject json = je.getAsJsonObject();
        String itemId = GsonHelper.m_13906_((JsonObject)json, (String)"item");
        int count = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
        float chance = GsonHelper.m_13820_((JsonObject)json, (String)"chance", (float)1.0f);
        ItemStack itemstack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(itemId)), count);
        if (GsonHelper.m_13894_((JsonObject)json, (String)"nbt")) {
            try {
                JsonElement element = json.get("nbt");
                itemstack.m_41751_(TagParser.m_129359_((String)(element.isJsonObject() ? UbesDelight.GSON.toJson(element) : GsonHelper.m_13805_((JsonElement)element, (String)"nbt"))));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        return new ChanceResult(itemstack, chance);
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130055_(this.stack());
        buf.writeFloat(this.chance());
    }

    public static ChanceResult read(FriendlyByteBuf buf) {
        return new ChanceResult(buf.m_130267_(), buf.readFloat());
    }
}

