/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.crafting.fabric;

import com.chefmooon.ubesdelight.common.crafting.BakingMatRecipe;
import com.chefmooon.ubesdelight.common.crafting.ingredient.ChanceResult;
import com.chefmooon.ubesdelight.common.registry.fabric.UbesDelightRecipeBookCategoriesImpl;
import com.chefmooon.ubesdelight.common.registry.fabric.UbesDelightRecipeSerializersImpl;
import com.chefmooon.ubesdelight.common.registry.fabric.UbesDelightRecipeTypesImpl;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_10355;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3414;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9875;
import net.minecraft.class_9887;
import vectorwing.farmersdelight.refabricated.inventory.RecipeWrapper;

public class BakingMatRecipeImpl
extends BakingMatRecipe
implements class_1860<RecipeWrapper> {
    public BakingMatRecipeImpl(String group, List<class_1856> ingredientList, List<class_1856> processStages, class_1856 tool, List<ChanceResult> resultList, Optional<class_3414> soundEvent) {
        super(group, ingredientList, processStages, tool, resultList, soundEvent);
    }

    public boolean method_8118() {
        return true;
    }

    public String method_8112() {
        return this.group;
    }

    public List<class_1856> getIngredients() {
        return this.ingredientList;
    }

    public List<class_1856> getProcessStages() {
        return this.processStages;
    }

    public List<class_1856> getIngredientsAndTool() {
        class_2371 ingredientTool = class_2371.method_10211();
        ingredientTool.addAll((Collection)this.ingredientList);
        ingredientTool.add((Object)this.tool);
        return this.ingredientList;
    }

    public class_1856 getTool() {
        return this.tool;
    }

    public List<class_1799> getResultList() {
        return this.getRollableResults().stream().map(ChanceResult::stack).collect(Collectors.toList());
    }

    public class_1799 getMandatoryResult() {
        return this.getRollableResults().stream().filter(chanceResult -> chanceResult.chance() == 1.0f).map(ChanceResult::stack).findFirst().get();
    }

    public List<class_1799> getMandatoryResults() {
        return this.getRollableResults().stream().filter(chanceResult -> chanceResult.chance() == 1.0f).map(ChanceResult::stack).toList();
    }

    public List<ChanceResult> getVariableResult() {
        return this.getRollableResults().stream().filter(chanceResult -> chanceResult.chance() != 1.0f).toList();
    }

    public List<ChanceResult> getRollableResults() {
        return this.resultList;
    }

    public boolean matches(RecipeWrapper inv, class_1937 level) {
        boolean inputMatch;
        boolean processMatch = false;
        class_9875 inputList = new class_9875();
        int i = 0;
        for (int j = 0; j < 9; ++j) {
            class_1799 itemStack = inv.method_59984(j);
            if (itemStack.method_7960()) continue;
            ++i;
            inputList.method_61536(itemStack, 1);
        }
        boolean bl = inputMatch = i == this.ingredientList.size() && inputList.method_61538((class_1860)this, null);
        if (!(inputMatch || this.processStages.isEmpty() || inv.method_59987())) {
            for (class_1856 ingredient : this.processStages) {
                if (!ingredient.method_8093(inv.method_59984(0))) continue;
                processMatch = true;
            }
        }
        return inputMatch || processMatch;
    }

    public class_1799 assemble(RecipeWrapper inv, class_7225.class_7874 provider) {
        return ((ChanceResult)this.resultList.get(0)).stack().method_7972();
    }

    public List<class_1799> getRollResults(class_5819 rand, int fortuneLevel) {
        ArrayList<class_1799> results = new ArrayList<class_1799>();
        List<ChanceResult> rollableResults = this.getRollableResults();
        for (ChanceResult output : rollableResults) {
            class_1799 stack = output.chance() == 1.0f ? output.stack() : output.rollStackOutput(rand, fortuneLevel);
            if (stack.method_7960()) continue;
            results.add(stack);
        }
        return results;
    }

    public class_1865<? extends class_1860<RecipeWrapper>> method_8119() {
        return UbesDelightRecipeSerializersImpl.BAKING_MAT.get();
    }

    public class_3956<? extends class_1860<RecipeWrapper>> method_17716() {
        return UbesDelightRecipeTypesImpl.BAKING_MAT.get();
    }

    public class_9887 method_61671() {
        if (this.placementInfo == null) {
            this.placementInfo = class_9887.method_61686((List)this.ingredientList);
        }
        return this.placementInfo;
    }

    public class_10355 method_64668() {
        return UbesDelightRecipeBookCategoriesImpl.BAKING_MAT.get();
    }

    public Optional<class_3414> getSoundEvent() {
        return this.soundEvent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BakingMatRecipeImpl that = (BakingMatRecipeImpl)o;
        if (!this.method_8112().equals(that.method_8112())) {
            return false;
        }
        if (!this.ingredientList.equals(that.ingredientList)) {
            return false;
        }
        if (!this.processStages.equals(that.processStages)) {
            return false;
        }
        if (!this.getTool().equals((Object)that.getTool())) {
            return false;
        }
        if (!this.getResultList().equals(that.getResultList())) {
            return false;
        }
        return Objects.equals(this.soundEvent, that.soundEvent);
    }

    public int hashCode() {
        int result = this.method_8112().hashCode();
        result = 31 * result + this.ingredientList.hashCode();
        result = 31 * result + this.processStages.hashCode();
        result = 31 * result + this.getTool().hashCode();
        result = 31 * result + this.getResultList().hashCode();
        result = 31 * result + this.soundEvent.map(Objects::hashCode).orElse(0);
        return result;
    }

    public static class Serializer
    implements class_1865<BakingMatRecipeImpl> {
        private static final MapCodec<BakingMatRecipeImpl> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(BakingMatRecipeImpl::method_8112), (App)class_1856.field_46095.listOf(1, 9).fieldOf("ingredients").forGetter(BakingMatRecipeImpl::getIngredients), (App)class_1856.field_46095.listOf(0, 5).fieldOf("processing_stages").forGetter(BakingMatRecipeImpl::getProcessStages), (App)class_1856.field_46095.fieldOf("tool").forGetter(BakingMatRecipeImpl::getTool), (App)Codec.list(ChanceResult.CODEC).fieldOf("result").forGetter(BakingMatRecipeImpl::getRollableResults), (App)class_3414.field_41698.optionalFieldOf("sound").forGetter(BakingMatRecipeImpl::getSoundEvent)).apply((Applicative)inst, BakingMatRecipeImpl::new));
        public static final class_9139<class_9129, BakingMatRecipeImpl> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<BakingMatRecipeImpl> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, BakingMatRecipeImpl> method_56104() {
            return STREAM_CODEC;
        }

        public static BakingMatRecipeImpl fromNetwork(class_9129 buf) {
            String groupIn = buf.method_10800(Short.MAX_VALUE);
            List ingredientList = (List)class_1856.field_48355.method_56433(class_9135.method_58000((int)9)).decode((Object)buf);
            List processingStagesList = (List)class_1856.field_48355.method_56433(class_9135.method_58000((int)5)).decode((Object)buf);
            class_1856 tool = (class_1856)class_1856.field_48355.decode((Object)buf);
            List resultsList = (List)ChanceResult.STREAM_CODEC.method_56433(class_9135.method_58000((int)4)).decode((Object)buf);
            Optional soundID = (Optional)class_9135.method_56382((class_9139)class_9135.method_56365((class_5321)class_7924.field_41225)).decode((Object)buf);
            return new BakingMatRecipeImpl(groupIn, ingredientList, processingStagesList, tool, resultsList, soundID);
        }

        public static void toNetwork(class_9129 buf, BakingMatRecipeImpl recipe) {
            buf.method_10814(recipe.group);
            class_1856.field_48355.method_56433(class_9135.method_58000((int)9)).encode((Object)buf, (Object)recipe.ingredientList);
            class_1856.field_48355.method_56433(class_9135.method_58000((int)5)).encode((Object)buf, (Object)recipe.processStages);
            class_1856.field_48355.encode((Object)buf, (Object)recipe.tool);
            ChanceResult.STREAM_CODEC.method_56433(class_9135.method_58000((int)4)).encode((Object)buf, (Object)recipe.resultList);
            class_9135.method_56382((class_9139)class_9135.method_56365((class_5321)class_7924.field_41225)).encode((Object)buf, recipe.getSoundEvent());
        }
    }
}

