/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.integration.eiv.baking_mat.fabric;

import com.chefmooon.ubesdelight.common.crafting.ingredient.ChanceResult;
import com.chefmooon.ubesdelight.common.utility.TextUtils;
import de.crafty.eiv.common.api.recipe.EivRecipeType;
import de.crafty.eiv.common.api.recipe.IEivServerRecipe;
import de.crafty.eiv.common.recipe.util.EivTagUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class BakingMatServerRecipe
implements IEivServerRecipe {
    public static final EivRecipeType<BakingMatServerRecipe> TYPE = EivRecipeType.register((class_2960)TextUtils.res("baking_mat"), () -> new BakingMatServerRecipe(null, null, null, null, null));
    private List<class_1856> inputs;
    private class_1856 toolInput;
    private List<ChanceResult> chanceOutputs;
    private List<class_1799> mandatoryOutputs;
    private List<class_1856> processStages;

    public BakingMatServerRecipe(List<class_1856> inputs, class_1856 tool, List<class_1856> processStages, List<class_1799> mandatoryOutputs, List<ChanceResult> chanceOutputs) {
        this.inputs = inputs;
        this.toolInput = tool;
        this.chanceOutputs = chanceOutputs;
        this.mandatoryOutputs = mandatoryOutputs;
        this.processStages = processStages;
    }

    public List<class_1856> getInputs() {
        return this.inputs;
    }

    public class_1856 getToolInput() {
        return this.toolInput;
    }

    public List<ChanceResult> getChanceOutputs() {
        return this.chanceOutputs;
    }

    public List<class_1799> getMandatoryOutputs() {
        return this.mandatoryOutputs;
    }

    public List<class_1856> getProcessStages() {
        return this.processStages;
    }

    public void writeToTag(class_2487 compoundTag) {
        compoundTag.method_10566("inputs", (class_2520)EivTagUtil.writeList(this.inputs, (origin, tag) -> EivTagUtil.writeIngredient((class_1856)origin)));
        compoundTag.method_10566("tool", (class_2520)EivTagUtil.writeIngredient((class_1856)this.toolInput));
        compoundTag.method_10566("processing_stages", (class_2520)EivTagUtil.writeList(this.processStages, (origin, tag) -> EivTagUtil.writeIngredient((class_1856)origin)));
        compoundTag.method_10566("mandatory_outputs", (class_2520)EivTagUtil.writeList(this.mandatoryOutputs, (origin, tag) -> EivTagUtil.encodeItemStack((class_1799)origin)));
        compoundTag.method_10566("chance_outputs", (class_2520)BakingMatServerRecipe.encodeRollableResult(this.chanceOutputs));
    }

    public void loadFromTag(class_2487 compoundTag) {
        this.inputs = EivTagUtil.readList((class_2487)compoundTag, (String)"inputs", EivTagUtil::readIngredient);
        this.toolInput = EivTagUtil.readIngredient((class_2487)compoundTag.method_10562("tool").orElseGet(class_2487::new));
        this.processStages = EivTagUtil.readList((class_2487)compoundTag, (String)"processing_stages", EivTagUtil::readIngredient);
        this.mandatoryOutputs = EivTagUtil.readList((class_2487)compoundTag, (String)"mandatory_outputs", EivTagUtil::decodeItemStack);
        this.chanceOutputs = BakingMatServerRecipe.decodeRollableResult(compoundTag.method_10580("chance_outputs"));
    }

    private static class_2499 encodeRollableResult(List<ChanceResult> rollableResults) {
        class_2499 listTag = new class_2499();
        for (ChanceResult rollableResult : rollableResults) {
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10566("item", (class_2520)EivTagUtil.encodeItemStack((class_1799)rollableResult.stack()));
            compoundTag.method_10548("chance", rollableResult.chance());
            listTag.add((Object)compoundTag);
        }
        return listTag;
    }

    private static List<ChanceResult> decodeRollableResult(class_2520 providedTag) {
        ArrayList<ChanceResult> list = new ArrayList<ChanceResult>();
        if (providedTag instanceof class_2499) {
            class_2499 listTag = (class_2499)providedTag;
            for (class_2520 tag : listTag) {
                class_2487 compoundTag = tag.method_68571().orElseGet(class_2487::new);
                class_1799 stack = EivTagUtil.decodeItemStack((class_2487)compoundTag.method_68568("item"));
                float chance = compoundTag.method_66563("chance", 1.0f);
                ChanceResult chanceResult = new ChanceResult(stack, chance);
                list.add(chanceResult);
            }
        }
        return list;
    }

    public EivRecipeType<? extends IEivServerRecipe> getRecipeType() {
        return TYPE;
    }
}

