/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.integration.eiv.baking_mat.fabric;

import com.chefmooon.ubesdelight.common.utility.TextUtils;
import com.chefmooon.ubesdelight.integration.eiv.baking_mat.fabric.BakingMatServerRecipe;
import com.chefmooon.ubesdelight.integration.eiv.baking_mat.fabric.BakingMatViewType;
import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class BakingMatViewRecipe
implements IEivViewRecipe {
    private final List<SlotContent> inputs = new ArrayList<SlotContent>();
    private final SlotContent toolInput;
    private final LinkedHashMap<SlotContent, Float> chanceOutputs;
    private final List<SlotContent> mandatoryOutputs;
    private final List<SlotContent> processStages;

    public BakingMatViewRecipe(BakingMatServerRecipe recipe) {
        recipe.getInputs().forEach(ingredient -> this.inputs.add(SlotContent.of((class_1856)ingredient)));
        this.toolInput = SlotContent.of((class_1856)recipe.getToolInput());
        this.chanceOutputs = new LinkedHashMap();
        recipe.getChanceOutputs().forEach(ingredient -> this.chanceOutputs.put(SlotContent.of((class_1799)ingredient.stack()), Float.valueOf(ingredient.chance())));
        this.mandatoryOutputs = new ArrayList<SlotContent>();
        recipe.getMandatoryOutputs().forEach(ingredient -> this.mandatoryOutputs.add(SlotContent.of((class_1792)ingredient.method_7909())));
        this.processStages = new ArrayList<SlotContent>();
        recipe.getProcessStages().forEach(ingredient -> this.processStages.add(SlotContent.of((class_1856)ingredient)));
    }

    public IEivRecipeViewType getViewType() {
        return BakingMatViewType.INSTANCE;
    }

    public void bindSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        int i;
        for (i = 0; i < this.inputs.size() && i < 9; ++i) {
            slotFillContext.bindOptionalSlot(i, this.inputs.get(i), BakingMatSlotRenderer.DEFAULT);
        }
        slotFillContext.bindOptionalSlot(9, this.toolInput, BakingMatSlotRenderer.DEFAULT);
        for (i = 0; i < this.mandatoryOutputs.size() && i < 4; ++i) {
            slotFillContext.bindOptionalSlot(10 + i, this.mandatoryOutputs.get(i), BakingMatSlotRenderer.DEFAULT);
        }
        for (i = 0; i < this.chanceOutputs.size() && i < 4; ++i) {
            SlotContent content = (SlotContent)this.chanceOutputs.keySet().toArray()[i];
            slotFillContext.bindOptionalSlot(14 + i, content, BakingMatSlotRenderer.CHANCE);
        }
        for (i = 0; i < this.processStages.size() && i < 5; ++i) {
            slotFillContext.bindOptionalSlot(18 + i, this.processStages.get(i), BakingMatSlotRenderer.DEFAULT);
        }
    }

    public List<SlotContent> getIngredients() {
        ArrayList<SlotContent> ingredients = new ArrayList<SlotContent>(this.inputs);
        ingredients.add(this.toolInput);
        ingredients.addAll(this.processStages);
        return ingredients;
    }

    public List<SlotContent> getResults() {
        ArrayList<SlotContent> results = new ArrayList<SlotContent>(this.mandatoryOutputs);
        results.addAll(this.chanceOutputs.keySet());
        results.addAll(this.processStages);
        return results;
    }

    public static interface BakingMatSlotRenderer {
        public static final class_2960 TEXTURE = TextUtils.res("textures/gui/emi/baking_mat.png");
        public static final RecipeViewMenu.OptionalSlotRenderer DEFAULT = (guiGraphics, mouseX, mouseY, partialTicks) -> guiGraphics.method_25290(class_1921::method_62277, TEXTURE, 0, 0, 0.0f, 80.0f, 18, 18, 256, 256);
        public static final RecipeViewMenu.OptionalSlotRenderer CHANCE = (guiGraphics, mouseX, mouseY, partialTicks) -> guiGraphics.method_25290(class_1921::method_62277, TEXTURE, 0, 0, 18.0f, 80.0f, 18, 18, 256, 256);

        public void render(class_332 var1, int var2, int var3, float var4);
    }
}

