/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block;

import com.chefmooon.ubesdelight.common.block.LemongrassStalkCropBlock;
import com.chefmooon.ubesdelight.common.registry.UbesDelightBlocks;
import com.chefmooon.ubesdelight.common.registry.UbesDelightItems;
import com.chefmooon.ubesdelight.common.utility.BuiltInRegistryUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LemongrassLeafCropBlock
extends CropBlock {
    public static final IntegerProperty lEMONGRASS_AGE = BlockStateProperties.AGE_3;
    public static final int MAX_AGE = 3;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0)};

    public LemongrassLeafCropBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT));
    }

    public boolean isRandomlyTicking(BlockState state) {
        return !this.isMaxAge(state);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float growthSpeed;
        int age;
        if (!level.hasChunksAt(pos.offset(-1, -1, -1), pos.offset(1, 1, 1))) {
            return;
        }
        if (level.getRawBrightness(pos, 0) >= 6 && (age = this.getAge(state)) <= this.getMaxAge() && random.nextInt((int)(25.0f / (growthSpeed = LemongrassLeafCropBlock.getGrowthSpeed(level.getBlockState(pos.below()).getBlock(), (BlockGetter)level, pos.below()))) + 1) == 0) {
            if (age == this.getMaxAge()) {
                LemongrassLeafCropBlock lemongrassUpper = (LemongrassLeafCropBlock)BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEMONGRASS_LEAF_CROP);
                if (lemongrassUpper.defaultBlockState().canSurvive((LevelReader)level, pos.above()) && level.isEmptyBlock(pos.above())) {
                    level.setBlockAndUpdate(pos.above(), lemongrassUpper.defaultBlockState());
                }
            } else {
                level.setBlockAndUpdate(pos, this.withAge(age + 1));
            }
        }
    }

    protected static float getGrowthSpeed(Block block, BlockGetter level, BlockPos pos) {
        boolean northSouth;
        float growthSpeed = 1.0f;
        BlockPos blockPos = pos.below();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                float farmlandBonus = 0.0f;
                BlockState blockStateBelow = level.getBlockState(blockPos.offset(x, 0, y));
                if (blockStateBelow.is(Blocks.FARMLAND)) {
                    farmlandBonus = 1.0f;
                    if (blockStateBelow.hasProperty((Property)FarmBlock.MOISTURE) && (Integer)blockStateBelow.getValue((Property)FarmBlock.MOISTURE) > 0) {
                        farmlandBonus = 3.0f;
                    }
                }
                if (x != 0 || y != 0) {
                    farmlandBonus /= 4.0f;
                }
                growthSpeed += farmlandBonus;
            }
        }
        BlockPos blockPosNorth = pos.north();
        BlockPos blockPosSouth = pos.south();
        BlockPos blockPosWest = pos.west();
        BlockPos blockPosEast = pos.east();
        boolean eastWest = level.getBlockState(blockPosWest).is(block) || level.getBlockState(blockPosEast).is(block);
        boolean bl = northSouth = level.getBlockState(blockPosNorth).is(block) || level.getBlockState(blockPosSouth).is(block);
        if (eastWest && northSouth) {
            growthSpeed /= 2.0f;
        } else {
            boolean diagonal;
            boolean bl2 = diagonal = level.getBlockState(blockPosWest.north()).is(block) || level.getBlockState(blockPosEast.north()).is(block) || level.getBlockState(blockPosEast.south()).is(block) || level.getBlockState(blockPosWest.south()).is(block);
            if (diagonal) {
                growthSpeed /= 2.0f;
            }
        }
        return growthSpeed;
    }

    public IntegerProperty getAgeProperty() {
        return lEMONGRASS_AGE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.getValue((Property)this.getAgeProperty())];
    }

    public int getMaxAge() {
        return 3;
    }

    public BlockState withAge(int age) {
        return (BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    protected ItemLike getBaseSeedId() {
        return BuiltInRegistryUtil.getItem(UbesDelightItems.LEMONGRASS);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{lEMONGRASS_AGE});
    }

    protected int getBonemealAgeIncrease(Level level) {
        return super.getBonemealAgeIncrease(level) / 2;
    }

    public boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEMONGRASS_STALK_CROP));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockStateBelow = level.getBlockState(pos.below());
        Block block = blockStateBelow.getBlock();
        if (block instanceof LemongrassStalkCropBlock) {
            LemongrassStalkCropBlock lemongrassStalkCropBlock = (LemongrassStalkCropBlock)block;
            return lemongrassStalkCropBlock.isMaxAge(blockStateBelow) && (level.getRawBrightness(pos, 0) >= 6 || level.canSeeSky(pos));
        }
        return super.canSurvive(state, level, pos);
    }
}

