/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block;

import com.chefmooon.ubesdelight.common.block.LemongrassLeafCropBlock;
import com.chefmooon.ubesdelight.common.registry.UbesDelightBlocks;
import com.chefmooon.ubesdelight.common.registry.UbesDelightItems;
import com.chefmooon.ubesdelight.common.tag.CommonTags;
import com.chefmooon.ubesdelight.common.utility.BuiltInRegistryUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.registry.ModBlocks;

public class LemongrassStalkCropBlock
extends CropBlock {
    public static final IntegerProperty LEMONGRASS_AGE = BlockStateProperties.AGE_5;
    public static final BooleanProperty SUPPORTING = BooleanProperty.create((String)"supporting");
    public static final int MAX_AGE = 5;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)};

    public LemongrassStalkCropBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT).strength(0.2f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LEMONGRASS_AGE, (Comparable)Integer.valueOf(0))).setValue((Property)SUPPORTING, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)SUPPORTING) == false || !this.isMaxAge(state);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float growthSpeed;
        int age;
        if (!level.hasChunksAt(pos.offset(-1, -1, -1), pos.offset(1, 1, 1))) {
            return;
        }
        if (level.getRawBrightness(pos, 0) >= 6 && (age = this.getAge(state)) <= this.getMaxAge() && random.nextInt((int)(25.0f / (growthSpeed = LemongrassStalkCropBlock.getGrowthSpeed(state.getBlock(), (BlockGetter)level, pos))) + 1) == 0) {
            if (age == this.getMaxAge()) {
                LemongrassLeafCropBlock lemongrassUpper = (LemongrassLeafCropBlock)BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEMONGRASS_LEAF_CROP);
                if (lemongrassUpper.defaultBlockState().canSurvive((LevelReader)level, pos.above()) && level.isEmptyBlock(pos.above())) {
                    level.setBlockAndUpdate(pos.above(), lemongrassUpper.defaultBlockState());
                }
            } else {
                level.setBlockAndUpdate(pos, this.withAge(age + 1));
            }
        }
    }

    protected static float getGrowthSpeed(Block block, BlockGetter level, BlockPos pos) {
        boolean northSouth;
        float growthSpeed = 1.0f;
        BlockPos blockPos = pos.below();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                float farmlandBonus = 0.0f;
                BlockState blockStateBelow = level.getBlockState(blockPos.offset(x, 0, y));
                if (blockStateBelow.is(Blocks.FARMLAND)) {
                    farmlandBonus = 1.0f;
                    if (blockStateBelow.hasProperty((Property)FarmBlock.MOISTURE) && (Integer)blockStateBelow.getValue((Property)FarmBlock.MOISTURE) > 0) {
                        farmlandBonus = 3.0f;
                    }
                }
                if (x != 0 || y != 0) {
                    farmlandBonus /= 4.0f;
                }
                growthSpeed += farmlandBonus;
            }
        }
        BlockPos blockPosNorth = pos.north();
        BlockPos blockPosSouth = pos.south();
        BlockPos blockPosWest = pos.west();
        BlockPos blockPosEast = pos.east();
        boolean eastWest = level.getBlockState(blockPosWest).is(block) || level.getBlockState(blockPosEast).is(block);
        boolean bl = northSouth = level.getBlockState(blockPosNorth).is(block) || level.getBlockState(blockPosSouth).is(block);
        if (eastWest && northSouth) {
            growthSpeed /= 2.0f;
        } else {
            boolean diagonal;
            boolean bl2 = diagonal = level.getBlockState(blockPosWest.north()).is(block) || level.getBlockState(blockPosEast.north()).is(block) || level.getBlockState(blockPosEast.south()).is(block) || level.getBlockState(blockPosWest.south()).is(block);
            if (diagonal) {
                growthSpeed /= 2.0f;
            }
        }
        return growthSpeed;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.getValue((Property)this.getAgeProperty())];
    }

    public boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(Blocks.FARMLAND) || state.is(CommonTags.C_FARMLAND) || state.is((Block)ModBlocks.RICH_SOIL.get());
    }

    protected IntegerProperty getAgeProperty() {
        return LEMONGRASS_AGE;
    }

    public int getAge(BlockState state) {
        return (Integer)state.getValue((Property)this.getAgeProperty());
    }

    public int getMaxAge() {
        return 5;
    }

    protected ItemLike getBaseSeedId() {
        return BuiltInRegistryUtil.getItemLike(UbesDelightItems.LEMONGRASS_SEEDS);
    }

    public BlockState withAge(int age) {
        return (BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LEMONGRASS_AGE, SUPPORTING});
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockState state = super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
        if (!state.isAir() && facing == Direction.UP) {
            return (BlockState)state.setValue((Property)SUPPORTING, (Comparable)Boolean.valueOf(this.isSupportingLemongrass(facingState)));
        }
        return state;
    }

    public boolean isSupportingLemongrass(BlockState topState) {
        return topState.getBlock() == BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEMONGRASS_LEAF_CROP);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        BlockState upperState = level.getBlockState(pos.above());
        if (upperState.getBlock() instanceof LemongrassLeafCropBlock) {
            return !((LemongrassLeafCropBlock)upperState.getBlock()).isMaxAge(upperState);
        }
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    protected int getBonemealAgeIncrease(Level level) {
        return Mth.nextInt((RandomSource)level.random, (int)1, (int)5);
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int ageGrowth = Math.min(this.getAge(state) + this.getBonemealAgeIncrease((Level)level), 6);
        if (ageGrowth <= this.getMaxAge()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LEMONGRASS_AGE, (Comparable)Integer.valueOf(ageGrowth)));
        } else {
            BlockState top = level.getBlockState(pos.above());
            if (top.getBlock() == BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEMONGRASS_LEAF_CROP)) {
                BonemealableBlock growable = (BonemealableBlock)level.getBlockState(pos.above()).getBlock();
                if (growable.isValidBonemealTarget((LevelReader)level, pos.above(), top)) {
                    growable.performBonemeal(level, level.random, pos.above(), top);
                }
            } else {
                LemongrassLeafCropBlock lemongrassLeafCropBlock = (LemongrassLeafCropBlock)BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEMONGRASS_LEAF_CROP);
                int remainingGrowth = ageGrowth - this.getMaxAge() - 1;
                if (lemongrassLeafCropBlock.defaultBlockState().canSurvive((LevelReader)level, pos.above()) && level.isEmptyBlock(pos.above())) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LEMONGRASS_AGE, (Comparable)Integer.valueOf(this.getMaxAge())));
                    level.setBlock(pos.above(), (BlockState)lemongrassLeafCropBlock.defaultBlockState().setValue((Property)LemongrassLeafCropBlock.lEMONGRASS_AGE, (Comparable)Integer.valueOf(remainingGrowth)), 2);
                }
            }
        }
    }
}

