/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block.entity.dispenser;

import com.chefmooon.ubesdelight.common.block.entity.dispenser.neoforge.BaseLeafFeastDispenseBehaviorImpl;
import com.chefmooon.ubesdelight.common.block.leaf_feast.base.BaseLeafFeastBlock;
import com.chefmooon.ubesdelight.common.block.leaf_feast.base.LargeLeafFeastBlock;
import com.chefmooon.ubesdelight.common.block.leaf_feast.base.SimpleLeafFeastBlock;
import com.chefmooon.ubesdelight.common.core.LeafFeastTypes;
import com.chefmooon.ubesdelight.common.utility.ItemStackUtil;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

@MethodsReturnNonnullByDefault
public class BaseLeafFeastDispenseBehavior
extends OptionalDispenseItemBehavior {
    protected ItemStack execute(BlockSource source, ItemStack stack) {
        ServerLevel serverLevel = source.level();
        if (!serverLevel.isClientSide()) {
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            Position position = DispenserBlock.getDispensePosition((BlockSource)source);
            BlockPos blockPos = source.pos().relative(direction);
            this.setSuccess(BaseLeafFeastDispenseBehavior.tryAddServing(serverLevel, stack, blockPos));
            ItemStack itemStack = stack.split(1);
            this.playSound(source);
            if (this.isSuccess()) {
                ItemStack container = ItemStackUtil.getContainer(itemStack);
                if (!container.isEmpty()) {
                    BaseLeafFeastDispenseBehavior.spawnItem((Level)source.level(), (ItemStack)container, (int)6, (Direction)direction, (Position)position);
                }
            } else {
                BaseLeafFeastDispenseBehavior.spawnItem((Level)source.level(), (ItemStack)itemStack, (int)6, (Direction)direction, (Position)position);
            }
        }
        return stack;
    }

    public static boolean tryAddServing(ServerLevel level, ItemStack item, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof SimpleLeafFeastBlock) {
            SimpleLeafFeastBlock simpleLeafFeastBlock = (SimpleLeafFeastBlock)block;
            if (item.is(simpleLeafFeastBlock.servingItem.get())) {
                int servings = (Integer)state.getValue((Property)SimpleLeafFeastBlock.SERVINGS);
                LeafFeastTypes leafFeastType = (LeafFeastTypes)((Object)state.getValue((Property)BaseLeafFeastBlock.LEAF_FEAST_TYPE));
                if (leafFeastType == LeafFeastTypes.TIP || leafFeastType == LeafFeastTypes.END ? servings < 3 : servings < 6) {
                    return simpleLeafFeastBlock.addItemFromDispenser(item, level, pos, state);
                }
            }
        } else {
            block = state.getBlock();
            if (block instanceof LargeLeafFeastBlock) {
                LargeLeafFeastBlock largeLeafFeastBlock = (LargeLeafFeastBlock)block;
                return largeLeafFeastBlock.addItemFromDispenser(item, level, pos, state);
            }
            block = state.getBlock();
            if (block instanceof BaseLeafFeastBlock) {
                BaseLeafFeastBlock baseLeafFeastBlock = (BaseLeafFeastBlock)block;
                return baseLeafFeastBlock.addItemFromDispenser(item, level, pos, state);
            }
        }
        return false;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void register() {
        BaseLeafFeastDispenseBehaviorImpl.register();
    }
}

