/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block.entity.neoforge;

import com.chefmooon.ubesdelight.common.block.entity.UniversalLeafFeastBlockEntity;
import com.chefmooon.ubesdelight.common.core.LeafFeastTypes;
import com.chefmooon.ubesdelight.common.registry.neoforge.UbesDelightBlockEntityTypesImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;

public class UniversalLeafFeastBlockEntityImpl
extends SyncedBlockEntity {
    public static final int MAX_ITEMS = 6;
    private final ItemStackHandler inventory = this.createHandler();

    public UniversalLeafFeastBlockEntityImpl(BlockPos pos, BlockState state) {
        super(UbesDelightBlockEntityTypesImpl.UNIVERSAL_LEAF_FEAST.get(), pos, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
    }

    public void clearInventory() {
        for (int i = 0; i < 6; ++i) {
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public void setInventory(NonNullList<ItemStack> list) {
        for (int i = 0; i < 5; ++i) {
            this.inventory.setStackInSlot(i, (ItemStack)list.get(i));
        }
    }

    public int getContainerSize() {
        return 6;
    }

    public NonNullList<ItemStack> getItems() {
        NonNullList items = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
        for (int i = 0; i < 6; ++i) {
            items.set(i, (Object)this.inventory.getStackInSlot(i));
        }
        return items;
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).isEmpty();
    }

    public boolean isFull() {
        return !this.inventory.getStackInSlot(5).isEmpty();
    }

    public boolean addItem(Player player, ItemStack itemStack) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack inventoryStack = this.inventory.getStackInSlot(i);
            if (!inventoryStack.isEmpty()) continue;
            this.inventory.setStackInSlot(i, itemStack.split(1));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public ItemStack removeItem() {
        for (int i = 5; i >= 0; --i) {
            ItemStack itemStack = this.inventory.getStackInSlot(i);
            if (itemStack.isEmpty()) continue;
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
            this.inventoryChanged();
            return itemStack;
        }
        return ItemStack.EMPTY;
    }

    public int getItemsQuantity() {
        int items = 0;
        for (int i = 0; i <= 5; ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.isEmpty()) continue;
            ++items;
        }
        return items;
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public Vec2 getItemOffset(int index, LeafFeastTypes leafFeastType) {
        return UniversalLeafFeastBlockEntity.getItemOffset(index, leafFeastType);
    }

    public void setRemoved() {
        super.setRemoved();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(6){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                UniversalLeafFeastBlockEntityImpl.this.inventoryChanged();
            }
        };
    }
}

