/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block.leaf_feast.base;

import com.chefmooon.ubesdelight.common.block.leaf_feast.base.LargeLeafFeastBlock;
import com.chefmooon.ubesdelight.common.block.leaf_feast.base.LeafFeastBlock;
import com.chefmooon.ubesdelight.common.block.leaf_feast.base.neoforge.BaseLeafFeastBlockImpl;
import com.chefmooon.ubesdelight.common.core.LeafFeastTypes;
import com.chefmooon.ubesdelight.common.registry.UbesDelightBlocks;
import com.chefmooon.ubesdelight.common.registry.UbesDelightItems;
import com.chefmooon.ubesdelight.common.utility.BuiltInRegistryUtil;
import com.chefmooon.ubesdelight.common.utility.ItemStackUtil;
import com.chefmooon.ubesdelight.common.utility.VoxelShapeUtil;
import com.mojang.datafixers.util.Pair;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BaseLeafFeastBlock
extends Block
implements LeafFeastBlock,
SimpleWaterloggedBlock {
    protected final VoxelShape[] CONNECT_SHAPES = VoxelShapeUtil.getRotatedShapes(NORTH_CONNECT_SHAPE);
    protected final VoxelShape[] TIP_SHAPES = VoxelShapeUtil.getRotatedShapes(LEAF_NORTH_TIP_SHAPE);
    protected final VoxelShape[] END_SHAPES = VoxelShapeUtil.getRotatedShapes(LEAF_NORTH_END_SHAPE);

    public BaseLeafFeastBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (level.isClientSide() && (heldItem.isEmpty() ? this.tryRemoveItem(state, level, pos, player, hand).consumesAction() : this.tryAddItem(state, level, pos, player, hand).consumesAction())) {
            return ItemInteractionResult.SUCCESS;
        }
        if (heldItem.isEmpty()) {
            return this.tryRemoveItem(state, level, pos, player, hand);
        }
        return this.tryAddItem(state, level, pos, player, hand);
    }

    protected ItemInteractionResult tryAddItem(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (!player.isShiftKeyDown() && this.addItem(heldItem, state, level, pos, player).consumesAction()) {
            return ItemInteractionResult.SUCCESS;
        }
        if (heldItem.has(DataComponents.FOOD)) {
            return BaseLeafFeastBlock.transformToUniversal(heldItem, state, level, pos, player);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemInteractionResult transformToUniversal(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return BaseLeafFeastBlockImpl.transformToUniversal(itemStack, (BlockState)var1_1, (Level)var2_2, (BlockPos)var3_3, (Player)var4_4);
    }

    private ItemInteractionResult addItem(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player) {
        Block block = BaseLeafFeastBlock.getLeafFeastBlock(itemStack);
        if (block != Blocks.AIR) {
            BlockState newState = (BlockState)this.getTransformState(block, state).setValue((Property)SERVINGS, (Comparable)Integer.valueOf(1));
            if (block instanceof LargeLeafFeastBlock && (state.getValue((Property)LEAF_FEAST_TYPE) == LeafFeastTypes.END || state.getValue((Property)LEAF_FEAST_TYPE) == LeafFeastTypes.TIP)) {
                newState = (BlockState)newState.setValue((Property)LEAF_FEAST_TYPE, (Comparable)((Object)LeafFeastTypes.MIDDLE));
            }
            if (level.setBlock(pos, newState, 3)) {
                if (!player.getAbilities().instabuild) {
                    itemStack.split(1);
                    ItemStack container = ItemStackUtil.getContainer(itemStack);
                    if (!container.isEmpty() && !player.getInventory().add(container)) {
                        player.drop(container, false);
                    }
                }
                this.playAddSound(level, pos);
                LeafFeastBlock.triggerInsertAdvancement(player);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static void tryEat(ItemStack itemStack, Level level, BlockPos pos, Player player) {
        ItemStack container = ItemStackUtil.getContainer(itemStack);
        if (!container.isEmpty()) {
            BaseLeafFeastBlock.spawnContainer(level, pos, player.getDirection().getOpposite(), container);
        }
        player.eat(level, itemStack);
        LeafFeastBlock.triggerConsumeAdvancement(player);
    }

    public static void spawnContainer(Level level, BlockPos blockPos, Direction direction, ItemStack itemStack) {
        ItemEntity entity = new ItemEntity(level, (double)blockPos.getX() + 0.5 + (double)direction.getStepX() * 0.2, (double)blockPos.getY() + 0.2, (double)blockPos.getZ() + 0.5 + (double)direction.getStepZ() * 0.2, itemStack.copy());
        entity.setDeltaMovement((double)((float)direction.getStepX() * 0.2f), 0.0, (double)((float)direction.getStepZ() * 0.2f));
        level.addFreshEntity((Entity)entity);
    }

    public boolean addItemFromDispenser(ItemStack itemStack, ServerLevel level, BlockPos pos, BlockState state) {
        Block block = BaseLeafFeastBlock.getLeafFeastBlock(itemStack);
        if (block != null && block != Blocks.AIR && level.setBlock(pos, (BlockState)this.getTransformState(block, state).setValue((Property)SERVINGS, (Comparable)Integer.valueOf(1)), 3)) {
            this.playAddSound((Level)level, pos);
            return true;
        }
        return false;
    }

    public static Block getLeafFeastBlock(ItemStack itemStack) {
        if (itemStack.is(BuiltInRegistryUtil.getItem(UbesDelightItems.ENSAYMADA))) {
            return BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST_ENSAYMADA);
        }
        if (itemStack.is(BuiltInRegistryUtil.getItem(UbesDelightItems.ENSAYMADA_UBE))) {
            return BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST_ENSAYMADA_UBE);
        }
        if (itemStack.is(BuiltInRegistryUtil.getItem(UbesDelightItems.PANDESAL))) {
            return BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST_PANDESAL);
        }
        if (itemStack.is(BuiltInRegistryUtil.getItem(UbesDelightItems.PANDESAL_UBE))) {
            return BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST_PANDESAL_UBE);
        }
        if (itemStack.is(BuiltInRegistryUtil.getItem(UbesDelightItems.HOPIA_MUNGGO))) {
            return BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST_HOPIA_MUNGGO);
        }
        if (itemStack.is(BuiltInRegistryUtil.getItem(UbesDelightItems.HOPIA_UBE))) {
            return BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST_HOPIA_UBE);
        }
        if (itemStack.is(BuiltInRegistryUtil.getItem(UbesDelightItems.LUMPIA))) {
            return BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LUMPIA_FEAST);
        }
        if (itemStack.is((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"cooked_rice")))) {
            return BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST_COOKED_RICE);
        }
        if (itemStack.is((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"fried_rice")))) {
            return BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST_FRIED_RICE);
        }
        if (itemStack.is(BuiltInRegistryUtil.getItem(UbesDelightItems.SINANGAG))) {
            return BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST_SINANGAG);
        }
        return Blocks.AIR;
    }

    protected ItemInteractionResult tryRemoveItem(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        LeafFeastTypes leafFeastType = (LeafFeastTypes)((Object)state.getValue((Property)LEAF_FEAST_TYPE));
        return Shapes.or((VoxelShape)this.getConnectShape(leafFeastType, this.getConnectDirections(facing.getOpposite()), this.CONNECT_SHAPES), (VoxelShape)this.getBaseShape(leafFeastType, facing, this.TIP_SHAPES, this.END_SHAPES, LEAF_BASE_SHAPE));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockPos = context.getClickedPos();
        FluidState fluid = context.getLevel().getFluidState(blockPos);
        Level blockGetter = context.getLevel();
        Direction facing = context.getHorizontalDirection();
        Pair connectDirections = this.getConnectDirections(facing.getOpposite());
        BlockState rightBlockState = blockGetter.getBlockState(blockPos.relative((Direction)connectDirections.getSecond()));
        BlockState leftBlockState = blockGetter.getBlockState(blockPos.relative((Direction)connectDirections.getFirst()));
        LeafFeastTypes leafFeastType = this.getLeafFeastType(this.placementConnectsTo(facing, leftBlockState), this.placementConnectsTo(facing, rightBlockState));
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)LEAF_FEAST_TYPE, (Comparable)((Object)leafFeastType))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        Pair connectDirections;
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (direction == (connectDirections = this.getConnectDirections(((Direction)state.getValue((Property)FACING)).getOpposite())).getFirst() || direction == connectDirections.getSecond()) {
            LeafFeastTypes leafFeastType = this.getLeafFeastType(this.connectsTo(state, level.getBlockState(pos.relative((Direction)connectDirections.getFirst()))), this.connectsTo(state, level.getBlockState(pos.relative((Direction)connectDirections.getSecond()))));
            if ((Integer)state.getValue((Property)SERVINGS) > 3) {
                if (leafFeastType == LeafFeastTypes.END || leafFeastType == LeafFeastTypes.TIP) {
                    return (BlockState)state.setValue((Property)LEAF_FEAST_TYPE, (Comparable)((Object)LeafFeastTypes.MIDDLE));
                }
                return (BlockState)state.setValue((Property)LEAF_FEAST_TYPE, (Comparable)((Object)leafFeastType));
            }
            return (BlockState)state.setValue((Property)LEAF_FEAST_TYPE, (Comparable)((Object)leafFeastType));
        }
        if (direction == Direction.DOWN && !state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, FACING, SERVINGS, LEAF_FEAST_TYPE});
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isSolid();
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }
}

