/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block.leaf_feast.base;

import com.chefmooon.ubesdelight.common.block.leaf_feast.base.BaseLeafFeastBlock;
import com.chefmooon.ubesdelight.common.block.leaf_feast.base.LeafFeastBlock;
import com.chefmooon.ubesdelight.common.core.LeafFeastTypes;
import com.chefmooon.ubesdelight.common.registry.UbesDelightBlocks;
import com.chefmooon.ubesdelight.common.registry.UbesDelightDataComponentTypes;
import com.chefmooon.ubesdelight.common.utility.BuiltInRegistryUtil;
import com.chefmooon.ubesdelight.common.utility.ItemStackUtil;
import com.chefmooon.ubesdelight.common.utility.TextUtils;
import com.chefmooon.ubesdelight.common.utility.VoxelShapeUtil;
import com.mojang.datafixers.util.Pair;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SimpleLeafFeastBlock
extends BaseLeafFeastBlock {
    public Supplier<Item> servingItem;
    protected final ConcurrentHashMap<LeafFeastTypes, ConcurrentHashMap<Integer, VoxelShape[]>> FEAST_VARIANTS_SERVINGS;

    public SimpleLeafFeastBlock(Supplier<Item> servingItem, BlockBehaviour.Properties properties, ConcurrentHashMap<LeafFeastTypes, ConcurrentHashMap<Integer, VoxelShape>> voxelShapes) {
        super(properties);
        this.servingItem = servingItem;
        this.FEAST_VARIANTS_SERVINGS = VoxelShapeUtil.getRotatedShapes(voxelShapes);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SERVINGS, (Comparable)Integer.valueOf(6)));
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (level.isClientSide() && (heldItem.isEmpty() || heldItem.is(Items.BOWL) ? this.tryRemoveItem(state, level, pos, player, hand).consumesAction() : this.tryAddItem(state, level, pos, player, hand).consumesAction())) {
            return ItemInteractionResult.SUCCESS;
        }
        if (heldItem.isEmpty() || heldItem.is(Items.BOWL)) {
            return this.tryRemoveItem(state, level, pos, player, hand);
        }
        return this.tryAddItem(state, level, pos, player, hand);
    }

    @Override
    protected ItemInteractionResult tryAddItem(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack heldItem;
        int servings = (Integer)state.getValue((Property)SERVINGS);
        if (servings < 6 && (heldItem = player.getItemInHand(hand)).is(this.servingItem.get())) {
            ItemStack itemStack;
            ItemStack container;
            if ((((LeafFeastTypes)((Object)state.getValue((Property)LEAF_FEAST_TYPE))).getId() == 1 || ((LeafFeastTypes)((Object)state.getValue((Property)LEAF_FEAST_TYPE))).getId() == 3) && servings >= 3) {
                return ItemInteractionResult.FAIL;
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)SERVINGS, (Comparable)Integer.valueOf(servings + 1)), 3);
            if (!(player.getAbilities().instabuild || (container = ItemStackUtil.getContainer(itemStack = heldItem.split(1))).isEmpty() || player.getInventory().add(container))) {
                player.drop(container, false);
            }
            this.playAddSound(level, pos);
            LeafFeastBlock.triggerInsertAdvancement(player);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    public static void tryEat(ItemStack itemStack, Level level, BlockPos pos, Player player) {
        player.eat(level, itemStack);
        LeafFeastBlock.triggerConsumeAdvancement(player);
    }

    @Override
    public boolean addItemFromDispenser(ItemStack itemStack, ServerLevel level, BlockPos pos, BlockState state) {
        int servings = (Integer)state.getValue((Property)SERVINGS);
        if (servings < 6) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SERVINGS, (Comparable)Integer.valueOf(servings + 1)), 3);
            this.playAddSound((Level)level, pos);
            return true;
        }
        return false;
    }

    @Override
    protected ItemInteractionResult tryRemoveItem(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        int servings = (Integer)state.getValue((Property)SERVINGS);
        ItemStack itemStack = new ItemStack((ItemLike)this.servingItem.get());
        ItemStack heldItem = player.getItemInHand(hand);
        ItemStack container = ItemStackUtil.getContainer(itemStack);
        if (servings >= 1) {
            if (player.isShiftKeyDown() && heldItem.isEmpty() && player.canEat(((FoodProperties)itemStack.get(DataComponents.FOOD)).canAlwaysEat())) {
                SimpleLeafFeastBlock.tryEat(itemStack, level, pos, player);
                return this.removeServing(state, level, pos, servings);
            }
            if (!container.isEmpty()) {
                if (!container.is(player.getItemInHand(hand).getItem())) {
                    player.displayClientMessage((Component)TextUtils.getTranslatable("container.bowl", new Object[0]), true);
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                if (!player.isCreative()) {
                    heldItem.split(1);
                }
                if (!player.getInventory().add(itemStack)) {
                    player.drop(itemStack, false);
                }
                return this.removeServing(state, level, pos, servings);
            }
            if (container.isEmpty() && !heldItem.isEmpty()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (heldItem.isEmpty()) {
                if (!player.isCreative() && !player.getInventory().add(itemStack)) {
                    player.drop(itemStack, false);
                }
                return this.removeServing(state, level, pos, servings);
            }
        }
        return ItemInteractionResult.FAIL;
    }

    private ItemInteractionResult removeServing(BlockState state, Level level, BlockPos pos, int servings) {
        if (servings >= 1) {
            if (servings > 1) {
                level.setBlock(pos, (BlockState)state.setValue((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
            } else {
                Block block = BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST);
                level.setBlock(pos, this.getTransformState(block, state), 3);
                level.updateNeighbourForOutputSignal(pos, block);
            }
            this.playRemoveSound(level, pos);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        LeafFeastTypes leafFeastType = (LeafFeastTypes)((Object)state.getValue((Property)LEAF_FEAST_TYPE));
        int servings = (Integer)state.getValue((Property)SERVINGS);
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (leafFeastType == LeafFeastTypes.BASE && !this.FEAST_VARIANTS_SERVINGS.containsKey((Object)leafFeastType)) {
            leafFeastType = LeafFeastTypes.MIDDLE;
        }
        VoxelShape servingShape = Shapes.empty();
        if (this.FEAST_VARIANTS_SERVINGS.containsKey((Object)leafFeastType) && this.FEAST_VARIANTS_SERVINGS.get((Object)leafFeastType).containsKey(servings)) {
            servingShape = this.FEAST_VARIANTS_SERVINGS.get((Object)leafFeastType).get(servings)[facing.get2DDataValue()];
        }
        if (servingShape != null) {
            return Shapes.or((VoxelShape)super.getShape(state, level, pos, context), (VoxelShape)servingShape);
        }
        return super.getShape(state, level, pos, context);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        int servings;
        BlockPos blockPos = context.getClickedPos();
        FluidState fluid = context.getLevel().getFluidState(blockPos);
        Level blockGetter = context.getLevel();
        Direction facing = context.getHorizontalDirection();
        Pair connectDirections = this.getConnectDirections(facing.getOpposite());
        BlockState rightBlockState = blockGetter.getBlockState(blockPos.relative((Direction)connectDirections.getSecond()));
        BlockState leftBlockState = blockGetter.getBlockState(blockPos.relative((Direction)connectDirections.getFirst()));
        int n = servings = context.getItemInHand().has((DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(UbesDelightDataComponentTypes.SIMPLE_LEAF_FEAST_SERVINGS)) ? (Integer)context.getItemInHand().get((DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(UbesDelightDataComponentTypes.SIMPLE_LEAF_FEAST_SERVINGS)) : 6;
        LeafFeastTypes leafFeastType = servings > 3 ? (this.placementConnectsTo(facing, leftBlockState) || this.placementConnectsTo(facing, rightBlockState) ? LeafFeastTypes.MIDDLE : LeafFeastTypes.BASE) : this.getLeafFeastType(this.placementConnectsTo(facing, leftBlockState), this.placementConnectsTo(facing, rightBlockState));
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)LEAF_FEAST_TYPE, (Comparable)((Object)leafFeastType))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return SimpleLeafFeastBlock.getOutputSignal((Integer)state.getValue((Property)SERVINGS));
    }

    public static int getOutputSignal(int servings) {
        return servings * 2;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

