/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block.leaf_feast.base.neoforge;

import com.chefmooon.ubesdelight.common.block.entity.neoforge.UniversalLeafFeastBlockEntityImpl;
import com.chefmooon.ubesdelight.common.block.leaf_feast.base.LeafFeastBlock;
import com.chefmooon.ubesdelight.common.block.leaf_feast.base.UniversalLeafFeastBlock;
import com.chefmooon.ubesdelight.common.core.LeafFeastTypes;
import com.chefmooon.ubesdelight.common.registry.UbesDelightBlocks;
import com.chefmooon.ubesdelight.common.utility.BuiltInRegistryUtil;
import com.chefmooon.ubesdelight.common.utility.ItemStackUtil;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class UniversalLeafFeastBlockImpl
extends UniversalLeafFeastBlock {
    public UniversalLeafFeastBlockImpl(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemInteractionResult result = ItemInteractionResult.FAIL;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof UniversalLeafFeastBlockEntityImpl)) {
            return result;
        }
        UniversalLeafFeastBlockEntityImpl universalLeafFeastBlockEntity = (UniversalLeafFeastBlockEntityImpl)blockEntity;
        ItemStack heldStack = player.getItemInHand(hand);
        ItemStack offHandStack = player.getOffhandItem();
        if (heldStack.isEmpty()) {
            return this.tryRemoveItemFromPlayerHand(state, level, pos, universalLeafFeastBlockEntity, heldStack, offHandStack, player, hand);
        }
        return this.tryAddItemFromPlayerHand(state, level, pos, universalLeafFeastBlockEntity, heldStack, offHandStack, player, hand);
    }

    private ItemInteractionResult tryAddItemFromPlayerHand(BlockState state, Level level, BlockPos pos, UniversalLeafFeastBlockEntityImpl universalLeafFeastBlockEntity, ItemStack heldStack, ItemStack offHandStack, Player player, InteractionHand hand) {
        ItemInteractionResult result = ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        int servings = (Integer)state.getValue((Property)SERVINGS);
        if (heldStack.isEmpty()) {
            return result;
        }
        if (heldStack.has(DataComponents.FOOD)) {
            if ((state.getValue((Property)LEAF_FEAST_TYPE) == LeafFeastTypes.END || state.getValue((Property)LEAF_FEAST_TYPE) == LeafFeastTypes.TIP) && servings >= 3) {
                return ItemInteractionResult.FAIL;
            }
            if (universalLeafFeastBlockEntity.addItem(player, player.getAbilities().instabuild ? heldStack.copy() : heldStack)) {
                level.setBlock(pos, (BlockState)state.setValue((Property)SERVINGS, (Comparable)Integer.valueOf(servings + 1)), 3);
                this.playAddSound(level, universalLeafFeastBlockEntity.getBlockPos());
                LeafFeastBlock.triggerInsertAdvancement(player);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return result;
    }

    private ItemInteractionResult tryRemoveItemFromPlayerHand(BlockState state, Level level, BlockPos pos, UniversalLeafFeastBlockEntityImpl universalLeafFeastBlockEntity, ItemStack heldStack, ItemStack offHandStack, Player player, InteractionHand hand) {
        int servings = (Integer)state.getValue((Property)SERVINGS);
        if (servings > 1 && !level.setBlock(pos, (BlockState)state.setValue((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        this.playRemoveSound(level, universalLeafFeastBlockEntity.getBlockPos());
        ItemStack itemStack = universalLeafFeastBlockEntity.removeItem();
        if (!player.isCreative()) {
            if (player.isShiftKeyDown() && (player.getFoodData().needsFood() || Objects.requireNonNull((FoodProperties)itemStack.get(DataComponents.FOOD)).canAlwaysEat())) {
                UniversalLeafFeastBlockImpl.tryEat(itemStack, level, pos, player);
            } else if (!player.getInventory().add(itemStack)) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)itemStack);
            }
        }
        if (servings == 1 && !level.setBlock(pos, this.getTransformState(BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST), state), 3)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.SUCCESS;
    }

    public static void tryEat(ItemStack itemStack, Level level, BlockPos pos, Player player) {
        ItemStack container = ItemStackUtil.getContainer(itemStack);
        if (!container.isEmpty()) {
            UniversalLeafFeastBlockImpl.spawnContainer(level, pos, player.getDirection().getOpposite(), container);
        }
        player.eat(level, itemStack);
        LeafFeastBlock.triggerConsumeAdvancement(player);
    }

    public static void spawnContainer(Level level, BlockPos blockPos, Direction direction, ItemStack itemStack) {
        ItemEntity entity = new ItemEntity(level, (double)blockPos.getX() + 0.5 + (double)direction.getStepX() * 0.2, (double)blockPos.getY() + 0.2, (double)blockPos.getZ() + 0.5 + (double)direction.getStepZ() * 0.2, itemStack.copy());
        entity.setDeltaMovement((double)((float)direction.getStepX() * 0.2f), 0.0, (double)((float)direction.getStepZ() * 0.2f));
        level.addFreshEntity((Entity)entity);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() == newState.getBlock()) {
            return;
        }
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof UniversalLeafFeastBlockEntityImpl) {
            UniversalLeafFeastBlockEntityImpl universalLeafFeastBlockEntity = (UniversalLeafFeastBlockEntityImpl)tileEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, universalLeafFeastBlockEntity.getItems());
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof UniversalLeafFeastBlockEntityImpl) {
            UniversalLeafFeastBlockEntityImpl universalLeafFeastBlockEntity = (UniversalLeafFeastBlockEntityImpl)blockEntity;
            return universalLeafFeastBlockEntity.getItemsQuantity() * 2;
        }
        return 0;
    }
}

