/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.item;

import com.chefmooon.ubesdelight.common.Configuration;
import com.chefmooon.ubesdelight.common.utility.TextUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;

public class UbesDelightBlockItem
extends BlockItem {
    protected final boolean hasFoodEffectTooltip;
    protected final boolean hasCustomTooltip;
    private final int burnTime;

    public UbesDelightBlockItem(Block block, Item.Properties properties) {
        this(block, properties, false, false, 0);
    }

    public UbesDelightBlockItem(Block block, Item.Properties properties, boolean hasFoodEffectTooltip) {
        this(block, properties, hasFoodEffectTooltip, false, 0);
    }

    public UbesDelightBlockItem(Block block, Item.Properties properties, boolean hasFoodEffectTooltip, boolean hasCustomTooltip) {
        this(block, properties, hasFoodEffectTooltip, hasCustomTooltip, 0);
    }

    public UbesDelightBlockItem(Block block, Item.Properties properties, boolean hasFoodEffectTooltip, boolean hasCustomTooltip, int burnTime) {
        super(block, properties);
        this.hasCustomTooltip = hasCustomTooltip;
        this.hasFoodEffectTooltip = hasFoodEffectTooltip;
        this.burnTime = burnTime;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (Configuration.isFoodEffectTooltip()) {
            if (this.hasCustomTooltip) {
                tooltip.add((Component)TextUtils.getTranslatable("tooltip." + String.valueOf((Object)this), new Object[0]).withStyle(ChatFormatting.DARK_GRAY));
            }
            if (this.hasFoodEffectTooltip) {
                vectorwing.farmersdelight.common.utility.TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip::add, (float)1.0f, (float)context.tickRate());
            }
        }
    }
}

