/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block.leaf_feast.base;

import com.chefmooon.ubesdelight.common.block.leaf_feast.base.BaseLeafFeastBlock;
import com.chefmooon.ubesdelight.common.core.LeafFeastTypes;
import com.chefmooon.ubesdelight.common.registry.UbesDelightBlocks;
import com.chefmooon.ubesdelight.common.utility.BuiltInRegistryUtil;
import com.chefmooon.ubesdelight.common.utility.VoxelShapeUtil;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4174;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_9062;
import net.minecraft.class_9334;

public class LargeLeafFeastBlock
extends BaseLeafFeastBlock {
    public Supplier<class_1792> servingItem;
    protected final ConcurrentHashMap<LeafFeastTypes, ConcurrentHashMap<Integer, class_265[]>> FEAST_VARIANTS_SERVINGS;
    private static final int MAX_SERVINGS = 3;

    public LargeLeafFeastBlock(Supplier<class_1792> servingItem, class_4970.class_2251 properties, ConcurrentHashMap<LeafFeastTypes, ConcurrentHashMap<Integer, class_265>> voxelShapes) {
        super(properties);
        this.servingItem = servingItem;
        this.FEAST_VARIANTS_SERVINGS = VoxelShapeUtil.getRotatedShapes(voxelShapes);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.FALSE)).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)SERVINGS, (Comparable)Integer.valueOf(3)));
    }

    @Override
    public class_9062 method_55765(class_1799 heldStack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 heldItem = player.method_5998(hand);
        if (level.method_8608() && (heldItem.method_7960() ? this.tryRemoveItem(state, level, pos, player, hand).method_55643() : this.tryAddItem(state, level, pos, player, hand).method_55643())) {
            return class_9062.field_47728;
        }
        if (heldItem.method_7960()) {
            return this.tryRemoveItem(state, level, pos, player, hand);
        }
        return this.tryAddItem(state, level, pos, player, hand);
    }

    @Override
    protected class_9062 tryAddItem(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand) {
        class_1799 heldItem;
        int servings = (Integer)state.method_11654((class_2769)SERVINGS);
        if (servings < 3 && (heldItem = player.method_5998(hand)).method_31574(this.servingItem.get())) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)SERVINGS, (Comparable)Integer.valueOf(servings + 1)), 3);
            if (!player.method_31549().field_7477) {
                heldItem.method_7971(1);
            }
            this.playAddSound(level, pos);
            return class_9062.field_47728;
        }
        return class_9062.field_47733;
    }

    @Override
    public boolean addItemFromDispenser(class_1799 itemStack, class_3218 level, class_2338 pos, class_2680 state) {
        int servings = (Integer)state.method_11654((class_2769)SERVINGS);
        if (servings < 3) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)SERVINGS, (Comparable)Integer.valueOf(servings + 1)), 3);
            this.playAddSound((class_1937)level, pos);
            return true;
        }
        return false;
    }

    @Override
    protected class_9062 tryRemoveItem(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand) {
        int servings = (Integer)state.method_11654((class_2769)SERVINGS);
        class_1799 itemStack = new class_1799((class_1935)this.servingItem.get());
        if (servings > 1) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
            this.playRemoveSound(level, pos);
            if (!player.method_7337()) {
                if (player.method_5715() && (player.method_7344().method_7587() || Objects.requireNonNull((class_4174)itemStack.method_57824(class_9334.field_50075)).comp_2493())) {
                    LargeLeafFeastBlock.tryEat(itemStack, level, pos, player);
                } else if (!player.method_31548().method_7394(itemStack)) {
                    player.method_7328(itemStack, false);
                }
            }
            return class_9062.field_47728;
        }
        if (servings == 1) {
            class_2248 block = BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST);
            level.method_8652(pos, this.getTransformState(block, state), 3);
            level.method_8455(pos, block);
            this.playRemoveSound(level, pos);
            if (!player.method_7337()) {
                if (player.method_5715() && (player.method_7344().method_7587() || Objects.requireNonNull((class_4174)itemStack.method_57824(class_9334.field_50075)).comp_2493())) {
                    LargeLeafFeastBlock.tryEat(itemStack, level, pos, player);
                } else if (!player.method_31548().method_7394(itemStack)) {
                    player.method_7328(itemStack, false);
                }
            }
            return class_9062.field_47728;
        }
        return class_9062.field_47733;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        LeafFeastTypes leafFeastType = (LeafFeastTypes)((Object)state.method_11654((class_2769)LEAF_FEAST_TYPE));
        int servings = (Integer)state.method_11654((class_2769)SERVINGS);
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        if (leafFeastType == LeafFeastTypes.END || leafFeastType == LeafFeastTypes.TIP) {
            leafFeastType = LeafFeastTypes.MIDDLE;
        }
        class_265 servingShape = class_259.method_1073();
        if (this.FEAST_VARIANTS_SERVINGS.containsKey((Object)LeafFeastTypes.MIDDLE) && this.FEAST_VARIANTS_SERVINGS.get((Object)LeafFeastTypes.MIDDLE).containsKey(servings)) {
            servingShape = this.FEAST_VARIANTS_SERVINGS.get((Object)LeafFeastTypes.MIDDLE).get(servings)[facing.method_10161()];
        }
        return class_259.method_17786((class_265)this.getConnectShape(leafFeastType, this.getConnectDirections(facing.method_10153()), this.CONNECT_SHAPES), (class_265[])new class_265[]{this.getBaseShape(leafFeastType, facing, this.TIP_SHAPES, this.END_SHAPES, LEAF_BASE_SHAPE), servingShape});
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2338 blockPos = context.method_8037();
        class_3610 fluid = context.method_8045().method_8316(blockPos);
        class_1937 blockGetter = context.method_8045();
        class_2350 facing = context.method_8042();
        Pair connectDirections = this.getConnectDirections(facing.method_10153());
        class_2680 rightBlockState = blockGetter.method_8320(blockPos.method_10093((class_2350)connectDirections.getSecond()));
        class_2680 leftBlockState = blockGetter.method_8320(blockPos.method_10093((class_2350)connectDirections.getFirst()));
        LeafFeastTypes leafFeastType = this.placementConnectsTo(facing, leftBlockState) || this.placementConnectsTo(facing, rightBlockState) ? LeafFeastTypes.MIDDLE : LeafFeastTypes.BASE;
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing)).method_11657((class_2769)LEAF_FEAST_TYPE, (Comparable)((Object)leafFeastType))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.method_15772() == class_3612.field_15910));
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        Pair connectDirections;
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        if (direction == (connectDirections = this.getConnectDirections(((class_2350)state.method_11654((class_2769)FACING)).method_10153())).getFirst() || direction == connectDirections.getSecond()) {
            LeafFeastTypes leafFeastType = this.getLeafFeastType(this.connectsTo(state, level.method_8320(pos.method_10093((class_2350)connectDirections.getFirst()))), this.connectsTo(state, level.method_8320(pos.method_10093((class_2350)connectDirections.getSecond()))));
            if (leafFeastType == LeafFeastTypes.END || leafFeastType == LeafFeastTypes.TIP) {
                return (class_2680)state.method_11657((class_2769)LEAF_FEAST_TYPE, (Comparable)((Object)LeafFeastTypes.MIDDLE));
            }
            return (class_2680)state.method_11657((class_2769)LEAF_FEAST_TYPE, (Comparable)((Object)leafFeastType));
        }
        if (direction == class_2350.field_11033 && !state.method_26184((class_4538)level, pos)) {
            return class_2246.field_10124.method_9564();
        }
        return state;
    }

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        return LargeLeafFeastBlock.getOutputSignal((Integer)state.method_11654((class_2769)SERVINGS));
    }

    public static int getOutputSignal(int servings) {
        return servings * 4;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }
}

