/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block;

import com.chefmooon.ubesdelight.common.registry.UbesDelightSounds;
import com.chefmooon.ubesdelight.common.utility.TextUtils;
import java.util.function.Supplier;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class DrinkableFeastBlock
extends class_2248 {
    public static final int MAX_SERVINGS = 4;
    public static final class_2769<class_2350> FACING = class_2741.field_12481;
    public static final class_2758 SERVINGS = class_2758.method_11867((String)"servings", (int)0, (int)4);
    protected static final class_265 SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    public Supplier<class_1792> servingItem;
    private final class_2394 particleData;

    public DrinkableFeastBlock(Supplier<class_1792> servingItem) {
        this(servingItem, class_4970.class_2251.method_9630((class_4970)class_2246.field_10033).method_9632(2.0f).method_9626(class_2498.field_11537));
    }

    public DrinkableFeastBlock(Supplier<class_1792> servingItem, class_4970.class_2251 properties) {
        super(properties);
        this.servingItem = servingItem;
        this.particleData = null;
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)SERVINGS, (Comparable)Integer.valueOf(4)));
    }

    public DrinkableFeastBlock(Supplier<class_1792> servingItem, class_2394 particleData) {
        super(class_4970.class_2251.method_9630((class_4970)class_2246.field_10033));
        this.servingItem = servingItem;
        this.particleData = particleData;
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)SERVINGS, (Comparable)Integer.valueOf(4)));
    }

    public class_2758 getServingsProperty() {
        return SERVINGS;
    }

    public int getMaxServings() {
        return 4;
    }

    public class_1799 getServingItem(class_2680 state) {
        return new class_1799((class_1935)this.servingItem.get());
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657(FACING, (Comparable)context.method_8042().method_10153());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, SERVINGS});
    }

    public class_1269 method_55765(class_1799 heldStack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 serving = this.getServingItem(state);
        class_1799 heldItem = player.method_5998(hand);
        if (heldItem.method_31574(serving.method_7909())) {
            return this.addDrink(level, pos, state, player, hand);
        }
        return this.dispenseDrink(level, pos, state, player, hand);
    }

    protected class_1269 dispenseDrink(class_1937 world, class_2338 pos, class_2680 state, class_1657 player, class_1268 hand) {
        int servings = (Integer)state.method_11654((class_2769)this.getServingsProperty());
        if (servings == 0) {
            return class_1269.field_5814;
        }
        if (servings > 0) {
            class_1799 serving = this.getServingItem(state);
            class_1799 heldItem = player.method_5998(hand);
            if (heldItem.method_31574(class_1802.field_8469)) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)this.getServingsProperty(), (Comparable)Integer.valueOf(servings - 1)), 3);
                world.method_8396(null, pos, UbesDelightSounds.BLOCK_DRINKABLE_FEAST_REMOVE.get(), class_3419.field_15248, 0.8f, 0.8f);
                if (!player.method_68878()) {
                    heldItem.method_7934(1);
                    if (!player.method_31548().method_7394(serving)) {
                        player.method_7328(serving, false);
                    }
                }
            } else {
                player.method_7353((class_2561)TextUtils.getTranslatable("container.punch_bowl", new Object[0]), true);
            }
        }
        return class_1269.field_5812;
    }

    protected class_1269 addDrink(class_1937 world, class_2338 pos, class_2680 state, class_1657 player, class_1268 hand) {
        int servings = (Integer)state.method_11654((class_2769)this.getServingsProperty());
        if (servings < 4) {
            class_1799 heldItem = player.method_5998(hand);
            class_1799 container = new class_1799((class_1935)class_1802.field_8469);
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)this.getServingsProperty(), (Comparable)Integer.valueOf(servings + 1)), 3);
            world.method_8396(null, pos, UbesDelightSounds.BLOCK_DRINKABLE_FEAST_ADD.get(), class_3419.field_15248, 0.8f, 0.8f);
            if (!player.method_68878()) {
                heldItem.method_7934(1);
                if (!player.method_31548().method_7394(container)) {
                    player.method_7328(container, false);
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public boolean addDrinkFromDispenser(class_1937 world, class_2338 pos, class_2680 state) {
        int servings = (Integer)state.method_11654((class_2769)this.getServingsProperty());
        if (servings < 4) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)this.getServingsProperty(), (Comparable)Integer.valueOf(servings + 1)), 3);
            world.method_8396(null, pos, UbesDelightSounds.BLOCK_DRINKABLE_FEAST_REMOVE.get(), class_3419.field_15248, 0.8f, 0.8f);
            return true;
        }
        return false;
    }

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        return DrinkableFeastBlock.getOutputSignal((Integer)state.method_11654((class_2769)SERVINGS));
    }

    public static int getOutputSignal(int servings) {
        return servings * 2;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }
}

