/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block.entity.fabric;

import com.chefmooon.ubesdelight.common.block.entity.BakingMatBlockEntity;
import com.chefmooon.ubesdelight.common.block.fabric.BakingMatBlockImpl;
import com.chefmooon.ubesdelight.common.crafting.fabric.BakingMatRecipeImpl;
import com.chefmooon.ubesdelight.common.registry.UbesDelightSounds;
import com.chefmooon.ubesdelight.common.registry.fabric.UbesDelightBlockEntityTypesImpl;
import com.chefmooon.ubesdelight.common.registry.fabric.UbesDelightRecipePropertySetsImpl;
import com.chefmooon.ubesdelight.common.registry.fabric.UbesDelightRecipeTypesImpl;
import com.chefmooon.ubesdelight.common.tag.CommonTags;
import com.chefmooon.ubesdelight.common.utility.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.refabricated.inventory.ItemHandler;
import vectorwing.farmersdelight.refabricated.inventory.ItemStackHandler;
import vectorwing.farmersdelight.refabricated.inventory.RecipeWrapper;

public class BakingMatBlockEntityImpl
extends SyncedBlockEntity {
    public static final int MAX_INGREDIENTS = 9;
    public static final int MAX_PROCESSING_STAGES = 5;
    public static final int MAX_RESULTS = 4;
    private final ItemStackHandler inventory = this.createHandler();
    private final class_1863.class_7266<RecipeWrapper, BakingMatRecipeImpl> quickCheck = class_1863.method_42302(UbesDelightRecipeTypesImpl.BAKING_MAT.get());

    public BakingMatBlockEntityImpl(class_2338 pos, class_2680 state) {
        super(UbesDelightBlockEntityTypesImpl.BAKING_MAT_BAMBOO.get(), pos, state);
    }

    public static void init() {
        ItemStorage.SIDED.registerForBlockEntity(BakingMatBlockEntityImpl::getStorage, UbesDelightBlockEntityTypesImpl.BAKING_MAT_BAMBOO.get());
    }

    public void method_11014(class_11368 valueInput) {
        super.method_11014(valueInput);
        this.inventory.deserialize(valueInput.method_71434("Inventory"));
    }

    public void method_11007(class_11372 valueOutput) {
        super.method_11007(valueOutput);
        this.inventory.serialize(valueOutput.method_71461("Inventory"));
    }

    public void method_66473(class_2338 pos, class_2680 state) {
        class_2586 blockEntity = this.field_11863.method_8321(pos);
        if (blockEntity instanceof BakingMatBlockEntityImpl) {
            BakingMatBlockEntityImpl bakingMatBlockEntity = (BakingMatBlockEntityImpl)blockEntity;
            if (!((Boolean)state.method_11654((class_2769)BakingMatBlockImpl.PROCESSING)).booleanValue()) {
                class_1264.method_17349((class_1937)this.field_11863, (class_2338)pos, bakingMatBlockEntity.getItems());
            }
        }
        super.method_66473(pos, state);
    }

    public boolean processItemUsingTool(class_1799 tool, @Nullable class_1657 player) {
        if (this.field_11863 == null) {
            return false;
        }
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return player.method_37908().method_8433().method_64678(UbesDelightRecipePropertySetsImpl.BAKING_MAT_INPUT_ONE).method_64701(this.inventory.getStackInSlot(0)) && player.method_37908().method_8433().method_64678(UbesDelightRecipePropertySetsImpl.BAKING_MAT_INPUT_TWO).method_64701(this.inventory.getStackInSlot(1)) && player.method_37908().method_8433().method_64678(UbesDelightRecipePropertySetsImpl.BAKING_MAT_INPUT_THREE).method_64701(this.inventory.getStackInSlot(2)) && player.method_37908().method_8433().method_64678(UbesDelightRecipePropertySetsImpl.BAKING_MAT_INPUT_FOUR).method_64701(this.inventory.getStackInSlot(3)) && player.method_37908().method_8433().method_64678(UbesDelightRecipePropertySetsImpl.BAKING_MAT_INPUT_FIVE).method_64701(this.inventory.getStackInSlot(4)) && player.method_37908().method_8433().method_64678(UbesDelightRecipePropertySetsImpl.BAKING_MAT_INPUT_SIX).method_64701(this.inventory.getStackInSlot(5)) && player.method_37908().method_8433().method_64678(UbesDelightRecipePropertySetsImpl.BAKING_MAT_INPUT_SEVEN).method_64701(this.inventory.getStackInSlot(6)) && player.method_37908().method_8433().method_64678(UbesDelightRecipePropertySetsImpl.BAKING_MAT_INPUT_EIGHT).method_64701(this.inventory.getStackInSlot(7)) && player.method_37908().method_8433().method_64678(UbesDelightRecipePropertySetsImpl.BAKING_MAT_INPUT_NINE).method_64701(this.inventory.getStackInSlot(8)) && player.method_37908().method_8433().method_64678(UbesDelightRecipePropertySetsImpl.BAKING_MAT_TOOL).method_64701(tool);
        }
        class_3218 serverLevel = (class_3218)class_19372;
        Optional<class_8786<BakingMatRecipeImpl>> matchingRecipe = this.getMatchingRecipe(new RecipeWrapper((ItemHandler)this.inventory), tool, player, serverLevel);
        matchingRecipe.ifPresent(recipe -> {
            List<class_1856> processStages = ((BakingMatRecipeImpl)recipe.comp_1933()).getProcessStages();
            List<class_1799> ingredientContainers = this.getInventoryContainers(this.inventory);
            class_2338 blockPos = this.method_11016();
            if (!((BakingMatRecipeImpl)recipe.comp_1933()).getProcessStages().isEmpty()) {
                if (!((Boolean)this.method_11010().method_11654((class_2769)BakingMatBlockImpl.PROCESSING)).booleanValue()) {
                    if (!ingredientContainers.isEmpty()) {
                        this.spawnResults(ingredientContainers);
                    }
                    this.field_11863.method_8501(blockPos, (class_2680)this.method_11010().method_11657((class_2769)BakingMatBlockImpl.PROCESSING, (Comparable)Boolean.valueOf(true)));
                    this.clearInventory();
                    class_1799 itemStack = processStages.getFirst().method_8105().findFirst().map(itemHolder -> ((class_1792)itemHolder.comp_349()).method_7854()).orElse(class_1799.field_8037);
                    this.inventory.setStackInSlot(0, itemStack);
                    BakingMatBlockEntityImpl.spawnParticles(this.field_11863, blockPos, itemStack, 5);
                    this.inventoryChanged();
                } else if (((Boolean)this.method_11010().method_11654((class_2769)BakingMatBlockImpl.PROCESSING)).booleanValue()) {
                    int currentStage = this.getProcessStage(this.inventory.getStackInSlot(0), processStages);
                    if (currentStage < ((BakingMatRecipeImpl)recipe.comp_1933()).getProcessStages().size() - 1) {
                        class_1799 currentStageItem = this.inventory.getStackInSlot(0);
                        int nextStage = this.getNextProcessStage(currentStageItem, processStages);
                        if (!processStages.get(nextStage).method_65799()) {
                            this.clearInventory();
                            class_1799 nextStageItem = processStages.get(nextStage).method_8105().findFirst().map(itemHolder -> ((class_1792)itemHolder.comp_349()).method_7854()).orElse(class_1799.field_8037);
                            BakingMatBlockEntityImpl.spawnParticles(this.field_11863, blockPos, nextStageItem, 5);
                            this.inventory.setStackInSlot(0, nextStageItem);
                            this.inventoryChanged();
                        }
                    } else if (currentStage == ((BakingMatRecipeImpl)recipe.comp_1933()).getProcessStages().size() - 1) {
                        this.spawnRolledResults((BakingMatRecipeImpl)recipe.comp_1933(), blockPos, this.field_11863, tool, null);
                        this.field_11863.method_8501(blockPos, (class_2680)this.method_11010().method_11657((class_2769)BakingMatBlockImpl.PROCESSING, (Comparable)Boolean.valueOf(false)));
                    }
                }
            } else {
                this.spawnRolledResults((BakingMatRecipeImpl)recipe.comp_1933(), blockPos, this.field_11863, tool, ingredientContainers);
            }
            BakingMatBlockEntity.triggerAdvancement(player);
            tool.method_7956(1, serverLevel, (class_3222)player, item -> {});
            this.playProcessingSound(((BakingMatRecipeImpl)recipe.comp_1933()).getSoundEvent().orElse(null), tool);
        });
        return matchingRecipe.isPresent();
    }

    private Optional<class_8786<BakingMatRecipeImpl>> getMatchingRecipe(RecipeWrapper inventoryWrapper, class_1799 toolStack, @Nullable class_1657 player, class_3218 serverlevel) {
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        Optional recipe = this.quickCheck.method_42303((class_9695)inventoryWrapper, serverlevel);
        if (recipe.isPresent()) {
            if (((BakingMatRecipeImpl)((class_8786)recipe.get()).comp_1933()).getTool().method_8093(toolStack)) {
                return recipe;
            }
            if (player != null) {
                player.method_7353((class_2561)TextUtils.getTranslatable("tooltip.baking_mat.invalid_tool", new Object[0]), true);
            }
        } else if (player != null) {
            player.method_7353((class_2561)TextUtils.getTranslatable("tooltip.baking_mat.invalid_item", new Object[0]), true);
        }
        return Optional.empty();
    }

    private void spawnRolledResults(BakingMatRecipeImpl recipe, class_2338 blockPos, class_1937 level, class_1799 tool, @Nullable List<class_1799> containers) {
        List<class_1799> results = recipe.getRollResults(level.field_9229, class_1890.method_8225((class_6880)level.method_30349().method_30530(class_7924.field_41265).method_46747(class_1893.field_9130), (class_1799)tool));
        if (containers != null && !containers.isEmpty()) {
            results.addAll(containers);
        }
        if (!results.isEmpty()) {
            BakingMatBlockEntityImpl.spawnParticles(level, blockPos, results.get(0).method_7972(), 5);
            this.spawnResults(results);
            this.clearInventory();
        }
    }

    private void spawnResults(List<class_1799> results) {
        for (class_1799 result : results) {
            class_2350 direction = ((class_2350)this.method_11010().method_11654(BakingMatBlockImpl.FACING)).method_10160();
            class_1542 entity = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5 + (double)direction.method_10148() * 0.2, (double)this.field_11867.method_10264() + 0.2, (double)this.field_11867.method_10260() + 0.5 + (double)direction.method_10165() * 0.2, result.method_7972());
            entity.method_18800((double)((float)direction.method_10148() * 0.2f), 0.0, (double)((float)direction.method_10165() * 0.2f));
            this.field_11863.method_8649((class_1297)entity);
        }
    }

    private void playProcessingSound(class_3414 soundEvent, class_1799 tool) {
        this.playProcessingSound(soundEvent, tool, null);
    }

    private void playProcessingSound(@Nullable class_3414 soundEvent, class_1799 tool, @Nullable class_1799 item) {
        if (soundEvent != null) {
            this.playSound(soundEvent, 1.0f, 1.0f);
        } else if (tool.method_31573(CommonTags.C_TOOLS_ROLLING_PIN)) {
            this.playSound(UbesDelightSounds.BLOCK_BAKING_MAT_ROLLING_PIN.get(), 1.0f, 0.8f);
        }
    }

    private void playSound(class_3414 sound, float volume, float pitch) {
        if (this.field_11863 != null) {
            this.field_11863.method_43128(null, (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.5f), (double)((float)this.field_11867.method_10260() + 0.5f), sound, class_3419.field_15245, volume, pitch);
        }
    }

    public static void spawnParticles(class_1937 level, class_2338 pos, class_1799 stack, int count) {
        for (int i = 0; i < count; ++i) {
            class_243 vec3d = new class_243(((double)level.field_9229.method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)level.field_9229.method_43057() - 0.5) * 0.1);
            if (level instanceof class_3218) {
                ((class_3218)level).method_65096((class_2394)new class_2392(class_2398.field_11218, stack), (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.1f), (double)((float)pos.method_10260() + 0.5f), 1, vec3d.field_1352, vec3d.field_1351 + 0.05, vec3d.field_1350, 0.0);
                continue;
            }
            level.method_8406((class_2394)new class_2392(class_2398.field_11218, stack), (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.1f), (double)((float)pos.method_10260() + 0.5f), vec3d.field_1352, vec3d.field_1351 + 0.05, vec3d.field_1350);
        }
    }

    private Integer getProcessStage(class_1799 itemStack, List<class_1856> processStages) {
        Integer stage = 0;
        for (int i = 0; i < processStages.size(); ++i) {
            if (processStages.get(i).method_65799()) continue;
            if (itemStack.method_31574(processStages.get(i).method_8105().findFirst().map(itemHolder -> ((class_1792)itemHolder.comp_349()).method_7854()).orElse(class_1799.field_8037).method_7909())) {
                return stage;
            }
            Integer n = stage;
            stage = stage + 1;
        }
        return stage;
    }

    private Integer getNextProcessStage(class_1799 itemStack, List<class_1856> processStages) {
        Integer stage = 0;
        for (int i = 0; i < processStages.size(); ++i) {
            if (processStages.get(i).method_65799()) continue;
            if (itemStack.method_31574(processStages.get(i).method_8105().findFirst().map(itemHolder -> ((class_1792)itemHolder.comp_349()).method_7854()).orElse(class_1799.field_8037).method_7909())) {
                if (i == processStages.size() - 1) {
                    return stage;
                }
                return stage + 1;
            }
            Integer n = stage;
            stage = stage + 1;
        }
        return stage;
    }

    private List<class_1799> getInventoryContainers(ItemStackHandler inventory) {
        ArrayList<class_1799> ingredientContainers = new ArrayList<class_1799>();
        for (int i = 0; i < inventory.getSlotCount(); ++i) {
            class_1799 itemStack = inventory.getStackInSlot(i);
            if (itemStack.method_7960() || itemStack.getRecipeRemainder().method_31574(class_1802.field_8162)) continue;
            ingredientContainers.add(itemStack.getRecipeRemainder());
        }
        return ingredientContainers;
    }

    public void clearInventory() {
        for (int i = 0; i < 9; ++i) {
            this.inventory.setStackInSlot(i, new class_1799((class_1935)class_1802.field_8162));
        }
        this.inventoryChanged();
    }

    public void setInventory(class_2371<class_1799> list) {
        for (int i = 0; i < 8; ++i) {
            this.inventory.setStackInSlot(i, (class_1799)list.get(i));
        }
    }

    public int getContainerSize() {
        return 9;
    }

    public class_2371<class_1799> getItems() {
        class_2371 items = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
        for (int i = 0; i < 9; ++i) {
            items.set(i, (Object)this.inventory.getStackInSlot(i));
        }
        return items;
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).method_7960();
    }

    public boolean isFull() {
        return !this.inventory.getStackInSlot(8).method_7960();
    }

    public boolean addItem(class_1799 itemStack) {
        for (int i = 0; i < this.inventory.getSlotCount(); ++i) {
            class_1799 inventoryStack = this.inventory.getStackInSlot(i);
            if (!inventoryStack.method_7960()) continue;
            this.inventory.setStackInSlot(i, itemStack.method_7971(1));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public class_1799 removeItem() {
        for (int i = 8; i >= 0; --i) {
            class_1799 itemStack = this.inventory.getStackInSlot(i);
            if (itemStack.method_7960()) continue;
            this.inventory.setStackInSlot(i, class_1799.field_8037);
            this.inventoryChanged();
            return itemStack;
        }
        return class_1799.field_8037;
    }

    public int getItemsQuantity() {
        int items = 0;
        for (int i = 0; i <= 8; ++i) {
            class_1799 itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.method_7960()) continue;
            ++items;
        }
        return items;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public class_241 getItemOffset(int index) {
        return BakingMatBlockEntity.getItemOffset(index);
    }

    @NotNull
    public Storage<ItemVariant> getStorage(@Nullable class_2350 side) {
        return this.getInventory();
    }

    public void method_11012() {
        super.method_11012();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(9){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                BakingMatBlockEntityImpl.this.inventoryChanged();
            }
        };
    }
}

