/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class TallWildCropBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public TallWildCropBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF});
    }

    public boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(BlockTags.DIRT) || state.is(BlockTags.SAND);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.setBlock(pos.above(), (BlockState)this.defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return (double)random.nextFloat() < (double)0.8f;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int wildCropLimit = 10;
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
            state = (BlockState)state.setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER);
            pos = pos.below();
        }
        for (BlockPos nearbyPos : BlockPos.betweenClosed((BlockPos)pos.offset(-4, -1, -4), (BlockPos)pos.offset(4, 1, 4))) {
            if (!level.getBlockState(nearbyPos).is((Block)this) || level.getBlockState(nearbyPos).getValue((Property)HALF) != DoubleBlockHalf.LOWER || --wildCropLimit > 0) continue;
            return;
        }
        BlockPos randomPos = pos.offset(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
        for (int k = 0; k < 4; ++k) {
            if (level.isEmptyBlock(randomPos) && state.canSurvive((LevelReader)level, randomPos)) {
                pos = randomPos;
            }
            randomPos = pos.offset(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
        }
        if (level.isEmptyBlock(randomPos) && state.canSurvive((LevelReader)level, randomPos)) {
            TallWildCropBlock.placeAt((LevelAccessor)level, (BlockState)state, (BlockPos)randomPos, (int)2);
        }
    }
}

