/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block.leaf_feast.base;

import com.chefmooon.ubesdelight.common.block.leaf_feast.base.BaseLeafFeastBlock;
import com.chefmooon.ubesdelight.common.core.LeafFeastTypes;
import com.chefmooon.ubesdelight.common.registry.UbesDelightBlocks;
import com.chefmooon.ubesdelight.common.utility.BuiltInRegistryUtil;
import com.chefmooon.ubesdelight.common.utility.VoxelShapeUtil;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LargeLeafFeastBlock
extends BaseLeafFeastBlock {
    public Supplier<Item> servingItem;
    protected final ConcurrentHashMap<LeafFeastTypes, ConcurrentHashMap<Integer, VoxelShape[]>> FEAST_VARIANTS_SERVINGS;
    private static final int MAX_SERVINGS = 3;

    public LargeLeafFeastBlock(Supplier<Item> servingItem, BlockBehaviour.Properties properties, ConcurrentHashMap<LeafFeastTypes, ConcurrentHashMap<Integer, VoxelShape>> voxelShapes) {
        super(properties);
        this.servingItem = servingItem;
        this.FEAST_VARIANTS_SERVINGS = VoxelShapeUtil.getRotatedShapes(voxelShapes);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SERVINGS, (Comparable)Integer.valueOf(3)));
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (level.isClientSide() && (heldItem.isEmpty() ? this.tryRemoveItem(state, level, pos, player, hand).consumesAction() : this.tryAddItem(state, level, pos, player, hand).consumesAction())) {
            return ItemInteractionResult.SUCCESS;
        }
        if (heldItem.isEmpty()) {
            return this.tryRemoveItem(state, level, pos, player, hand);
        }
        return this.tryAddItem(state, level, pos, player, hand);
    }

    @Override
    protected ItemInteractionResult tryAddItem(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack heldItem;
        int servings = (Integer)state.getValue((Property)SERVINGS);
        if (servings < 3 && (heldItem = player.getItemInHand(hand)).is(this.servingItem.get())) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SERVINGS, (Comparable)Integer.valueOf(servings + 1)), 3);
            if (!player.getAbilities().instabuild) {
                heldItem.split(1);
            }
            this.playAddSound(level, pos);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    @Override
    public boolean addItemFromDispenser(ItemStack itemStack, ServerLevel level, BlockPos pos, BlockState state) {
        int servings = (Integer)state.getValue((Property)SERVINGS);
        if (servings < 3) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SERVINGS, (Comparable)Integer.valueOf(servings + 1)), 3);
            this.playAddSound((Level)level, pos);
            return true;
        }
        return false;
    }

    @Override
    protected ItemInteractionResult tryRemoveItem(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        int servings = (Integer)state.getValue((Property)SERVINGS);
        ItemStack itemStack = new ItemStack((ItemLike)this.servingItem.get());
        if (servings > 1) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
            this.playRemoveSound(level, pos);
            if (!player.isCreative()) {
                if (player.isShiftKeyDown() && (player.getFoodData().needsFood() || Objects.requireNonNull((FoodProperties)itemStack.get(DataComponents.FOOD)).canAlwaysEat())) {
                    LargeLeafFeastBlock.tryEat(itemStack, level, pos, player);
                } else if (!player.getInventory().add(itemStack)) {
                    player.drop(itemStack, false);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (servings == 1) {
            Block block = BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST);
            level.setBlock(pos, this.getTransformState(block, state), 3);
            level.updateNeighbourForOutputSignal(pos, block);
            this.playRemoveSound(level, pos);
            if (!player.isCreative()) {
                if (player.isShiftKeyDown() && (player.getFoodData().needsFood() || Objects.requireNonNull((FoodProperties)itemStack.get(DataComponents.FOOD)).canAlwaysEat())) {
                    LargeLeafFeastBlock.tryEat(itemStack, level, pos, player);
                } else if (!player.getInventory().add(itemStack)) {
                    player.drop(itemStack, false);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        LeafFeastTypes leafFeastType = (LeafFeastTypes)((Object)state.getValue((Property)LEAF_FEAST_TYPE));
        int servings = (Integer)state.getValue((Property)SERVINGS);
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (leafFeastType == LeafFeastTypes.END || leafFeastType == LeafFeastTypes.TIP) {
            leafFeastType = LeafFeastTypes.MIDDLE;
        }
        VoxelShape servingShape = Shapes.empty();
        if (this.FEAST_VARIANTS_SERVINGS.containsKey((Object)LeafFeastTypes.MIDDLE) && this.FEAST_VARIANTS_SERVINGS.get((Object)LeafFeastTypes.MIDDLE).containsKey(servings)) {
            servingShape = this.FEAST_VARIANTS_SERVINGS.get((Object)LeafFeastTypes.MIDDLE).get(servings)[facing.get2DDataValue()];
        }
        return Shapes.or((VoxelShape)this.getConnectShape(leafFeastType, this.getConnectDirections(facing.getOpposite()), this.CONNECT_SHAPES), (VoxelShape[])new VoxelShape[]{this.getBaseShape(leafFeastType, facing, this.TIP_SHAPES, this.END_SHAPES, LEAF_BASE_SHAPE), servingShape});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockPos = context.getClickedPos();
        FluidState fluid = context.getLevel().getFluidState(blockPos);
        Level blockGetter = context.getLevel();
        Direction facing = context.getHorizontalDirection();
        Pair connectDirections = this.getConnectDirections(facing.getOpposite());
        BlockState rightBlockState = blockGetter.getBlockState(blockPos.relative((Direction)connectDirections.getSecond()));
        BlockState leftBlockState = blockGetter.getBlockState(blockPos.relative((Direction)connectDirections.getFirst()));
        LeafFeastTypes leafFeastType = this.placementConnectsTo(facing, leftBlockState) || this.placementConnectsTo(facing, rightBlockState) ? LeafFeastTypes.MIDDLE : LeafFeastTypes.BASE;
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)LEAF_FEAST_TYPE, (Comparable)((Object)leafFeastType))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        Pair connectDirections;
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (direction == (connectDirections = this.getConnectDirections(((Direction)state.getValue((Property)FACING)).getOpposite())).getFirst() || direction == connectDirections.getSecond()) {
            LeafFeastTypes leafFeastType = this.getLeafFeastType(this.connectsTo(state, level.getBlockState(pos.relative((Direction)connectDirections.getFirst()))), this.connectsTo(state, level.getBlockState(pos.relative((Direction)connectDirections.getSecond()))));
            if (leafFeastType == LeafFeastTypes.END || leafFeastType == LeafFeastTypes.TIP) {
                return (BlockState)state.setValue((Property)LEAF_FEAST_TYPE, (Comparable)((Object)LeafFeastTypes.MIDDLE));
            }
            return (BlockState)state.setValue((Property)LEAF_FEAST_TYPE, (Comparable)((Object)leafFeastType));
        }
        if (direction == Direction.DOWN && !state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return LargeLeafFeastBlock.getOutputSignal((Integer)state.getValue((Property)SERVINGS));
    }

    public static int getOutputSignal(int servings) {
        return servings * 4;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

