/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.shulkerbox.menu;

import de.maxhenkel.shulkerbox.menu.AdvancedShulkerboxContainer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class AdvancedShulkerboxMenu
extends ShulkerBoxMenu {
    protected ServerPlayer player;
    protected ItemStack shulkerBox;

    public AdvancedShulkerboxMenu(int id, Inventory inventory, ServerPlayer player, ItemStack shulkerBox) {
        super(id, inventory, (Container)new AdvancedShulkerboxContainer(player, shulkerBox, 27));
        this.player = player;
        this.shulkerBox = shulkerBox;
    }

    public void clicked(int slot, int mouseButton, ClickType clickType, Player player) {
        if (slot < 0 || slot >= this.slots.size()) {
            super.clicked(slot, mouseButton, clickType, player);
            return;
        }
        ItemStack stack = ((Slot)this.slots.get(slot)).getItem();
        if (stack == this.shulkerBox) {
            return;
        }
        super.clicked(slot, mouseButton, clickType, player);
    }

    public static void open(ServerPlayer player, final ItemStack shulkerBox) {
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return shulkerBox.getHoverName();
            }

            public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
                if (!(player instanceof ServerPlayer)) {
                    return null;
                }
                ServerPlayer serverPlayer = (ServerPlayer)player;
                return new AdvancedShulkerboxMenu(i, inventory, serverPlayer, shulkerBox);
            }
        });
    }
}

