/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.shulkerbox.mixin;

import de.maxhenkel.shulkerbox.AdvancedShulkerboxesMod;
import de.maxhenkel.shulkerbox.menu.AdvancedShulkerboxMenu;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockItem.class})
public abstract class BlockItemMixin {
    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true)
    public void useOn(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        if (!(this.getBlock() instanceof ShulkerBoxBlock)) {
            return;
        }
        if (!AdvancedShulkerboxesMod.CONFIG.sneakPlace.get().booleanValue()) {
            return;
        }
        if (context.getPlayer().isShiftKeyDown()) {
            return;
        }
        if (context.getItemInHand().getCount() != 1) {
            return;
        }
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AdvancedShulkerboxMenu.open(serverPlayer, context.getItemInHand());
        }
        cir.setReturnValue((Object)InteractionResult.SUCCESS);
    }

    @Shadow
    public abstract Block getBlock();
}

