/*
 * Decompiled with CFR 0.152.
 */
package eu.comosus.ananas.onetridentthrowonly.drowned;

import eu.comosus.ananas.onetridentthrowonly.Constants;
import eu.comosus.ananas.onetridentthrowonly.component.OriginalTridentOwner;
import eu.comosus.ananas.onetridentthrowonly.mixin.AccessorMixinAbstractArrow;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1685;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_9279;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class DrownedFindTridentGoal
extends class_1352 {
    private final class_1314 mob;
    private boolean targetWithinReach;
    class_1685 nearestTrident;
    private boolean finished;
    private final double speedModifier;
    private final class_1937 level;
    private class_11 navigationPath;

    public DrownedFindTridentGoal(class_1314 mob, double speedModifier) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.level = mob.method_73183();
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        if (!this.mob.method_6118(class_1304.field_6173).method_7960()) {
            return false;
        }
        return this.updateWantedLocation();
    }

    public boolean method_6266() {
        return !this.finished && this.method_6264();
    }

    public void method_6269() {
        this.finished = false;
        this.mob.method_5942().method_6334(this.navigationPath, this.speedModifier);
    }

    public void method_6268() {
        if (this.updateWantedLocation()) {
            this.mob.method_5942().method_6334(this.navigationPath, this.speedModifier);
        }
        if (this.targetWithinReach) {
            if (this.nearestTrident == null) {
                return;
            }
            class_1799 candidate = this.nearestTrident.method_54759().method_7972();
            class_1304 equipmentSlot = this.mob.method_32326(candidate);
            if (this.mob.method_6118(equipmentSlot).method_7960()) {
                class_1799 limitedCandidate = equipmentSlot.method_60610(candidate);
                this.mob.method_5673(equipmentSlot, limitedCandidate);
                class_1297 class_12972 = this.nearestTrident.method_24921();
                if (class_12972 instanceof class_1657) {
                    class_1657 owner = (class_1657)class_12972;
                    class_2487 compoundTag = new class_2487();
                    OriginalTridentOwner originalTridentOwner = new OriginalTridentOwner(owner.method_5477().getString(), owner.method_5667());
                    compoundTag.method_10566(Constants.RESOURCE_ORIGINAL_TRIDENT_OWNER.toString(), (class_2520)originalTridentOwner.getCompoundTag());
                    class_9326 dataComponentsPatch = class_9326.method_57841().method_57854(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)compoundTag)).method_57852();
                    limitedCandidate.method_57366(dataComponentsPatch);
                    this.mob.method_25939(equipmentSlot);
                    this.mob.method_5971();
                }
                this.mob.method_6103((class_1297)this.nearestTrident, limitedCandidate.method_7947());
                this.nearestTrident.method_31472();
            }
            this.finished = true;
        }
    }

    private boolean updateWantedLocation() {
        class_1685 nearestTrident = this.getNearestTrident();
        if (nearestTrident == null) {
            return false;
        }
        class_2338 tridentBlockPos = nearestTrident.method_24515();
        class_11 navigationPath = this.mob.method_5942().method_6348(tridentBlockPos, 1);
        if (navigationPath == null || !navigationPath.method_21655()) {
            return false;
        }
        this.navigationPath = navigationPath;
        this.targetWithinReach = this.mob.method_5829().method_1014(1.25).method_1006(tridentBlockPos.method_46558());
        this.nearestTrident = nearestTrident;
        return true;
    }

    @Nullable
    private class_1685 getNearestTrident() {
        class_1657 nearestPlayer = this.level.method_18460((class_1297)this.mob, 10.0);
        List nearbyTridents = this.level.method_18467(class_1685.class, this.mob.method_5829().method_1014(15.0));
        class_1685 nearestTrident = null;
        float nearestTridentDistance = Float.MAX_VALUE;
        for (class_1685 trident : nearbyTridents) {
            int durabilityLeft = trident.method_59958().method_7936() - trident.method_59958().method_7919();
            if (!((AccessorMixinAbstractArrow)trident).callIsInGround() || durabilityLeft <= 1 || !this.mob.method_6057((class_1297)trident)) continue;
            if (nearestPlayer != null && this.mob.method_5739((class_1297)trident) > this.mob.method_5739((class_1297)nearestPlayer)) {
                return null;
            }
            float tridentDistance = this.mob.method_5739((class_1297)trident);
            if (nearestTrident != null && !(tridentDistance < nearestTridentDistance)) continue;
            nearestTridentDistance = tridentDistance;
            nearestTrident = trident;
        }
        return nearestTrident;
    }
}

