/*
 * Decompiled with CFR 0.152.
 */
package com.Minor2CCh.retrial_key.config;

import com.Minor2CCh.retrial_key.config.ModConfig;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.spongepowered.include.com.google.gson.Gson;
import org.spongepowered.include.com.google.gson.GsonBuilder;

public class ModConfigLoader {
    private static final File DIR = Platform.getConfigFolder().toFile();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILENAME = "retrial_key.json";
    private static final Path CONFIG_PATH = Path.of(new File(DIR, "retrial_key.json").getPath(), new String[0]);
    private static ModConfig modConfig;

    public static void load() {
        System.out.println(CONFIG_PATH);
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                modConfig = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
            }
            catch (IOException e) {
                System.err.println("Failed to load config: " + e.getMessage());
                modConfig = new ModConfig();
            }
            modConfig.fillDefaults();
        } else {
            modConfig = new ModConfig();
        }
        ModConfigLoader.save();
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)modConfig, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    public static ModConfig getConfig() {
        return modConfig;
    }
}

