/*
 * Decompiled with CFR 0.152.
 */
package com.Minor2CCh.retrial_key.item;

import com.Minor2CCh.retrial_key.config.ModConfigLoader;
import com.Minor2CCh.retrial_key.mixin.TrialSpawnerAccessor;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RetrialKeyItem
extends Item {
    public RetrialKeyItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player playerEntity;
        BlockPos blockPos;
        Level world = context.getLevel();
        if (this.accelerateTrialSpawner(context, world, blockPos = context.getClickedPos(), playerEntity = context.getPlayer())) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean accelerateTrialSpawner(UseOnContext context, Level world, BlockPos blockPos, Player playerEntity) {
        BlockState blockState = world.getBlockState(blockPos);
        if (blockState.getBlock() instanceof TrialSpawnerBlock && ((TrialSpawnerState)blockState.getValue((Property)TrialSpawnerBlock.STATE)).equals((Object)TrialSpawnerState.COOLDOWN)) {
            if (!world.isClientSide()) {
                this.modifyTrialSpawner(context, world, blockPos, playerEntity, false);
            }
            world.playSound((Entity)playerEntity, blockPos, SoundEvents.VAULT_INSERT_ITEM_FAIL, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.playSound((Entity)playerEntity, blockPos, SoundEvents.TRIAL_SPAWNER_OMINOUS_ACTIVATE, SoundSource.BLOCKS, 1.0f, 0.5f);
            Random random = new Random();
            for (int i = 0; i < 8; ++i) {
                world.addParticle((ParticleOptions)ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER, (double)blockPos.getX() + random.nextDouble(-0.25, 1.25), (double)blockPos.getY() + random.nextDouble(-0.25, 1.25), (double)blockPos.getZ() + random.nextDouble(-0.25, 1.25), 0.0, random.nextDouble(0.05, 0.075), 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS, (double)blockPos.getX() + random.nextDouble(-0.25, 1.25), (double)blockPos.getY() + random.nextDouble(-0.25, 1.25), (double)blockPos.getZ() + random.nextDouble(-0.25, 1.25), 0.0, random.nextDouble(0.05, 0.075), 0.0);
            }
            this.consumeItem(context, playerEntity);
            return true;
        }
        return false;
    }

    protected void modifyTrialSpawner(UseOnContext context, Level world, BlockPos blockPos, Player playerEntity, boolean enforcementSkip) {
        BlockState blockState = world.getBlockState(blockPos);
        TrialSpawnerBlockEntity trialSpawnerBlockEntity = (TrialSpawnerBlockEntity)world.getBlockEntity(blockPos);
        long oldCooldown = ((TrialSpawnerAccessor)Objects.requireNonNull(trialSpawnerBlockEntity).getTrialSpawner().getStateData()).cooldownEnd();
        long remainCooldown = oldCooldown - world.getGameTime();
        if (remainCooldown > 20L) {
            long skipTime = ModConfigLoader.getConfig().skipCooldownTime;
            long newCooldown = skipTime <= 0L || remainCooldown - skipTime <= 0L || enforcementSkip ? 0L : oldCooldown - skipTime;
            ((TrialSpawnerAccessor)Objects.requireNonNull(trialSpawnerBlockEntity).getTrialSpawner().getStateData()).setCooldownEnd(newCooldown);
            if (newCooldown == 0L) {
                world.setBlockAndUpdate(blockPos, (BlockState)((BlockState)blockState.setValue((Property)TrialSpawnerBlock.STATE, (Comparable)TrialSpawnerState.WAITING_FOR_PLAYERS)).setValue((Property)TrialSpawnerBlock.OMINOUS, (Comparable)Boolean.FALSE));
            }
        }
    }

    protected void consumeItem(UseOnContext context, Player playerEntity) {
        if (context.getItemInHand().getItem().getDefaultMaxStackSize() > 1) {
            context.getItemInHand().consume(1, (LivingEntity)playerEntity);
        } else if (context.getItemInHand().isDamageableItem()) {
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)playerEntity, context.getHand().asEquipmentSlot());
        }
        playerEntity.getCooldowns().addCooldown(this.getDefaultInstance(), 30);
    }
}

