/*
 * Decompiled with CFR 0.152.
 */
package com.Minor2CCh.retrial_key.item;

import com.Minor2CCh.retrial_key.config.ModConfigLoader;
import com.Minor2CCh.retrial_key.item.RetrialKeyItem;
import com.Minor2CCh.retrial_key.mixin.TrialSpawnerAccessor;
import com.Minor2CCh.retrial_key.registry.ModItems;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class UnstableRetrialKeyItem
extends RetrialKeyItem {
    public static double UNSTABLE_PROBABILITY = Math.min(1.0, Math.max(ModConfigLoader.getConfig().unstableEventProbably, 0.0));

    public UnstableRetrialKeyItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    protected void modifyTrialSpawner(UseOnContext context, Level world, BlockPos blockPos, Player playerEntity, boolean enforcementSkip) {
        Random random = new Random();
        if ((double)random.nextFloat(1.0f) < UNSTABLE_PROBABILITY) {
            int forkID = random.nextInt(8);
            switch (forkID) {
                case 0: {
                    break;
                }
                case 1: {
                    super.modifyTrialSpawner(context, world, blockPos, playerEntity, true);
                    BlockState blockState1 = world.getBlockState(blockPos);
                    world.setBlockAndUpdate(blockPos, (BlockState)blockState1.setValue((Property)TrialSpawnerBlock.OMINOUS, (Comparable)Boolean.TRUE));
                    break;
                }
                case 2: {
                    super.modifyTrialSpawner(context, world, blockPos, playerEntity, false);
                    playerEntity.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 200, 0, false, false, true), null);
                    playerEntity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200, 0, false, false, true), null);
                    break;
                }
                case 3: {
                    super.modifyTrialSpawner(context, world, blockPos, playerEntity, false);
                    int dropPotato = random.nextInt(2, Items.POISONOUS_POTATO.getDefaultMaxStackSize());
                    for (int i = 0; i < dropPotato; ++i) {
                        Block.popResource((Level)world, (BlockPos)blockPos, (ItemStack)Items.POISONOUS_POTATO.getDefaultInstance());
                    }
                    break;
                }
                case 4: {
                    super.modifyTrialSpawner(context, world, blockPos, playerEntity, false);
                    playerEntity.addEffect(new MobEffectInstance(MobEffects.NAUSEA, 200, 1, false, false, true), null);
                    playerEntity.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 200, 3, false, false, true), null);
                    break;
                }
                case 5: {
                    super.modifyTrialSpawner(context, world, blockPos, playerEntity, true);
                    TrialSpawnerBlockEntity trialSpawnerBlockEntity = (TrialSpawnerBlockEntity)world.getBlockEntity(blockPos);
                    ((TrialSpawnerAccessor)Objects.requireNonNull(trialSpawnerBlockEntity).getTrialSpawner().getStateData()).setTotalSpawnedMobs(-6);
                    if (!playerEntity.hasEffect(MobEffects.TRIAL_OMEN) && !playerEntity.hasEffect(MobEffects.BAD_OMEN)) break;
                    BlockState blockState5 = world.getBlockState(blockPos);
                    world.setBlockAndUpdate(blockPos, (BlockState)blockState5.setValue((Property)TrialSpawnerBlock.OMINOUS, (Comparable)Boolean.TRUE));
                    break;
                }
                case 6: {
                    super.modifyTrialSpawner(context, world, blockPos, playerEntity, false);
                    SimpleExplosionDamageCalculator EXPLOSION_BEHAVIOR = new SimpleExplosionDamageCalculator(true, false, Optional.of(Float.valueOf(1.22f)), BuiltInRegistries.BLOCK.get(BlockTags.BLOCKS_WIND_CHARGE_EXPLOSIONS).map(Function.identity()));
                    WindCharge windChargeEntity = new WindCharge(world, context.getClickLocation().x(), context.getClickLocation().y(), context.getClickLocation().z(), new Vec3(0.0, -0.125, 0.0));
                    world.explode((Entity)windChargeEntity, null, (ExplosionDamageCalculator)EXPLOSION_BEHAVIOR, windChargeEntity.getX(), windChargeEntity.getY(), windChargeEntity.getZ(), 2.4f, false, Level.ExplosionInteraction.TRIGGER, (ParticleOptions)ParticleTypes.GUST_EMITTER_SMALL, (ParticleOptions)ParticleTypes.GUST_EMITTER_LARGE, WeightedList.of(), (Holder)SoundEvents.WIND_CHARGE_BURST);
                    break;
                }
                case 7: {
                    super.modifyTrialSpawner(context, world, blockPos, playerEntity, false);
                    for (int i = 0; i < 16; ++i) {
                        double d = playerEntity.getX() + (playerEntity.getRandom().nextDouble() - 0.5) * 16.0;
                        double e = Mth.clamp((double)(playerEntity.getY() + (double)(playerEntity.getRandom().nextInt(16) - 8)), (double)world.getMinY(), (double)(world.getMinY() + ((ServerLevel)world).getLogicalHeight() - 1));
                        double f = playerEntity.getZ() + (playerEntity.getRandom().nextDouble() - 0.5) * 16.0;
                        if (playerEntity.isPassenger()) {
                            playerEntity.stopRiding();
                        }
                        Vec3 vec3d = playerEntity.position();
                        if (!playerEntity.randomTeleport(d, e, f, true)) continue;
                        world.gameEvent((Holder)GameEvent.TELEPORT, vec3d, GameEvent.Context.of((Entity)playerEntity));
                        SoundEvent soundEvent = SoundEvents.CHORUS_FRUIT_TELEPORT;
                        SoundSource soundCategory = SoundSource.PLAYERS;
                        world.playSound(null, playerEntity.getX(), playerEntity.getY(), playerEntity.getZ(), soundEvent, soundCategory);
                        playerEntity.resetFallDistance();
                        break;
                    }
                    playerEntity.resetCurrentImpulseContext();
                    playerEntity.getCooldowns().addCooldown(this.getDefaultInstance(), 20);
                }
            }
            if (!world.isClientSide()) {
                playerEntity.displayClientMessage((Component)Component.translatable((String)(((Item)ModItems.UNSTABLE_RETRIAL_KEY.get()).getDescriptionId() + ".fail." + forkID)), true);
            }
        } else {
            super.modifyTrialSpawner(context, world, blockPos, playerEntity, false);
        }
    }
}

