/*
 * Decompiled with CFR 0.152.
 */
package com.Minor2CCh.retrial_key.registry;

import com.Minor2CCh.retrial_key.config.ModConfigLoader;
import com.Minor2CCh.retrial_key.item.KeyWayMoldItem;
import com.Minor2CCh.retrial_key.item.RetrialKeyItem;
import com.Minor2CCh.retrial_key.item.UnstableRetrialKeyItem;
import com.Minor2CCh.retrial_key.registry.ModItemGroup;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"retrial_key", (ResourceKey)Registries.ITEM);
    public static final int KEY_DURABILITY = ModConfigLoader.getConfig().heavyRetrialKeyDurability;
    public static final RegistrySupplier<Item> RETRIAL_KEY = ModItems.registerItem("retrial_key", () -> new RetrialKeyItem(new Item.Properties().arch$tab(ModItemGroup.TAB_RETRIAL_KEY).setId(ModItems.keyOfItem("retrial_key"))));
    public static final RegistrySupplier<Item> KEY_WAY = ModItems.registerItem("key_way", () -> new Item(new Item.Properties().arch$tab(ModItemGroup.TAB_RETRIAL_KEY).setId(ModItems.keyOfItem("key_way"))));
    public static final RegistrySupplier<Item> KEY_WAY_MOLD = ModItems.registerItem("key_way_mold", () -> new KeyWayMoldItem(new Item.Properties().arch$tab(ModItemGroup.TAB_RETRIAL_KEY).stacksTo(1).setId(ModItems.keyOfItem("key_way_mold"))));
    public static final RegistrySupplier<Item> HEAVY_RETRIAL_KEY = ModItems.registerItem("heavy_retrial_key", () -> new RetrialKeyItem(new Item.Properties().arch$tab(ModItemGroup.TAB_RETRIAL_KEY).durability(ModItems.getKeyDurability()).rarity(Rarity.EPIC).setId(ModItems.keyOfItem("heavy_retrial_key"))));
    public static final RegistrySupplier<Item> INFINITE_RETRIAL_KEY = ModItems.registerItem("infinite_retrial_key", () -> new RetrialKeyItem(new Item.Properties().arch$tab(ModItemGroup.TAB_RETRIAL_KEY).stacksTo(1).rarity(Rarity.EPIC).setId(ModItems.keyOfItem("infinite_retrial_key"))));
    public static final RegistrySupplier<Item> TRIAL_CORE = ModItems.registerItem("trial_core", () -> new Item(new Item.Properties().arch$tab(ModItemGroup.TAB_RETRIAL_KEY).setId(ModItems.keyOfItem("trial_core"))));
    public static final RegistrySupplier<Item> UNSTABLE_RETRIAL_KEY = ModItems.registerItem("unstable_retrial_key", () -> new UnstableRetrialKeyItem(new Item.Properties().arch$tab(ModItemGroup.TAB_RETRIAL_KEY).setId(ModItems.keyOfItem("unstable_retrial_key"))));

    private static <T extends Item> RegistrySupplier<T> registerItem(String idPath, Supplier<T> item) {
        return ITEMS.register(idPath, item);
    }

    public static void init() {
        ITEMS.register();
    }

    public static int getKeyDurability() {
        return Math.max(KEY_DURABILITY, 1);
    }

    private static ResourceKey<Item> keyOfItem(String name) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"retrial_key", (String)name));
    }
}

