/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.client.hud.ElementRegistry;
import wayoftime.bloodmagic.impl.BloodMagicAPI;

@Mod.EventBusSubscriber(modid="bloodmagic", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigManager {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    @SubscribeEvent
    public static void onCommonReload(ModConfigEvent ev) {
        if (ev.getConfig().getSpec().equals(COMMON_SPEC)) {
            BloodMagic.handleConfigValues(BloodMagicAPI.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void onClientReload(ModConfigEvent ev) {
        if (ev.getConfig().getSpec().equals(CLIENT_SPEC)) {
            System.out.println("Reloading...?");
            ElementRegistry.readConfig();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> wellOfSuffering;
        public final ForgeConfigSpec.IntValue sacrificialDaggerConversion;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> sacrificialValues;
        public final ForgeConfigSpec.BooleanValue makeDungeonRitualCreativeOnly;
        public final ForgeConfigSpec.IntValue entitySacrificeDefault;
        public final ForgeConfigSpec.IntValue defaultUpgradePoints;
        public final ForgeConfigSpec.IntValue evolvedUpgradePoints;
        public final ForgeConfigSpec.ConfigValue<Integer> activation_cost;
        public final ForgeConfigSpec.ConfigValue<Integer> refresh_cost;
        public final ForgeConfigSpec.ConfigValue<Double> min_raw_will;
        public final ForgeConfigSpec.ConfigValue<Double> min_corrosive_will;
        public final ForgeConfigSpec.ConfigValue<Double> min_destructive_will;
        public final ForgeConfigSpec.ConfigValue<Double> min_steadfast_will;
        public final ForgeConfigSpec.ConfigValue<Double> min_vengeful_will;
        public final ForgeConfigSpec.ConfigValue<Double> store_cost;
        public final ForgeConfigSpec.ConfigValue<Double> harm_cost;
        public final ForgeConfigSpec.ConfigValue<Double> fortune_cost;
        public final ForgeConfigSpec.ConfigValue<Double> silk_touch_cost;
        public final ForgeConfigSpec.ConfigValue<Double> growth_cost;
        public final ForgeConfigSpec.ConfigValue<Integer> hurt_damage;
        public final ForgeConfigSpec.ConfigValue<Integer> max_budding_blocks;
        public final ForgeConfigSpec.ConfigValue<Integer> max_mobs_harmed;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Amount of LP the Sacrificial Dagger should provide for each damage dealt. Default value 100");
            this.sacrificialDaggerConversion = builder.defineInRange("sacrificialDaggerConversion", 100, 0, 10000);
            builder.comment(new String[]{"Declares the amount of LP gained per HP sacrificed for the given entity.", "Setting the value to 0 will blacklist it.", "Use the registry name of the entity followed by a ';' and then the value you want.", "Vanilla entities do not require the modid."});
            this.sacrificialValues = builder.defineList("sacrificialValues", (List)ImmutableList.of((Object)"villager;100", (Object)"slime;15", (Object)"enderman;10", (Object)"cow;100", (Object)"chicken;100", (Object)"horse;100", (Object)"sheep;100", (Object)"wolf;100", (Object)"ocelot;100", (Object)"pig;100", (Object)"rabbit;100", (Object)"dummmmmmy:target_dummy;0", (Object[])new String[0]), obj -> true);
            builder.comment(new String[]{"Stops the listed entities from being used in the Well of Suffering.", "Use the registry name of the entity. Vanilla entities do not require the modid."});
            this.wellOfSuffering = builder.defineList("wellOfSuffering", (List)ImmutableList.of((Object)"dummmmmmy:target_dummy"), obj -> true);
            builder.comment("Declares the amount of LP gained per HP sacrificed for any entity not defined specifically. Default value 25");
            this.entitySacrificeDefault = builder.defineInRange("defaultSacrificeValue", 25, 0, 10000);
            builder.comment("Amount of upgrade points the living armour has by default. Default value 100");
            this.defaultUpgradePoints = builder.defineInRange("default_upgrade_points", 100, 0, 2000000000);
            builder.comment("Amount of upgrade points the living armour has when evolved. Default value 300");
            this.evolvedUpgradePoints = builder.defineInRange("evolved_upgrade_points", 300, 0, 2000000000);
            builder.comment(new String[]{"State that the dungeon spawning ritual can only be activated when using a Creative Activation Crystal.", "Used on servers for if you do not trust your players to not destroy other people's bases."});
            this.makeDungeonRitualCreativeOnly = builder.define("makeDungeonRitualCreativeOnly", false);
            builder.push("Geode Ritual");
            this.activation_cost = builder.define("activation_cost", (Object)50000);
            this.refresh_cost = builder.define("refresh_cost", (Object)50);
            this.min_raw_will = builder.define("min_raw_will", (Object)50.0);
            this.min_corrosive_will = builder.define("min_corrosive_will", (Object)50.0);
            this.min_destructive_will = builder.define("min_destructive_will", (Object)50.0);
            this.min_steadfast_will = builder.define("min_steadfast_will", (Object)50.0);
            this.min_vengeful_will = builder.define("min_vengeful_will", (Object)50.0);
            this.store_cost = builder.define("store_cost", (Object)1.0);
            this.harm_cost = builder.define("harm_cost", (Object)0.125);
            this.fortune_cost = builder.define("fortune_cost", (Object)1.0);
            this.silk_touch_cost = builder.define("silk_touch_cost", (Object)1.0);
            this.growth_cost = builder.define("growth_cost", (Object)0.5);
            this.hurt_damage = builder.define("hurt_damage", (Object)2);
            this.max_budding_blocks = builder.defineInRange("max_budding_blocks", 7, 1, 15);
            this.max_mobs_harmed = builder.define("max_harmed", (Object)8);
        }
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue alwaysRenderRoutingLines;
        public final ForgeConfigSpec.BooleanValue sigilHoldingSkipsEmptySlots;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"Always render the beams between routing nodes.", "If disabled, the beams will only render while the Node Router is held."}).push("client");
            this.alwaysRenderRoutingLines = builder.define("alwaysRenderRoutingLines", false);
            builder.comment(new String[]{"When cycling through slots, the Sigil of Holding will skip over empty slots and move to the next occupied one.", "If disabled, it will behave identically to the default hotbar."});
            this.sigilHoldingSkipsEmptySlots = builder.define("sigilHoldingSkipsEmptySlots", false);
            builder.pop();
        }
    }
}

