/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;
import org.jetbrains.annotations.NotNull;
import wayoftime.bloodmagic.common.block.BlockMimic;
import wayoftime.bloodmagic.common.tile.TileMimic;

public class MimicBakedModel
implements IDynamicBakedModel {
    public final ResourceLocation texture;

    public MimicBakedModel(ResourceLocation texture) {
        this.texture = texture;
    }

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(this.texture);
    }

    public boolean m_7547_() {
        return false;
    }

    private void putVertex(QuadBakingVertexConsumer quadBaker, Vec3 normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float r, float g, float b) {
        quadBaker.m_5483_(x, y, z);
        quadBaker.m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_);
        quadBaker.m_85950_(r, g, b, 1.0f);
        quadBaker.m_7421_(sprite.m_118367_((double)u), sprite.m_118393_((double)v));
        quadBaker.setSprite(sprite);
        quadBaker.setDirection(Direction.m_122366_((double)normal.f_82479_, (double)normal.f_82480_, (double)normal.f_82481_));
        quadBaker.m_5752_();
    }

    private BakedQuad createQuad(Vec3 vec1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite) {
        Vec3 normal = v3.m_82546_(v2).m_82537_(vec1.m_82546_(v2)).m_82541_();
        QuadBakingVertexConsumer.Buffered quadBaker = new QuadBakingVertexConsumer.Buffered();
        this.putVertex((QuadBakingVertexConsumer)quadBaker, normal, vec1.f_82479_, vec1.f_82480_, vec1.f_82481_, 0.0f, 0.0f, sprite, 1.0f, 1.0f, 1.0f);
        this.putVertex((QuadBakingVertexConsumer)quadBaker, normal, v2.f_82479_, v2.f_82480_, v2.f_82481_, 0.0f, 16.0f, sprite, 1.0f, 1.0f, 1.0f);
        this.putVertex((QuadBakingVertexConsumer)quadBaker, normal, v3.f_82479_, v3.f_82480_, v3.f_82481_, 16.0f, 16.0f, sprite, 1.0f, 1.0f, 1.0f);
        this.putVertex((QuadBakingVertexConsumer)quadBaker, normal, v4.f_82479_, v4.f_82480_, v4.f_82481_, 16.0f, 0.0f, sprite, 1.0f, 1.0f, 1.0f);
        return quadBaker.getQuad();
    }

    private static Vec3 v(double x, double y, double z) {
        return new Vec3(x, y, z);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType layer) {
        BlockState mimic = (BlockState)extraData.get(TileMimic.MIMIC);
        if (mimic != null && !(mimic.m_60734_() instanceof BlockMimic)) {
            BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(mimic);
            if (layer == null || model.getRenderTypes(mimic, rand, extraData).contains(layer)) {
                try {
                    return model.getQuads(mimic, side, rand, ModelData.EMPTY, layer);
                }
                catch (Exception e) {
                    return Collections.emptyList();
                }
            }
            return Collections.emptyList();
        }
        if (side != null || layer != null && !layer.equals(RenderType.m_110451_())) {
            return Collections.emptyList();
        }
        TextureAtlasSprite texture = this.getTexture();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        double l = 0.0;
        double r = 1.0;
        quads.add(this.createQuad(MimicBakedModel.v(l, r, l), MimicBakedModel.v(l, r, r), MimicBakedModel.v(r, r, r), MimicBakedModel.v(r, r, l), texture));
        quads.add(this.createQuad(MimicBakedModel.v(l, l, l), MimicBakedModel.v(r, l, l), MimicBakedModel.v(r, l, r), MimicBakedModel.v(l, l, r), texture));
        quads.add(this.createQuad(MimicBakedModel.v(r, r, r), MimicBakedModel.v(r, l, r), MimicBakedModel.v(r, l, l), MimicBakedModel.v(r, r, l), texture));
        quads.add(this.createQuad(MimicBakedModel.v(l, r, l), MimicBakedModel.v(l, l, l), MimicBakedModel.v(l, l, r), MimicBakedModel.v(l, r, r), texture));
        quads.add(this.createQuad(MimicBakedModel.v(r, r, l), MimicBakedModel.v(r, l, l), MimicBakedModel.v(l, l, l), MimicBakedModel.v(l, r, l), texture));
        quads.add(this.createQuad(MimicBakedModel.v(l, r, r), MimicBakedModel.v(l, l, r), MimicBakedModel.v(r, l, r), MimicBakedModel.v(r, r, r), texture));
        return quads;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.getTexture();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }
}

