/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.data;

import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.block.BlockAlchemicalReactionChamber;
import wayoftime.bloodmagic.common.block.BlockDemonCrystal;
import wayoftime.bloodmagic.common.block.BlockInversionPillarEnd;
import wayoftime.bloodmagic.common.block.BlockRoutingNode;
import wayoftime.bloodmagic.common.block.BlockShapedExplosive;
import wayoftime.bloodmagic.common.block.BlockSpecialDungeonSeal;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.block.base.BlockPillarCap;
import wayoftime.bloodmagic.common.block.type.PillarCapType;
import wayoftime.bloodmagic.common.block.type.SpecialSealType;

public class GeneratorBlockStates
extends BlockStateProvider {
    private static Map<EnumDemonWillType, String> suffixMap = Map.of(EnumDemonWillType.DEFAULT, "", EnumDemonWillType.CORROSIVE, "_c", EnumDemonWillType.DESTRUCTIVE, "_d", EnumDemonWillType.STEADFAST, "_s", EnumDemonWillType.VENGEFUL, "_v");

    public GeneratorBlockStates(PackOutput packOutput, ExistingFileHelper exFileHelper) {
        super(packOutput, "bloodmagic", exFileHelper);
    }

    protected void registerStatesAndModels() {
        ResourceLocation texture;
        String basePath;
        for (RegistryObject block : BloodMagicBlocks.BASICBLOCKS.getEntries()) {
            this.buildCubeAll((Block)block.get());
        }
        for (RegistryObject block : BloodMagicBlocks.DUNGEONBLOCKS.getEntries()) {
            this.buildDungeonBlock((Block)block.get());
        }
        this.buildRandomStone((Block)BloodMagicBlocks.DUNGEON_STONE.get());
        this.buildRandomStone((Block)BloodMagicBlocks.CORROSIVE_DUNGEON_STONE.get());
        this.buildRandomStone((Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_STONE.get());
        this.buildRandomStone((Block)BloodMagicBlocks.STEADFAST_DUNGEON_STONE.get());
        this.buildRandomStone((Block)BloodMagicBlocks.VENGEFUL_DUNGEON_STONE.get());
        for (RegistryObject block : BloodMagicBlocks.DECORATIVE_STAIR.getEntries()) {
            basePath = ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_();
            texture = new ResourceLocation("bloodmagic", "block/dungeon/" + basePath.replaceAll("_stairs", ""));
            this.stairsBlock((StairBlock)block.get(), texture);
        }
        this.stairsBlock((StairBlock)BloodMagicBlocks.DUNGEON_BRICK_STAIRS.get(), BloodMagic.rl("block/dungeon/dungeon_brick1"));
        for (RegistryObject block : BloodMagicBlocks.DECORATIVE_SLAB.getEntries()) {
            basePath = ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_();
            texture = new ResourceLocation("bloodmagic", "block/dungeon/" + basePath.replaceAll("_slab", ""));
            ResourceLocation fullBlock = new ResourceLocation("bloodmagic", "block/" + basePath.replaceAll("_slab", ""));
            this.slabBlock((SlabBlock)block.get(), fullBlock, texture);
        }
        for (RegistryObject block : BloodMagicBlocks.DECORATIVE_WALL.getEntries()) {
            basePath = ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_();
            texture = new ResourceLocation("bloodmagic", "block/dungeon/" + basePath.replaceAll("_wall", ""));
            this.wallBlock((WallBlock)block.get(), texture);
            ModelBuilder file = this.models().wallInventory(basePath + "_inventory", texture);
            file.assertExistence();
        }
        for (RegistryObject block : BloodMagicBlocks.DECORATIVE_GATE.getEntries()) {
            basePath = ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_();
            texture = new ResourceLocation("bloodmagic", "block/dungeon/" + basePath.replaceAll("_gate", ""));
            this.fenceGateBlock((FenceGateBlock)block.get(), texture);
        }
        this.buildWillPillarCap((Block)BloodMagicBlocks.DUNGEON_PILLAR_CAP.get(), BloodMagic.rl("block/dungeon/dungeon_pillarheart"), BloodMagic.rl("block/dungeon/dungeon_pillarbottom"), BloodMagic.rl("block/dungeon/dungeon_pillartop"));
        this.buildWillPillarCenter((Block)BloodMagicBlocks.DUNGEON_PILLAR_CENTER.get(), BloodMagic.rl("block/dungeon/dungeon_pillar"), BloodMagic.rl("block/dungeon/dungeon_pillarheart"));
        this.buildWillPillarCenter((Block)BloodMagicBlocks.DUNGEON_PILLAR_SPECIAL.get(), BloodMagic.rl("block/dungeon/dungeon_pillarspecial"), BloodMagic.rl("block/dungeon/dungeon_pillarheart"));
        this.buildWillPillarCap((Block)BloodMagicBlocks.CORROSIVE_DUNGEON_PILLAR_CAP.get(), BloodMagic.rl("block/dungeon/dungeon_pillarheart_c"), BloodMagic.rl("block/dungeon/dungeon_pillarbottom_c"), BloodMagic.rl("block/dungeon/dungeon_pillartop_c"));
        this.buildWillPillarCenter((Block)BloodMagicBlocks.CORROSIVE_DUNGEON_PILLAR_CENTER.get(), BloodMagic.rl("block/dungeon/dungeon_pillar_c"), BloodMagic.rl("block/dungeon/dungeon_pillarheart_c"));
        this.buildWillPillarCenter((Block)BloodMagicBlocks.CORROSIVE_DUNGEON_PILLAR_SPECIAL.get(), BloodMagic.rl("block/dungeon/dungeon_pillarspecial_c"), BloodMagic.rl("block/dungeon/dungeon_pillarheart_c"));
        this.buildWillPillarCap((Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_PILLAR_CAP.get(), BloodMagic.rl("block/dungeon/dungeon_pillarheart_d"), BloodMagic.rl("block/dungeon/dungeon_pillarbottom_d"), BloodMagic.rl("block/dungeon/dungeon_pillartop_d"));
        this.buildWillPillarCenter((Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_PILLAR_CENTER.get(), BloodMagic.rl("block/dungeon/dungeon_pillar_d"), BloodMagic.rl("block/dungeon/dungeon_pillarheart_d"));
        this.buildWillPillarCenter((Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_PILLAR_SPECIAL.get(), BloodMagic.rl("block/dungeon/dungeon_pillarspecial_d"), BloodMagic.rl("block/dungeon/dungeon_pillarheart_d"));
        this.buildWillPillarCap((Block)BloodMagicBlocks.STEADFAST_DUNGEON_PILLAR_CAP.get(), BloodMagic.rl("block/dungeon/dungeon_pillarheart_s"), BloodMagic.rl("block/dungeon/dungeon_pillarbottom_s"), BloodMagic.rl("block/dungeon/dungeon_pillartop_s"));
        this.buildWillPillarCenter((Block)BloodMagicBlocks.STEADFAST_DUNGEON_PILLAR_CENTER.get(), BloodMagic.rl("block/dungeon/dungeon_pillar_s"), BloodMagic.rl("block/dungeon/dungeon_pillarheart_s"));
        this.buildWillPillarCenter((Block)BloodMagicBlocks.STEADFAST_DUNGEON_PILLAR_SPECIAL.get(), BloodMagic.rl("block/dungeon/dungeon_pillarspecial_s"), BloodMagic.rl("block/dungeon/dungeon_pillarheart_s"));
        this.buildWillPillarCap((Block)BloodMagicBlocks.VENGEFUL_DUNGEON_PILLAR_CAP.get(), BloodMagic.rl("block/dungeon/dungeon_pillarheart_v"), BloodMagic.rl("block/dungeon/dungeon_pillarbottom_v"), BloodMagic.rl("block/dungeon/dungeon_pillartop_v"));
        this.buildWillPillarCenter((Block)BloodMagicBlocks.VENGEFUL_DUNGEON_PILLAR_CENTER.get(), BloodMagic.rl("block/dungeon/dungeon_pillar_v"), BloodMagic.rl("block/dungeon/dungeon_pillarheart_v"));
        this.buildWillPillarCenter((Block)BloodMagicBlocks.VENGEFUL_DUNGEON_PILLAR_SPECIAL.get(), BloodMagic.rl("block/dungeon/dungeon_pillarspecial_v"), BloodMagic.rl("block/dungeon/dungeon_pillarheart_v"));
        this.buildCubeAll((Block)BloodMagicBlocks.BLOOD_LIGHT.get());
        this.buildCubeAll((Block)BloodMagicBlocks.BLANK_RITUAL_STONE.get());
        this.buildCubeAll((Block)BloodMagicBlocks.AIR_RITUAL_STONE.get());
        this.buildCubeAll((Block)BloodMagicBlocks.WATER_RITUAL_STONE.get());
        this.buildCubeAll((Block)BloodMagicBlocks.FIRE_RITUAL_STONE.get());
        this.buildCubeAll((Block)BloodMagicBlocks.EARTH_RITUAL_STONE.get());
        this.buildCubeAll((Block)BloodMagicBlocks.DUSK_RITUAL_STONE.get());
        this.buildCubeAll((Block)BloodMagicBlocks.DAWN_RITUAL_STONE.get());
        this.buildFarmland((Block)BloodMagicBlocks.NETHER_SOIL.get(), BloodMagic.rl("block/nether_soil"), new ResourceLocation("block/netherrack"));
        this.buildFurnace((Block)BloodMagicBlocks.ALCHEMICAL_REACTION_CHAMBER.get());
        this.buildCrystal((Block)BloodMagicBlocks.RAW_CRYSTAL_BLOCK.get(), "defaultcrystal");
        this.buildCrystal((Block)BloodMagicBlocks.CORROSIVE_CRYSTAL_BLOCK.get(), "corrosivecrystal");
        this.buildCrystal((Block)BloodMagicBlocks.DESTRUCTIVE_CRYSTAL_BLOCK.get(), "destructivecrystal");
        this.buildCrystal((Block)BloodMagicBlocks.VENGEFUL_CRYSTAL_BLOCK.get(), "vengefulcrystal");
        this.buildCrystal((Block)BloodMagicBlocks.STEADFAST_CRYSTAL_BLOCK.get(), "steadfastcrystal");
        this.buildRoutingNode((Block)BloodMagicBlocks.ROUTING_NODE_BLOCK.get(), "routingnode");
        this.buildRoutingNode((Block)BloodMagicBlocks.INPUT_ROUTING_NODE_BLOCK.get(), "inputroutingnode");
        this.buildRoutingNode((Block)BloodMagicBlocks.OUTPUT_ROUTING_NODE_BLOCK.get(), "outputroutingnode");
        this.buildMasterRoutingNode((Block)BloodMagicBlocks.MASTER_ROUTING_NODE_BLOCK.get());
        this.buildAssortedBlock((Block)BloodMagicBlocks.DUNGEON_BRICK_ASSORTED.get(), this.modLoc("dungeon_brick1"), this.modLoc("dungeon_brick2"), this.modLoc("dungeon_brick3"));
        this.buildDungeonBlock((Block)BloodMagicBlocks.DUNGEON_ORE.get());
        this.buildCubeAllWithTextureName("etherealopaquemimic");
        this.buildCubeAllWithTextureName("sentientmimic");
        this.buildCubeAllWithTextureName("solidclearmimic");
        this.buildCubeAllWithTextureName("solidlightmimic");
        this.buildCubeAllWithTextureName("solidopaquemimic");
        this.buildCubeAll((Block)BloodMagicBlocks.SPECTRAL.get());
        this.buildCubeAll((Block)BloodMagicBlocks.ALCHEMY_ARRAY.get());
        this.buildCubeTop((Block)BloodMagicBlocks.TELEPOSER.get(), this.modLoc("block/teleposer_side"), this.modLoc("block/teleposer_top"));
        this.buildCubeAll((Block)BloodMagicBlocks.DUNGEON_CONTROLLER.get());
        this.buildCubeAll((Block)BloodMagicBlocks.DUNGEON_SEAL.get());
        this.buildSpecialDungeonSeal((Block)BloodMagicBlocks.SPECIAL_DUNGEON_SEAL.get());
        this.buildCrop((Block)BloodMagicBlocks.GROWING_DOUBT.get(), CropBlock.f_52244_, 7, BloodMagic.rl("block/creeping_doubt_1"), BloodMagic.rl("block/creeping_doubt_2"), BloodMagic.rl("block/creeping_doubt_3"), BloodMagic.rl("block/creeping_doubt_4"), BloodMagic.rl("block/creeping_doubt_5"), BloodMagic.rl("block/creeping_doubt_6"), BloodMagic.rl("block/creeping_doubt_7"), BloodMagic.rl("block/creeping_doubt_8"));
        this.buildCrossCrop((Block)BloodMagicBlocks.WEAK_TAU.get(), CropBlock.f_52244_, 7, this.modLoc("block/weak_tau_1"), this.modLoc("block/weak_tau_2"), this.modLoc("block/weak_tau_3"), this.modLoc("block/weak_tau_4"), this.modLoc("block/weak_tau_5"), this.modLoc("block/weak_tau_6"), this.modLoc("block/weak_tau_7"), this.modLoc("block/weak_tau_8"));
        this.buildCrossCrop((Block)BloodMagicBlocks.STRONG_TAU.get(), CropBlock.f_52244_, 7, this.modLoc("block/weak_tau_1"), this.modLoc("block/strong_tau_2"), this.modLoc("block/strong_tau_3"), this.modLoc("block/strong_tau_4"), this.modLoc("block/strong_tau_5"), this.modLoc("block/strong_tau_6"), this.modLoc("block/strong_tau_7"), this.modLoc("block/strong_tau_8"));
        this.buildShapedCharge((Block)BloodMagicBlocks.SHAPED_CHARGE.get(), "shaped_charge", this.modLoc("block/sub/shaped_charge"), this.modLoc("block/dungeon/dungeon_stone"), this.modLoc("block/dungeon/dungeon_tile"), this.modLoc("block/blankrune"), this.modLoc("block/largebloodstonebrick"), this.modLoc("models/defaultcrystal"));
        this.buildShapedCharge((Block)BloodMagicBlocks.DEFORESTER_CHARGE.get(), "deforester_charge", this.modLoc("block/sub/shaped_charge"), new ResourceLocation("block/oak_log_top"), new ResourceLocation("block/oak_log_top"), this.modLoc("block/blankrune"), new ResourceLocation("block/oak_planks"), this.modLoc("models/defaultcrystal"));
        this.buildShapedCharge((Block)BloodMagicBlocks.VEINMINE_CHARGE.get(), "veinmine_charge", this.modLoc("block/sub/shaped_charge"), new ResourceLocation("block/sandstone_bottom"), new ResourceLocation("block/sandstone_bottom"), this.modLoc("block/blankrune"), new ResourceLocation("block/sand"), this.modLoc("models/defaultcrystal"));
        this.buildShapedCharge((Block)BloodMagicBlocks.FUNGAL_CHARGE.get(), "fungal_charge", this.modLoc("block/sub/shaped_charge"), new ResourceLocation("block/nether_wart_block"), new ResourceLocation("block/crimson_planks"), this.modLoc("block/blankrune"), new ResourceLocation("block/crimson_stem"), this.modLoc("models/defaultcrystal"));
        this.buildAugmentedShapedCharge((Block)BloodMagicBlocks.AUG_SHAPED_CHARGE.get(), "aug_shaped_charge", this.modLoc("block/sub/augment_shaped_charge"), this.modLoc("block/dungeon/dungeon_stone"), this.modLoc("block/dungeon/dungeon_tile"), this.modLoc("block/blankrune"), this.modLoc("block/largebloodstonebrick"), this.modLoc("models/defaultcrystal"), this.modLoc("models/copper_trim"));
        this.buildAugmentedShapedCharge((Block)BloodMagicBlocks.DEFORESTER_CHARGE_2.get(), "deforester_charge_2", this.modLoc("block/sub/augment_shaped_charge"), new ResourceLocation("block/oak_log_top"), new ResourceLocation("block/oak_log_top"), this.modLoc("block/blankrune"), new ResourceLocation("block/oak_planks"), this.modLoc("models/defaultcrystal"), this.modLoc("models/copper_trim"));
        this.buildAugmentedShapedCharge((Block)BloodMagicBlocks.VEINMINE_CHARGE_2.get(), "veinmine_charge_2", this.modLoc("block/sub/augment_shaped_charge"), new ResourceLocation("block/sandstone_bottom"), new ResourceLocation("block/sandstone_bottom"), this.modLoc("block/blankrune"), new ResourceLocation("block/sand"), this.modLoc("models/defaultcrystal"), this.modLoc("models/copper_trim"));
        this.buildAugmentedShapedCharge((Block)BloodMagicBlocks.FUNGAL_CHARGE_2.get(), "fungal_charge_2", this.modLoc("block/sub/augment_shaped_charge"), new ResourceLocation("block/nether_wart_block"), new ResourceLocation("block/crimson_planks"), this.modLoc("block/blankrune"), new ResourceLocation("block/crimson_stem"), this.modLoc("models/defaultcrystal"), this.modLoc("models/copper_trim"));
        this.buildAugmentedShapedCharge((Block)BloodMagicBlocks.SHAPED_CHARGE_DEEP.get(), "shaped_charge_deep", this.modLoc("block/sub/augment_shaped_charge"), this.modLoc("block/dungeon/dungeon_stone"), this.modLoc("block/dungeon/dungeon_tile"), this.modLoc("block/blankrune"), this.modLoc("block/largebloodstonebrick"), new ResourceLocation("block/iron_block"), this.modLoc("models/copper_trim"));
        this.getVariantBuilder((Block)BloodMagicBlocks.INVERSION_PILLAR.get()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent("inversion_pillar", this.modLoc("pillar_mid"))).texture("texture", this.modLoc("models/pillar_mid"));
            return builder.modelFile((ModelFile)model).build();
        });
        this.buildInversionPillarCap((Block)BloodMagicBlocks.INVERSION_PILLAR_CAP.get());
    }

    private void buildSpecialDungeonSeal(Block block) {
        String basePath = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        for (SpecialSealType type : SpecialSealType.values()) {
            ModelBuilder modelFile = this.models().cubeAll(basePath + "_" + type.name().toLowerCase(), this.modLoc("block/" + basePath + "_" + type.name().toLowerCase()));
            builder.partialState().with(BlockSpecialDungeonSeal.SEAL, (Comparable)((Object)type)).modelForState().modelFile((ModelFile)modelFile).addModel();
        }
    }

    private void buildInversionPillarCap(Block block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        ModelBuilder bottomModel = ((BlockModelBuilder)this.models().withExistingParent("inversion_pillar_bottom", this.modLoc("pillar_bottom"))).texture("texture", this.modLoc("models/pillar_base"));
        ModelBuilder topModel = ((BlockModelBuilder)this.models().withExistingParent("inversion_pillar_top", this.modLoc("pillar_top"))).texture("texture", this.modLoc("models/pillar_base"));
        builder.partialState().with(BlockInversionPillarEnd.TYPE, (Comparable)((Object)PillarCapType.BOTTOM)).modelForState().modelFile((ModelFile)bottomModel).addModel();
        builder.partialState().with(BlockInversionPillarEnd.TYPE, (Comparable)((Object)PillarCapType.TOP)).modelForState().modelFile((ModelFile)topModel).addModel();
    }

    private void buildShapedCharge(Block block, String name, ResourceLocation modelPath, ResourceLocation base, ResourceLocation edges, ResourceLocation centerCap, ResourceLocation binding, ResourceLocation core) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, modelPath)).texture("1", edges)).texture("3", base)).texture("4", centerCap)).texture("5", binding)).texture("6", core)).texture("particle", core);
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        builder.partialState().with(BlockShapedExplosive.ATTACHED, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)model).addModel();
        builder.partialState().with(BlockShapedExplosive.ATTACHED, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)model).rotationX(180).addModel();
        builder.partialState().with(BlockShapedExplosive.ATTACHED, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(90).addModel();
        builder.partialState().with(BlockShapedExplosive.ATTACHED, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(270).addModel();
        builder.partialState().with(BlockShapedExplosive.ATTACHED, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)model).rotationX(90).addModel();
        builder.partialState().with(BlockShapedExplosive.ATTACHED, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)model).rotationX(270).addModel();
    }

    private void buildAugmentedShapedCharge(Block block, String name, ResourceLocation modelPath, ResourceLocation base, ResourceLocation edges, ResourceLocation centerCap, ResourceLocation binding, ResourceLocation core, ResourceLocation bracket) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, modelPath)).texture("1", edges)).texture("3", base)).texture("4", centerCap)).texture("5", binding)).texture("2", core)).texture("7", bracket)).texture("particle", core);
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        builder.partialState().with(BlockShapedExplosive.ATTACHED, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)model).addModel();
        builder.partialState().with(BlockShapedExplosive.ATTACHED, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)model).rotationX(180).addModel();
        builder.partialState().with(BlockShapedExplosive.ATTACHED, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(90).addModel();
        builder.partialState().with(BlockShapedExplosive.ATTACHED, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(270).addModel();
        builder.partialState().with(BlockShapedExplosive.ATTACHED, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)model).rotationX(90).addModel();
        builder.partialState().with(BlockShapedExplosive.ATTACHED, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)model).rotationX(270).addModel();
    }

    private void buildCrop(Block block, IntegerProperty prop, int maxAge, ResourceLocation ... textures) {
        String basePath = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        for (int i = 0; i <= maxAge; ++i) {
            ModelBuilder modelFile = this.models().crop(basePath + "_" + (i + 1), textures[i]);
            builder.partialState().with((Property)prop, (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)modelFile).addModel();
        }
    }

    private void buildCrossCrop(Block block, IntegerProperty prop, int maxAge, ResourceLocation ... textures) {
        String basePath = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        for (int i = 0; i <= maxAge; ++i) {
            ModelBuilder modelFile = this.models().cross(basePath + "_" + (i + 1), textures[i]);
            builder.partialState().with((Property)prop, (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)modelFile).addModel();
        }
    }

    private void buildFarmland(Block block, ResourceLocation top, ResourceLocation side) {
        String basePath = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        this.getVariantBuilder(block).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            ModelBuilder file = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(basePath, "template_farmland")).texture("top", top)).texture("dirt", side);
            return builder.modelFile((ModelFile)file).build();
        });
    }

    private void buildCubeAllWithTextureName(String texture) {
        ((BlockModelBuilder)this.models().cubeAll(texture, BloodMagic.rl("block/" + texture))).assertExistence();
    }

    private void buildAssortedBlock(Block block, ResourceLocation ... modelResources) {
        this.getVariantBuilder(block).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            for (int i = 0; i < modelResources.length; ++i) {
                ResourceLocation location = modelResources[i];
                ModelFile.ExistingModelFile file = this.models().getExistingFile(location);
                builder = i < modelResources.length - 1 ? builder.modelFile((ModelFile)file).nextModel() : builder.modelFile((ModelFile)file);
            }
            return builder.build();
        });
    }

    private void buildRandomStone(Block block) {
        ResourceLocation modelLoc = ForgeRegistries.BLOCKS.getKey((Object)block).m_246208_("block/");
        ResourceLocation textureLoc = ForgeRegistries.BLOCKS.getKey((Object)block).m_246208_("block/dungeon/");
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        variantBuilder.forAllStates(state -> {
            ModelBuilder modelFile = this.models().cubeAll(modelLoc.m_135815_(), textureLoc);
            ModelBuilder modelFile_mirrored = ((BlockModelBuilder)this.models().withExistingParent(String.valueOf(modelLoc) + "_mirrored", "cube_mirrored_all")).texture("all", textureLoc);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFile).nextModel().modelFile((ModelFile)modelFile_mirrored).nextModel().modelFile((ModelFile)modelFile).rotationY(180).nextModel().modelFile((ModelFile)modelFile_mirrored).rotationY(180).build();
        });
    }

    private void buildDungeonBlock(Block block) {
        String basePath = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        ModelBuilder modelFile = this.models().cubeAll(basePath, BloodMagic.rl("block/dungeon/" + basePath));
        this.getVariantBuilder(block).forAllStates(arg_0 -> GeneratorBlockStates.lambda$buildDungeonBlock$4((ModelFile)modelFile, arg_0));
    }

    private void buildCubeTop(Block block, ResourceLocation side, ResourceLocation top) {
        String basePath = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        ModelBuilder model = this.models().cubeBottomTop(basePath, side, side, top);
        this.getVariantBuilder(block).forAllStates(arg_0 -> GeneratorBlockStates.lambda$buildCubeTop$5((ModelFile)model, arg_0));
    }

    private void buildWillPillarCenter(Block block, ResourceLocation side, ResourceLocation end) {
        String basePath = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_);
            ModelBuilder modelFile = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(basePath, "cube_column")).texture("side", side)).texture("end", end);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFile).rotationX(axis != Direction.Axis.Y ? 270 : 0).rotationY(axis == Direction.Axis.X ? 270 : 0).build();
        });
    }

    private void buildWillPillarCap(Block block, ResourceLocation end, ResourceLocation bottom, ResourceLocation top) {
        String basePath = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        ModelBuilder upModel = this.models().cubeBottomTop(basePath, top, end, end);
        ModelBuilder downModel = this.models().cubeBottomTop(basePath + "_down", bottom, end, end);
        builder.addModels(builder.partialState().with((Property)BlockPillarCap.FACING, (Comparable)Direction.UP), ConfiguredModel.builder().modelFile((ModelFile)upModel).build());
        builder.addModels(builder.partialState().with((Property)BlockPillarCap.FACING, (Comparable)Direction.SOUTH), ConfiguredModel.builder().modelFile((ModelFile)upModel).rotationX(270).build());
        builder.addModels(builder.partialState().with((Property)BlockPillarCap.FACING, (Comparable)Direction.EAST), ConfiguredModel.builder().modelFile((ModelFile)upModel).rotationX(90).rotationY(90).build());
        builder.addModels(builder.partialState().with((Property)BlockPillarCap.FACING, (Comparable)Direction.DOWN), ConfiguredModel.builder().modelFile((ModelFile)downModel).build());
        builder.addModels(builder.partialState().with((Property)BlockPillarCap.FACING, (Comparable)Direction.NORTH), ConfiguredModel.builder().modelFile((ModelFile)downModel).rotationX(270).build());
        builder.addModels(builder.partialState().with((Property)BlockPillarCap.FACING, (Comparable)Direction.WEST), ConfiguredModel.builder().modelFile((ModelFile)downModel).rotationX(90).rotationY(90).build());
    }

    private void buildCubeAll(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile(this.cubeAll(block)).build());
    }

    private void buildCrystal(Block block, String name) {
        int i;
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        ModelFile[] crystalModels = new ModelFile[7];
        for (i = 0; i < 7; ++i) {
            crystalModels[i] = ((BlockModelBuilder)this.models().withExistingParent("block/crystal/" + name + (i + 1), this.modLoc("crystal" + (i + 1)))).texture("crystal", this.modLoc("models/" + name));
        }
        for (i = 0; i < 7; ++i) {
            Comparable[] intArray = new Integer[7 - i];
            for (int j = i; j < 7; ++j) {
                intArray[j - i] = j;
            }
            for (Direction direction : Direction.values()) {
                ConfiguredModel.Builder partBuilder = builder.part().modelFile(crystalModels[i]);
                switch (direction) {
                    case UP: {
                        break;
                    }
                    case DOWN: {
                        partBuilder = partBuilder.rotationX(180);
                        break;
                    }
                    case EAST: {
                        partBuilder = partBuilder.rotationX(90).rotationY(90);
                        break;
                    }
                    case WEST: {
                        partBuilder = partBuilder.rotationX(90).rotationY(270);
                        break;
                    }
                    case NORTH: {
                        partBuilder = partBuilder.rotationX(90);
                        break;
                    }
                    case SOUTH: {
                        partBuilder = partBuilder.rotationX(270);
                    }
                }
                ((MultiPartBlockStateBuilder.PartBuilder)partBuilder.addModel()).condition((Property)BlockDemonCrystal.AGE, intArray).condition(BlockDemonCrystal.ATTACHED, (Comparable[])new Direction[]{direction}).end();
            }
        }
    }

    private void buildRoutingNode(Block block, String name) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        ModelBuilder nodeModel = ((BlockModelBuilder)this.models().withExistingParent("block/routing/" + name + "core", this.modLoc("routingnodecore"))).texture("core", this.modLoc("models/model" + name));
        ModelBuilder baseModel = ((BlockModelBuilder)this.models().withExistingParent("block/routing/" + name + "base", this.modLoc("routingnodebase"))).texture("base", this.modLoc("models/model" + name));
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)nodeModel).addModel()).end();
        for (Direction direction : Direction.values()) {
            ConfiguredModel.Builder partBuilder = builder.part().modelFile((ModelFile)baseModel);
            BooleanProperty prop = BlockRoutingNode.UP;
            switch (direction) {
                case UP: {
                    prop = BlockRoutingNode.UP;
                    partBuilder = partBuilder.rotationX(180);
                    break;
                }
                case DOWN: {
                    prop = BlockRoutingNode.DOWN;
                    break;
                }
                case EAST: {
                    prop = BlockRoutingNode.EAST;
                    partBuilder = partBuilder.rotationX(90).rotationY(270);
                    break;
                }
                case WEST: {
                    prop = BlockRoutingNode.WEST;
                    partBuilder = partBuilder.rotationX(90).rotationY(90);
                    break;
                }
                case NORTH: {
                    prop = BlockRoutingNode.NORTH;
                    partBuilder = partBuilder.rotationX(270);
                    break;
                }
                case SOUTH: {
                    prop = BlockRoutingNode.SOUTH;
                    partBuilder = partBuilder.rotationX(90);
                }
            }
            ((MultiPartBlockStateBuilder.PartBuilder)partBuilder.addModel()).condition((Property)prop, (Comparable[])new Boolean[]{true}).end();
        }
    }

    private void buildMasterRoutingNode(Block block) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        ModelBuilder nodeModel = this.models().withExistingParent("block/routing/modelmasterroutingnodecore", this.modLoc("masterroutingnodecore"));
        ModelBuilder baseModel = this.models().withExistingParent("block/routing/modelmasterroutingnodebase", this.modLoc("masterroutingnodebase"));
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)nodeModel).addModel()).end();
        for (Direction direction : Direction.values()) {
            ConfiguredModel.Builder partBuilder = builder.part().modelFile((ModelFile)baseModel);
            BooleanProperty prop = BlockRoutingNode.UP;
            switch (direction) {
                case UP: {
                    prop = BlockRoutingNode.UP;
                    partBuilder = partBuilder.rotationX(180);
                    break;
                }
                case DOWN: {
                    prop = BlockRoutingNode.DOWN;
                    break;
                }
                case EAST: {
                    prop = BlockRoutingNode.EAST;
                    partBuilder = partBuilder.rotationX(90).rotationY(270);
                    break;
                }
                case WEST: {
                    prop = BlockRoutingNode.WEST;
                    partBuilder = partBuilder.rotationX(90).rotationY(90);
                    break;
                }
                case NORTH: {
                    prop = BlockRoutingNode.NORTH;
                    partBuilder = partBuilder.rotationX(270);
                    break;
                }
                case SOUTH: {
                    prop = BlockRoutingNode.SOUTH;
                    partBuilder = partBuilder.rotationX(90);
                }
            }
            ((MultiPartBlockStateBuilder.PartBuilder)partBuilder.addModel()).condition((Property)prop, (Comparable[])new Boolean[]{true}).end();
        }
    }

    private void buildFurnace(Block block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        for (Map.Entry<EnumDemonWillType, String> entry : suffixMap.entrySet()) {
            EnumDemonWillType type = entry.getKey();
            String suffix = entry.getValue();
            ModelBuilder furnace_off = this.models().orientableWithBottom("alchemicalreactionchamber" + suffix, BloodMagic.rl("block/arc_side" + suffix), BloodMagic.rl("block/arc_front" + suffix), BloodMagic.rl("block/arc_bottom"), BloodMagic.rl("block/arc_top" + suffix));
            ModelBuilder furnace_on = this.models().orientableWithBottom("alchemicalreactionchamber" + suffix + "_lit", BloodMagic.rl("block/arc_side" + suffix + "_lit"), BloodMagic.rl("block/arc_front" + suffix + "_lit"), BloodMagic.rl("block/arc_bottom"), BloodMagic.rl("block/arc_top" + suffix));
            builder.partialState().with((Property)BlockAlchemicalReactionChamber.FACING, (Comparable)Direction.NORTH).with((Property)BlockAlchemicalReactionChamber.LIT, (Comparable)Boolean.valueOf(false)).with(BlockAlchemicalReactionChamber.TYPE, (Comparable)((Object)type)).modelForState().modelFile((ModelFile)furnace_off).addModel();
            builder.partialState().with((Property)BlockAlchemicalReactionChamber.FACING, (Comparable)Direction.EAST).with((Property)BlockAlchemicalReactionChamber.LIT, (Comparable)Boolean.valueOf(false)).with(BlockAlchemicalReactionChamber.TYPE, (Comparable)((Object)type)).modelForState().modelFile((ModelFile)furnace_off).rotationY(90).addModel();
            builder.partialState().with((Property)BlockAlchemicalReactionChamber.FACING, (Comparable)Direction.SOUTH).with((Property)BlockAlchemicalReactionChamber.LIT, (Comparable)Boolean.valueOf(false)).with(BlockAlchemicalReactionChamber.TYPE, (Comparable)((Object)type)).modelForState().modelFile((ModelFile)furnace_off).rotationY(180).addModel();
            builder.partialState().with((Property)BlockAlchemicalReactionChamber.FACING, (Comparable)Direction.WEST).with((Property)BlockAlchemicalReactionChamber.LIT, (Comparable)Boolean.valueOf(false)).with(BlockAlchemicalReactionChamber.TYPE, (Comparable)((Object)type)).modelForState().modelFile((ModelFile)furnace_off).rotationY(270).addModel();
            builder.partialState().with((Property)BlockAlchemicalReactionChamber.FACING, (Comparable)Direction.NORTH).with((Property)BlockAlchemicalReactionChamber.LIT, (Comparable)Boolean.valueOf(true)).with(BlockAlchemicalReactionChamber.TYPE, (Comparable)((Object)type)).modelForState().modelFile((ModelFile)furnace_on).addModel();
            builder.partialState().with((Property)BlockAlchemicalReactionChamber.FACING, (Comparable)Direction.EAST).with((Property)BlockAlchemicalReactionChamber.LIT, (Comparable)Boolean.valueOf(true)).with(BlockAlchemicalReactionChamber.TYPE, (Comparable)((Object)type)).modelForState().modelFile((ModelFile)furnace_on).rotationY(90).addModel();
            builder.partialState().with((Property)BlockAlchemicalReactionChamber.FACING, (Comparable)Direction.SOUTH).with((Property)BlockAlchemicalReactionChamber.LIT, (Comparable)Boolean.valueOf(true)).with(BlockAlchemicalReactionChamber.TYPE, (Comparable)((Object)type)).modelForState().modelFile((ModelFile)furnace_on).rotationY(180).addModel();
            builder.partialState().with((Property)BlockAlchemicalReactionChamber.FACING, (Comparable)Direction.WEST).with((Property)BlockAlchemicalReactionChamber.LIT, (Comparable)Boolean.valueOf(true)).with(BlockAlchemicalReactionChamber.TYPE, (Comparable)((Object)type)).modelForState().modelFile((ModelFile)furnace_on).rotationY(270).addModel();
        }
    }

    private static /* synthetic */ ConfiguredModel[] lambda$buildCubeTop$5(ModelFile model, BlockState state) {
        return ConfiguredModel.builder().modelFile(model).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$buildDungeonBlock$4(ModelFile modelFile, BlockState state) {
        return ConfiguredModel.builder().modelFile(modelFile).build();
    }
}

