/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.sigil;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import wayoftime.bloodmagic.common.item.IActivatable;
import wayoftime.bloodmagic.common.item.ItemSigil;
import wayoftime.bloodmagic.common.item.sigil.ISigil;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.core.data.SoulTicket;
import wayoftime.bloodmagic.util.helper.NBTHelper;
import wayoftime.bloodmagic.util.helper.NetworkHelper;
import wayoftime.bloodmagic.util.helper.PlayerHelper;

public class ItemSigilToggleable
extends ItemSigil
implements IActivatable {
    public ItemSigilToggleable(Item.Properties property, int lpUsed) {
        super(property, lpUsed);
    }

    @Override
    public boolean getActivated(ItemStack stack) {
        return !stack.m_41619_() && NBTHelper.checkNBT(stack).m_41783_().m_128471_("activated");
    }

    @Override
    public ItemStack setActivatedState(ItemStack stack, boolean activated) {
        if (!stack.m_41619_()) {
            NBTHelper.checkNBT(stack).m_41783_().m_128379_("activated", activated);
            return stack;
        }
        return stack;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof ISigil.Holding) {
            stack = ((ISigil.Holding)stack.m_41720_()).getHeldItem(stack, player);
        }
        if (PlayerHelper.isFakePlayer(player)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!world.f_46443_ && !this.isUnusable(stack)) {
            if (player.m_6144_()) {
                this.setActivatedState(stack, !this.getActivated(stack));
            }
            if (this.getActivated(stack)) {
                return super.m_7203_(world, player, hand);
            }
        }
        return super.m_7203_(world, player, hand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Binding binding;
        Level world = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (stack.m_41720_() instanceof ISigil.Holding) {
            stack = ((ISigil.Holding)stack.m_41720_()).getHeldItem(stack, player);
        }
        if ((binding = this.getBinding(stack)) == null || player.m_6144_()) {
            return InteractionResult.PASS;
        }
        return this.onSigilUse(stack, player, world, blockpos, context.m_43719_(), context.m_43720_()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public boolean onSigilUse(ItemStack itemStack, Player player, Level world, BlockPos blockPos, Direction side, Vec3 hitVec) {
        return false;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.f_46443_ && entityIn instanceof Player && this.getActivated(stack)) {
            if (entityIn.f_19797_ % 100 == 0 && !NetworkHelper.getSoulNetwork(this.getBinding(stack)).syphonAndDamage((Player)entityIn, SoulTicket.item(stack, worldIn, entityIn, this.getLpUsed())).isSuccess()) {
                this.setActivatedState(stack, false);
            }
            this.onSigilUpdate(stack, worldIn, (Player)entityIn, itemSlot, isSelected);
        }
    }

    public void onSigilUpdate(ItemStack stack, Level world, Player player, int itemSlot, boolean isSelected) {
    }
}

