/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.core.util;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.item.ExpandedArmor;
import wayoftime.bloodmagic.core.living.LivingUtil;
import wayoftime.bloodmagic.util.helper.InventoryHelper;

public class PlayerUtil {
    public static ItemStack findItem(Player player, Predicate<ItemStack> requirements) {
        ItemStack offHand = player.m_21206_();
        if (requirements.test(offHand)) {
            return offHand;
        }
        ArrayList<String> checkedInventories = new ArrayList<String>();
        checkedInventories.add("offHandInventory");
        if (BloodMagic.curiosLoaded.booleanValue()) {
            NonNullList<ItemStack> curiosInventory = InventoryHelper.getInventory(player, "curiosInventory");
            for (ItemStack item : curiosInventory) {
                if (!requirements.test(item)) continue;
                return item;
            }
            checkedInventories.add("curiosInventory");
        }
        NonNullList<ItemStack> mainInventory = InventoryHelper.getInventory(player, "mainInventory");
        for (ItemStack item : mainInventory) {
            if (!requirements.test(item)) continue;
            return item;
        }
        checkedInventories.add("mainInventory");
        NonNullList<ItemStack> remainingInventories = InventoryHelper.getAllInventoriesExcluding(player, checkedInventories);
        for (ItemStack item : remainingInventories) {
            if (!requirements.test(item)) continue;
            return item;
        }
        return ItemStack.f_41583_;
    }

    public static Multimap<Attribute, AttributeModifier> handle(Player player, Multimap<Attribute, AttributeModifier> existing) {
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        boolean hasFullSet = LivingUtil.hasFullSet(player);
        if (hasFullSet && existing == null) {
            existing = ((ExpandedArmor)chest.m_41720_()).getAttributeModifiers(EquipmentSlot.CHEST, chest);
            player.m_21204_().m_22178_(existing);
        }
        if (!hasFullSet && existing != null) {
            player.m_21204_().m_22161_(existing);
            existing = null;
        }
        return existing;
    }
}

