/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.network;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import wayoftime.bloodmagic.common.container.item.ContainerFilter;
import wayoftime.bloodmagic.common.item.inventory.InventoryFilter;
import wayoftime.bloodmagic.util.BMLog;

public class FilterGhostSlotPacket {
    private int ghostSlot;
    private ItemStack stack;

    public FilterGhostSlotPacket() {
    }

    public FilterGhostSlotPacket(int ghostSlot, ItemStack stack) {
        this.ghostSlot = ghostSlot;
        this.stack = stack;
    }

    public static void encode(FilterGhostSlotPacket pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.ghostSlot);
        buf.m_130055_(pkt.stack);
    }

    public static FilterGhostSlotPacket decode(FriendlyByteBuf buf) {
        FilterGhostSlotPacket pkt = new FilterGhostSlotPacket(buf.readInt(), buf.m_130267_());
        BMLog.DEFAULT.info("decoded slot {} and stack {} with tag '{}'", pkt.ghostSlot, pkt.stack, pkt.stack.m_41783_());
        return pkt;
    }

    public static void handle(FilterGhostSlotPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
            if (sender == null) {
                return;
            }
            if (!(sender.f_36096_ instanceof ContainerFilter)) {
                return;
            }
            ItemStack filterStack = sender.m_21120_(InteractionHand.MAIN_HAND);
            CompoundTag tag = filterStack.m_41784_();
            InventoryFilter filterInv = new InventoryFilter(9);
            filterInv.deserializeNBT(tag.m_128469_("itemInventory"));
            filterInv.setStackInSlot(message.ghostSlot, message.stack);
            tag.m_128365_("itemInventory", (Tag)filterInv.serializeNBT());
            filterStack.m_41751_(tag);
        });
        context.get().setPacketHandled(true);
    }
}

