/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.data;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.data.recipe.BaseRecipeProvider;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.BloodOrb;
import wayoftime.bloodmagic.common.recipe.ARCRecipeProvider;
import wayoftime.bloodmagic.common.recipe.AlchemyArrayRecipeProvider;
import wayoftime.bloodmagic.common.recipe.AlchemyTableRecipeProvider;
import wayoftime.bloodmagic.common.recipe.BloodAltarRecipeProvider;
import wayoftime.bloodmagic.common.recipe.ISubRecipeProvider;
import wayoftime.bloodmagic.common.recipe.LivingDowngradeRecipeProvider;
import wayoftime.bloodmagic.common.recipe.MeteorRecipeProvider;
import wayoftime.bloodmagic.common.recipe.PotionRecipeProvider;
import wayoftime.bloodmagic.common.recipe.TartaricForgeRecipeProvider;
import wayoftime.bloodmagic.common.registries.BloodMagicRecipeSerializers;
import wayoftime.bloodmagic.common.tags.BloodMagicTags;
import wayoftime.bloodmagic.core.recipe.IngredientBloodOrb;

public class GeneratorRecipes
extends BaseRecipeProvider {
    public GeneratorRecipes(PackOutput output) {
        super(output, "bloodmagic");
    }

    @Override
    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        super.m_245200_(consumer);
        this.addVanillaRecipes(consumer);
        this.addVanillaSmithingRecipes(consumer);
        this.addBloodOrbRecipes(consumer);
        this.addDecorativeRecipes(consumer);
    }

    @Override
    protected List<ISubRecipeProvider> getSubRecipeProviders() {
        return Arrays.asList(new BloodAltarRecipeProvider(), new AlchemyArrayRecipeProvider(), new TartaricForgeRecipeProvider(), new ARCRecipeProvider(), new AlchemyTableRecipeProvider(), new LivingDowngradeRecipeProvider(), new PotionRecipeProvider(), new MeteorRecipeProvider());
    }

    private void addDecorativeRecipes(Consumer<FinishedRecipe> consumer) {
        this.addHellstone(consumer, (Block)BloodMagicBlocks.DUNGEON_STONE.get(), (Item)BloodMagicItems.RAW_CRYSTAL.get());
        this.addHellstone(consumer, (Block)BloodMagicBlocks.CORROSIVE_DUNGEON_STONE.get(), (Item)BloodMagicItems.CORROSIVE_CRYSTAL.get());
        this.addHellstone(consumer, (Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_STONE.get(), (Item)BloodMagicItems.DESTRUCTIVE_CRYSTAL.get());
        this.addHellstone(consumer, (Block)BloodMagicBlocks.STEADFAST_DUNGEON_STONE.get(), (Item)BloodMagicItems.STEADFAST_CRYSTAL.get());
        this.addHellstone(consumer, (Block)BloodMagicBlocks.VENGEFUL_DUNGEON_STONE.get(), (Item)BloodMagicItems.VENGEFUL_CRYSTAL.get());
        this.addHellstair(consumer, (Block)BloodMagicBlocks.DUNGEON_STONE_STAIRS.get(), (Block)BloodMagicBlocks.DUNGEON_STONE.get());
        this.addHellstair(consumer, (Block)BloodMagicBlocks.DUNGEON_POLISHED_STAIRS.get(), (Block)BloodMagicBlocks.DUNGEON_POLISHED_STONE.get());
        this.addHellstair(consumer, (Block)BloodMagicBlocks.DUNGEON_BRICK_STAIRS.get(), (Block)BloodMagicBlocks.DUNGEON_BRICK_1.get());
        this.addHellstair(consumer, (Block)BloodMagicBlocks.CORROSIVE_DUNGEON_STONE_STAIRS.get(), (Block)BloodMagicBlocks.CORROSIVE_DUNGEON_STONE.get());
        this.addHellstair(consumer, (Block)BloodMagicBlocks.CORROSIVE_DUNGEON_POLISHED_STAIRS.get(), (Block)BloodMagicBlocks.CORROSIVE_DUNGEON_POLISHED_STONE.get());
        this.addHellstair(consumer, (Block)BloodMagicBlocks.CORROSIVE_DUNGEON_BRICK_STAIRS.get(), (Block)BloodMagicBlocks.CORROSIVE_DUNGEON_BRICK_1.get());
        this.addHellstair(consumer, (Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_STONE_STAIRS.get(), (Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_STONE.get());
        this.addHellstair(consumer, (Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_POLISHED_STAIRS.get(), (Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_POLISHED_STONE.get());
        this.addHellstair(consumer, (Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_BRICK_STAIRS.get(), (Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_BRICK_1.get());
        this.addHellstair(consumer, (Block)BloodMagicBlocks.STEADFAST_DUNGEON_STONE_STAIRS.get(), (Block)BloodMagicBlocks.STEADFAST_DUNGEON_STONE.get());
        this.addHellstair(consumer, (Block)BloodMagicBlocks.STEADFAST_DUNGEON_POLISHED_STAIRS.get(), (Block)BloodMagicBlocks.STEADFAST_DUNGEON_POLISHED_STONE.get());
        this.addHellstair(consumer, (Block)BloodMagicBlocks.STEADFAST_DUNGEON_BRICK_STAIRS.get(), (Block)BloodMagicBlocks.STEADFAST_DUNGEON_BRICK_1.get());
        this.addHellstair(consumer, (Block)BloodMagicBlocks.VENGEFUL_DUNGEON_STONE_STAIRS.get(), (Block)BloodMagicBlocks.VENGEFUL_DUNGEON_STONE.get());
        this.addHellstair(consumer, (Block)BloodMagicBlocks.VENGEFUL_DUNGEON_POLISHED_STAIRS.get(), (Block)BloodMagicBlocks.VENGEFUL_DUNGEON_POLISHED_STONE.get());
        this.addHellstair(consumer, (Block)BloodMagicBlocks.VENGEFUL_DUNGEON_BRICK_STAIRS.get(), (Block)BloodMagicBlocks.VENGEFUL_DUNGEON_BRICK_1.get());
        this.addHellslab(consumer, (Block)BloodMagicBlocks.DUNGEON_STONE_SLAB.get(), (Block)BloodMagicBlocks.DUNGEON_STONE.get());
        this.addHellslab(consumer, (Block)BloodMagicBlocks.DUNGEON_POLISHED_SLAB.get(), (Block)BloodMagicBlocks.DUNGEON_POLISHED_STONE.get());
        this.addHellslab(consumer, (Block)BloodMagicBlocks.DUNGEON_TILE_SLAB.get(), (Block)BloodMagicBlocks.DUNGEON_TILE.get());
        this.addHellslab(consumer, (Block)BloodMagicBlocks.DUNGEON_BRICK_SLAB.get(), (Block)BloodMagicBlocks.DUNGEON_BRICK_1.get());
        this.addHellslab(consumer, (Block)BloodMagicBlocks.CORROSIVE_DUNGEON_STONE_SLAB.get(), (Block)BloodMagicBlocks.CORROSIVE_DUNGEON_STONE.get());
        this.addHellslab(consumer, (Block)BloodMagicBlocks.CORROSIVE_DUNGEON_POLISHED_SLAB.get(), (Block)BloodMagicBlocks.CORROSIVE_DUNGEON_POLISHED_STONE.get());
        this.addHellslab(consumer, (Block)BloodMagicBlocks.CORROSIVE_DUNGEON_TILE_SLAB.get(), (Block)BloodMagicBlocks.CORROSIVE_DUNGEON_TILE.get());
        this.addHellslab(consumer, (Block)BloodMagicBlocks.CORROSIVE_DUNGEON_BRICK_SLAB.get(), (Block)BloodMagicBlocks.CORROSIVE_DUNGEON_BRICK_1.get());
        this.addHellslab(consumer, (Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_STONE_SLAB.get(), (Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_STONE.get());
        this.addHellslab(consumer, (Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_POLISHED_SLAB.get(), (Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_POLISHED_STONE.get());
        this.addHellslab(consumer, (Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_TILE_SLAB.get(), (Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_TILE.get());
        this.addHellslab(consumer, (Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_BRICK_SLAB.get(), (Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_BRICK_1.get());
        this.addHellslab(consumer, (Block)BloodMagicBlocks.STEADFAST_DUNGEON_STONE_SLAB.get(), (Block)BloodMagicBlocks.STEADFAST_DUNGEON_STONE.get());
        this.addHellslab(consumer, (Block)BloodMagicBlocks.STEADFAST_DUNGEON_POLISHED_SLAB.get(), (Block)BloodMagicBlocks.STEADFAST_DUNGEON_POLISHED_STONE.get());
        this.addHellslab(consumer, (Block)BloodMagicBlocks.STEADFAST_DUNGEON_TILE_SLAB.get(), (Block)BloodMagicBlocks.STEADFAST_DUNGEON_TILE.get());
        this.addHellslab(consumer, (Block)BloodMagicBlocks.STEADFAST_DUNGEON_BRICK_SLAB.get(), (Block)BloodMagicBlocks.STEADFAST_DUNGEON_BRICK_1.get());
        this.addHellslab(consumer, (Block)BloodMagicBlocks.VENGEFUL_DUNGEON_STONE_SLAB.get(), (Block)BloodMagicBlocks.VENGEFUL_DUNGEON_STONE.get());
        this.addHellslab(consumer, (Block)BloodMagicBlocks.VENGEFUL_DUNGEON_POLISHED_SLAB.get(), (Block)BloodMagicBlocks.VENGEFUL_DUNGEON_POLISHED_STONE.get());
        this.addHellslab(consumer, (Block)BloodMagicBlocks.VENGEFUL_DUNGEON_TILE_SLAB.get(), (Block)BloodMagicBlocks.VENGEFUL_DUNGEON_TILE.get());
        this.addHellslab(consumer, (Block)BloodMagicBlocks.VENGEFUL_DUNGEON_BRICK_SLAB.get(), (Block)BloodMagicBlocks.VENGEFUL_DUNGEON_BRICK_1.get());
        GeneratorRecipes.m_246382_(consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BloodMagicBlocks.DUNGEON_STONE_WALL.get()), (ItemLike)((ItemLike)BloodMagicBlocks.DUNGEON_STONE.get()));
        GeneratorRecipes.m_246382_(consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BloodMagicBlocks.DUNGEON_POLISHED_WALL.get()), (ItemLike)((ItemLike)BloodMagicBlocks.DUNGEON_POLISHED_STONE.get()));
        GeneratorRecipes.m_246382_(consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BloodMagicBlocks.DUNGEON_TILE_WALL.get()), (ItemLike)((ItemLike)BloodMagicBlocks.DUNGEON_TILE.get()));
        GeneratorRecipes.m_246382_(consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BloodMagicBlocks.DUNGEON_BRICK_WALL.get()), (ItemLike)((ItemLike)BloodMagicBlocks.DUNGEON_BRICK_1.get()));
        GeneratorRecipes.m_246382_(consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_STONE_WALL.get()), (ItemLike)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_STONE.get()));
        GeneratorRecipes.m_246382_(consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_POLISHED_WALL.get()), (ItemLike)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_POLISHED_STONE.get()));
        GeneratorRecipes.m_246382_(consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_TILE_WALL.get()), (ItemLike)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_TILE.get()));
        GeneratorRecipes.m_246382_(consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_BRICK_WALL.get()), (ItemLike)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_BRICK_1.get()));
        GeneratorRecipes.m_246382_(consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_STONE_WALL.get()), (ItemLike)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_STONE.get()));
        GeneratorRecipes.m_246382_(consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_POLISHED_WALL.get()), (ItemLike)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_POLISHED_STONE.get()));
        GeneratorRecipes.m_246382_(consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_TILE_WALL.get()), (ItemLike)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_TILE.get()));
        GeneratorRecipes.m_246382_(consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_BRICK_WALL.get()), (ItemLike)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_BRICK_1.get()));
        GeneratorRecipes.m_246382_(consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_STONE_WALL.get()), (ItemLike)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_STONE.get()));
        GeneratorRecipes.m_246382_(consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_POLISHED_WALL.get()), (ItemLike)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_POLISHED_STONE.get()));
        GeneratorRecipes.m_246382_(consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_TILE_WALL.get()), (ItemLike)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_TILE.get()));
        GeneratorRecipes.m_246382_(consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_BRICK_WALL.get()), (ItemLike)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_BRICK_1.get()));
        GeneratorRecipes.m_246382_(consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_STONE_WALL.get()), (ItemLike)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_STONE.get()));
        GeneratorRecipes.m_246382_(consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_POLISHED_WALL.get()), (ItemLike)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_POLISHED_STONE.get()));
        GeneratorRecipes.m_246382_(consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_TILE_WALL.get()), (ItemLike)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_TILE.get()));
        GeneratorRecipes.m_246382_(consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_BRICK_WALL.get()), (ItemLike)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_BRICK_1.get()));
        Ingredient glowstone = Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_GLOWSTONE);
        this.eye(consumer, RecipeCategory.DECORATIONS, glowstone, (Block)BloodMagicBlocks.DUNGEON_STONE.get(), (Block)BloodMagicBlocks.DUNGEON_EYE.get());
        this.eye(consumer, RecipeCategory.DECORATIONS, glowstone, (Block)BloodMagicBlocks.CORROSIVE_DUNGEON_STONE.get(), (Block)BloodMagicBlocks.CORROSIVE_DUNGEON_EYE.get());
        this.eye(consumer, RecipeCategory.DECORATIONS, glowstone, (Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_STONE.get(), (Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_EYE.get());
        this.eye(consumer, RecipeCategory.DECORATIONS, glowstone, (Block)BloodMagicBlocks.STEADFAST_DUNGEON_STONE.get(), (Block)BloodMagicBlocks.STEADFAST_DUNGEON_EYE.get());
        this.eye(consumer, RecipeCategory.DECORATIONS, glowstone, (Block)BloodMagicBlocks.VENGEFUL_DUNGEON_STONE.get(), (Block)BloodMagicBlocks.VENGEFUL_DUNGEON_EYE.get());
        Ingredient redstone = Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE);
        this.eye(consumer, RecipeCategory.REDSTONE, redstone, (Block)BloodMagicBlocks.DUNGEON_STONE.get(), (Block)BloodMagicBlocks.DUNGEON_EMITTER.get());
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)BloodMagicBlocks.DUNGEON_ALTERNATOR.get())).m_126209_((ItemLike)BloodMagicBlocks.DUNGEON_STONE.get()).m_126186_(redstone, 3).m_126209_((ItemLike)Items.f_42351_).m_126132_(GeneratorRecipes.m_176602_((ItemLike)((ItemLike)BloodMagicBlocks.DUNGEON_STONE.get())), (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicBlocks.DUNGEON_STONE.get()))).m_126140_(consumer, BloodMagic.rl(GeneratorRecipes.m_176632_((ItemLike)((ItemLike)BloodMagicBlocks.DUNGEON_ALTERNATOR.get()))));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)BloodMagicBlocks.DUNGEON_SPIKE_TRAP.get())).m_126209_((ItemLike)BloodMagicBlocks.DUNGEON_STONE.get()).m_126209_((ItemLike)Blocks.f_50039_).m_126209_((ItemLike)Items.f_42383_).m_126132_(GeneratorRecipes.m_176602_((ItemLike)((ItemLike)BloodMagicBlocks.DUNGEON_STONE.get())), (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicBlocks.DUNGEON_STONE.get()))).m_126140_(consumer, BloodMagic.rl(GeneratorRecipes.m_176632_((ItemLike)((ItemLike)BloodMagicBlocks.DUNGEON_SPIKE_TRAP.get()))));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BloodMagicBlocks.ETHEREAL_MIMIC.get()), (int)8).m_126130_("SSS").m_126130_("SES").m_126130_("SSS").m_126127_(Character.valueOf('E'), (ItemLike)BloodMagicItems.ETHEREAL_SLATE.get()).m_126127_(Character.valueOf('S'), (ItemLike)BloodMagicBlocks.DUNGEON_STONE.get()).m_126132_(GeneratorRecipes.m_176602_((ItemLike)((ItemLike)BloodMagicItems.ETHEREAL_SLATE.get())), (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.ETHEREAL_SLATE.get()))).m_126140_(consumer, BloodMagic.rl(GeneratorRecipes.m_176632_((ItemLike)((ItemLike)BloodMagicBlocks.ETHEREAL_MIMIC.get()))));
        this.decoHelper(consumer, BloodMagicTags.DUNGEON_RAW, Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_STONE_SLAB.get()), (Object)2), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_BRICK_SLAB.get()), (Object)2), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_POLISHED_SLAB.get()), (Object)2), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_TILE_SLAB.get()), (Object)2), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_STONE_STAIRS.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_BRICK_STAIRS.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_POLISHED_STAIRS.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_STONE_WALL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_BRICK_WALL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_POLISHED_WALL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_TILE_WALL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_BRICK_GATE.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_POLISHED_GATE.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_PILLAR_CAP.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_PILLAR_CENTER.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_PILLAR_SPECIAL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_STONE.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_BRICK_1.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_BRICK_2.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_BRICK_3.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_TILE.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_TILE_SPECIAL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_SMALL_BRICK.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DUNGEON_POLISHED_STONE.get()), (Object)1));
        this.decoHelper(consumer, BloodMagicTags.DUNGEON_CORROSIVE, Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_STONE_SLAB.get()), (Object)2), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_BRICK_SLAB.get()), (Object)2), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_POLISHED_SLAB.get()), (Object)2), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_TILE_SLAB.get()), (Object)2), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_STONE_STAIRS.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_BRICK_STAIRS.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_POLISHED_STAIRS.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_STONE_WALL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_BRICK_WALL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_POLISHED_WALL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_TILE_WALL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_BRICK_GATE.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_POLISHED_GATE.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_PILLAR_CAP.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_PILLAR_CENTER.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_PILLAR_SPECIAL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_STONE.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_BRICK_1.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_BRICK_2.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_BRICK_3.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_TILE.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_TILE_SPECIAL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_SMALL_BRICK.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_DUNGEON_POLISHED_STONE.get()), (Object)1));
        this.decoHelper(consumer, BloodMagicTags.DUNGEON_DESTRUCTIVE, Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_STONE_SLAB.get()), (Object)2), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_BRICK_SLAB.get()), (Object)2), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_POLISHED_SLAB.get()), (Object)2), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_TILE_SLAB.get()), (Object)2), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_STONE_STAIRS.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_BRICK_STAIRS.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_POLISHED_STAIRS.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_STONE_WALL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_BRICK_WALL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_POLISHED_WALL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_TILE_WALL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_BRICK_GATE.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_POLISHED_GATE.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_PILLAR_CAP.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_PILLAR_CENTER.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_PILLAR_SPECIAL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_STONE.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_BRICK_1.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_BRICK_2.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_BRICK_3.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_TILE.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_TILE_SPECIAL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_SMALL_BRICK.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_POLISHED_STONE.get()), (Object)1));
        this.decoHelper(consumer, BloodMagicTags.DUNGEON_STEADFAST, Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_STONE_SLAB.get()), (Object)2), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_BRICK_SLAB.get()), (Object)2), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_POLISHED_SLAB.get()), (Object)2), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_TILE_SLAB.get()), (Object)2), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_STONE_STAIRS.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_BRICK_STAIRS.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_POLISHED_STAIRS.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_STONE_WALL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_BRICK_WALL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_POLISHED_WALL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_TILE_WALL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_BRICK_GATE.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_POLISHED_GATE.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_PILLAR_CAP.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_PILLAR_CENTER.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_PILLAR_SPECIAL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_STONE.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_BRICK_1.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_BRICK_2.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_BRICK_3.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_TILE.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_TILE_SPECIAL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_SMALL_BRICK.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_DUNGEON_POLISHED_STONE.get()), (Object)1));
        this.decoHelper(consumer, BloodMagicTags.DUNGEON_VENGEFUL, Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_STONE_SLAB.get()), (Object)2), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_BRICK_SLAB.get()), (Object)2), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_POLISHED_SLAB.get()), (Object)2), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_TILE_SLAB.get()), (Object)2), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_STONE_STAIRS.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_BRICK_STAIRS.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_POLISHED_STAIRS.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_STONE_WALL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_BRICK_WALL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_POLISHED_WALL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_TILE_WALL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_BRICK_GATE.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_POLISHED_GATE.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_PILLAR_CAP.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_PILLAR_CENTER.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_PILLAR_SPECIAL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_STONE.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_BRICK_1.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_BRICK_2.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_BRICK_3.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_TILE.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_TILE_SPECIAL.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_SMALL_BRICK.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_DUNGEON_POLISHED_STONE.get()), (Object)1));
        this.decoHelper(consumer, BloodMagicTags.BLOCK_HELLFORGED, Pair.of((Object)((ItemLike)BloodMagicBlocks.HELLFORGED_BLOCK.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.CORROSIVE_HELLFORGED_BLOCK.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.DESTRUCTIVE_HELLFORGED_BLOCK.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.STEADFAST_HELLFORGED_BLOCK.get()), (Object)1), Pair.of((Object)((ItemLike)BloodMagicBlocks.VENGEFUL_HELLFORGED_BLOCK.get()), (Object)1));
    }

    private void eye(Consumer<FinishedRecipe> consumer, RecipeCategory category, Ingredient dust, Block stone, Block eye) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)eye).m_126130_(" D ").m_126130_("DSD").m_126130_(" D ").m_126124_(Character.valueOf('D'), dust).m_126127_(Character.valueOf('S'), (ItemLike)stone).m_126132_(GeneratorRecipes.m_176602_((ItemLike)stone), (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)stone)).m_126140_(consumer, BloodMagic.rl(GeneratorRecipes.m_176632_((ItemLike)eye)));
    }

    private void addHellstair(Consumer<FinishedRecipe> consumer, Block stair, Block material) {
        GeneratorRecipes.m_176710_((ItemLike)stair, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{material})).m_126132_(GeneratorRecipes.m_176602_((ItemLike)material), (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)material)).m_176498_(consumer);
    }

    private void addHellslab(Consumer<FinishedRecipe> consumer, Block slab, Block full) {
        GeneratorRecipes.m_246658_(consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)slab, (ItemLike)full);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)full).m_126130_("s").m_126130_("s").m_126127_(Character.valueOf('s'), (ItemLike)slab).m_126132_(GeneratorRecipes.m_176602_((ItemLike)slab), (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)slab)).m_126140_(consumer, BloodMagic.rl(GeneratorRecipes.m_176632_((ItemLike)full) + "_slab_revert"));
    }

    private void addHellstone(Consumer<FinishedRecipe> consumer, Block stone, Item crystal) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)stone, (int)64).m_126130_("sss").m_126130_("scs").m_126130_("sss").m_126127_(Character.valueOf('s'), (ItemLike)Blocks.f_50069_).m_126127_(Character.valueOf('c'), (ItemLike)crystal).m_126132_(GeneratorRecipes.m_176602_((ItemLike)crystal), (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)crystal)).m_126140_(consumer, BloodMagic.rl(GeneratorRecipes.m_176632_((ItemLike)stone)));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)stone, (int)4).m_126130_("hs").m_126130_("ss").m_126127_(Character.valueOf('h'), (ItemLike)stone).m_126127_(Character.valueOf('s'), (ItemLike)Blocks.f_50069_).m_126132_(GeneratorRecipes.m_176602_((ItemLike)stone), (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)stone)).m_126140_(consumer, BloodMagic.rl(GeneratorRecipes.m_176632_((ItemLike)stone) + "_spread"));
    }

    private void decoHelper(Consumer<FinishedRecipe> consumer, TagKey<Item> base, Pair<ItemLike, Integer> ... results) {
        for (Pair<ItemLike, Integer> result : results) {
            SingleItemRecipeBuilder.m_246944_((Ingredient)Ingredient.m_204132_(base), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)result.getFirst()), (int)((Integer)result.getSecond())).m_126132_("has_" + base.f_203868_().m_135815_(), (CriterionTriggerInstance)GeneratorRecipes.m_206406_(base)).m_126140_(consumer, new ResourceLocation("bloodmagic", GeneratorRecipes.m_176632_((ItemLike)((ItemLike)result.getFirst())) + "_from_" + base.f_203868_().m_135815_() + "_stonecutting"));
        }
    }

    private void addVanillaRecipes(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.CORRUPTED_DUST.get())).m_206416_(Character.valueOf('s'), BloodMagicTags.TINYDUST_CORRUPTED).m_126130_("sss").m_126130_("sss").m_126130_("sss").m_126132_("has_tiny", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.CORRUPTED_DUST_TINY.get()))).m_126140_(consumer, BloodMagic.rl("corrupted_dust"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_BLOCK.get())).m_206416_(Character.valueOf('s'), BloodMagicTags.INGOT_HELLFORGED).m_126130_("sss").m_126130_("sss").m_126130_("sss").m_126132_("has_hellforged", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_INGOT.get()))).m_126140_(consumer, BloodMagic.rl("hellforged_block"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.SACRIFICIAL_DAGGER.get())).m_206416_(Character.valueOf('g'), Tags.Items.GLASS).m_206416_(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_126130_("ggg").m_126130_(" Gg").m_126130_("i g").m_126132_("has_glass", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)Items.f_41904_)).m_126140_(consumer, BloodMagic.rl("sacrificial_dagger"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.BASE_RITUAL_DIVINER.get())).m_126127_(Character.valueOf('a'), (ItemLike)BloodMagicItems.AIR_INSCRIPTION_TOOL.get()).m_206416_(Character.valueOf('s'), Tags.Items.RODS_WOODEN).m_206416_(Character.valueOf('d'), Tags.Items.GEMS_DIAMOND).m_126127_(Character.valueOf('e'), (ItemLike)BloodMagicItems.EARTH_INSCRIPTION_TOOL.get()).m_126127_(Character.valueOf('f'), (ItemLike)BloodMagicItems.FIRE_INSCRIPTION_TOOL.get()).m_126127_(Character.valueOf('w'), (ItemLike)BloodMagicItems.WATER_INSCRIPTION_TOOL.get()).m_126130_("dfd").m_126130_("ase").m_126130_("dwd").m_126132_("has_scribe", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.AIR_INSCRIPTION_TOOL.get()))).m_126140_(consumer, BloodMagic.rl("ritual_diviner_0"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.DUSK_RITUAL_DIVINER.get())).m_126127_(Character.valueOf('S'), (ItemLike)BloodMagicItems.DEMONIC_SLATE.get()).m_126127_(Character.valueOf('t'), (ItemLike)BloodMagicItems.DUSK_INSCRIPTION_TOOL.get()).m_126127_(Character.valueOf('d'), (ItemLike)BloodMagicItems.BASE_RITUAL_DIVINER.get()).m_126130_(" S ").m_126130_("tdt").m_126130_(" S ").m_126132_("has_demon_slate", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.DEMONIC_SLATE.get()))).m_126140_(consumer, BloodMagic.rl("ritual_diviner_1"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.BLOODSTONE_BRICK.get()), (int)4).m_126127_(Character.valueOf('s'), (ItemLike)BloodMagicBlocks.BLOODSTONE.get()).m_126130_("ss").m_126130_("ss").m_126132_("has_weak_shard", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.WEAK_BLOOD_SHARD.get()))).m_126140_(consumer, BloodMagic.rl("bloodstonebrick"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.BLOODSTONE.get()), (int)8).m_206419_(Tags.Items.STONE).m_126209_((ItemLike)BloodMagicItems.WEAK_BLOOD_SHARD.get()).m_126132_("has_weak_shard", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.WEAK_BLOOD_SHARD.get()))).m_126140_(consumer, BloodMagic.rl("largebloodstonebrick"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.WOOD_TILE_PATH.get()), (int)4).m_126209_((ItemLike)BloodMagicBlocks.WOOD_PATH.get()).m_126209_((ItemLike)BloodMagicBlocks.WOOD_PATH.get()).m_126209_((ItemLike)BloodMagicBlocks.WOOD_PATH.get()).m_126209_((ItemLike)BloodMagicBlocks.WOOD_PATH.get()).m_126132_("has_apprentice_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.APPRENTICE_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("path/path_woodtile"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.STONE_TILE_PATH.get()), (int)4).m_126209_((ItemLike)BloodMagicBlocks.STONE_PATH.get()).m_126209_((ItemLike)BloodMagicBlocks.STONE_PATH.get()).m_126209_((ItemLike)BloodMagicBlocks.STONE_PATH.get()).m_126209_((ItemLike)BloodMagicBlocks.STONE_PATH.get()).m_126132_("has_magician_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.MAGICIAN_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("path/path_stonetile"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.WORN_STONE_TILE_PATH.get()), (int)4).m_126209_((ItemLike)BloodMagicBlocks.WORN_STONE_PATH.get()).m_126209_((ItemLike)BloodMagicBlocks.WORN_STONE_PATH.get()).m_126209_((ItemLike)BloodMagicBlocks.WORN_STONE_PATH.get()).m_126209_((ItemLike)BloodMagicBlocks.WORN_STONE_PATH.get()).m_126132_("has_master_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.MASTER_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("path/path_wornstonetile"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.OBSIDIAN_TILE_PATH.get()), (int)4).m_126209_((ItemLike)BloodMagicBlocks.OBSIDIAN_PATH.get()).m_126209_((ItemLike)BloodMagicBlocks.OBSIDIAN_PATH.get()).m_126209_((ItemLike)BloodMagicBlocks.OBSIDIAN_PATH.get()).m_126209_((ItemLike)BloodMagicBlocks.OBSIDIAN_PATH.get()).m_126132_("has_archmage_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.ARCHMAGE_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("path/path_obsidiantile"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.ALCHEMY_FLASK.get())).m_126209_((ItemLike)BloodMagicItems.ALCHEMY_FLASK.get()).m_126184_(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42447_})).m_126132_("has_flask", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.ALCHEMY_FLASK.get()))).m_126140_(consumer, BloodMagic.rl("alchemy_flask"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.ALCHEMY_FLASK_THROWABLE.get())).m_126209_((ItemLike)BloodMagicItems.ALCHEMY_FLASK_THROWABLE.get()).m_126184_(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42447_})).m_126132_("has_flask", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.ALCHEMY_FLASK.get()))).m_126140_(consumer, BloodMagic.rl("alchemy_flask_throwable"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.ALCHEMY_FLASK_LINGERING.get())).m_126209_((ItemLike)BloodMagicItems.ALCHEMY_FLASK_LINGERING.get()).m_126184_(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42447_})).m_126132_("has_flask", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.ALCHEMY_FLASK.get()))).m_126140_(consumer, BloodMagic.rl("alchemy_flask_lingering"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_INGOT.get()), (int)9).m_206419_(BloodMagicTags.BLOCK_HELLFORGED).m_126132_("has_hellforged_block", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicBlocks.HELLFORGED_BLOCK.get()))).m_126140_(consumer, BloodMagic.rl("hellforged_block_to_ingot"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.TELEPOSER.get())).m_126130_("ggg").m_126130_("ete").m_126130_("ggg").m_126124_(Character.valueOf('g'), Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_GOLD)).m_126124_(Character.valueOf('e'), Ingredient.m_204132_((TagKey)Tags.Items.ENDER_PEARLS)).m_126124_(Character.valueOf('t'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicItems.TELEPOSER_FOCUS.get()})).m_126132_("has_gold", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.TELEPOSER_FOCUS.get()))).m_126140_(consumer, BloodMagic.rl("teleposer"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.REINFORCED_TELEPOSER_FOCUS.get())).m_126209_((ItemLike)BloodMagicItems.ENHANCED_TELEPOSER_FOCUS.get()).m_126209_((ItemLike)BloodMagicItems.WEAK_BLOOD_SHARD.get()).m_126132_("has_shard", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.WEAK_BLOOD_SHARD.get()))).m_126140_(consumer, BloodMagic.rl("enhanced_teleposer_focus"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.BLOOD_ALTAR.get())).m_206416_(Character.valueOf('a'), Tags.Items.STONE).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_41962_).m_206416_(Character.valueOf('c'), Tags.Items.INGOTS_GOLD).m_126130_("a a").m_126130_("aba").m_126130_("ccc").m_126132_("has_gold", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)Items.f_42417_)).m_126140_(consumer, BloodMagic.rl("blood_altar"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.ALCHEMY_TABLE.get())).m_206416_(Character.valueOf('b'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('s'), Tags.Items.STONE).m_206416_(Character.valueOf('w'), ItemTags.f_13168_).m_206416_(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).m_126127_(Character.valueOf('o'), (ItemLike)BloodMagicItems.SLATE.get()).m_126130_("sss").m_126130_("wbw").m_126130_("gog").m_126132_("has_blank_slate", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.SLATE.get()))).m_126140_(consumer, BloodMagic.rl("alchemy_table"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.SOUL_FORGE.get())).m_206416_(Character.valueOf('s'), Tags.Items.STONE).m_126127_(Character.valueOf('S'), (ItemLike)BloodMagicItems.SLATE.get()).m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('o'), Tags.Items.STORAGE_BLOCKS_IRON).m_126130_("i i").m_126130_("sSs").m_126130_("sos").m_126132_("has_blank_slate", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.SLATE.get()))).m_126140_(consumer, BloodMagic.rl("soul_forge"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.SYNTHETIC_POINT.get()), (int)2).m_126130_("ifi").m_126130_("frf").m_126130_("ifi").m_126124_(Character.valueOf('f'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42583_, Items.f_42485_, Items.f_42658_, Items.f_42579_, Items.f_42528_, Items.f_42526_, Items.f_42529_, Items.f_42527_, Items.f_42581_, Items.f_42591_, Items.f_42697_, (ItemLike)BloodMagicItems.STRONG_TAU_ITEM.get()})).m_206416_(Character.valueOf('i'), Tags.Items.NUGGETS_IRON).m_206416_(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).m_126132_("has_nugget", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)Items.f_42749_)).m_126140_(consumer, BloodMagic.rl("synthetic_point"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.RAW_HELLFORGED_BLOCK.get())).m_126127_(Character.valueOf('s'), (ItemLike)BloodMagicItems.DEMONITE_RAW.get()).m_126130_("sss").m_126130_("sss").m_126130_("sss").m_126132_("has_raw_hellforged", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.DEMONITE_RAW.get()))).m_126140_(consumer, BloodMagic.rl("raw_hellforged_block"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.DEMONITE_RAW.get()), (int)9).m_126209_((ItemLike)BloodMagicBlocks.RAW_HELLFORGED_BLOCK.get()).m_126132_("has_raw_hellforged_block", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicBlocks.RAW_HELLFORGED_BLOCK.get()))).m_126140_(consumer, BloodMagic.rl("raw_hellforged_block_to_item"));
        this.clearFilter((ItemLike)BloodMagicItems.ITEM_ROUTER_FILTER.get(), BloodMagic.rl("clear_router_filter"), consumer);
        this.clearFilter((ItemLike)BloodMagicItems.ITEM_TAG_FILTER.get(), BloodMagic.rl("clear_tag_filter"), consumer);
        this.clearFilter((ItemLike)BloodMagicItems.ITEM_ENCHANT_FILTER.get(), BloodMagic.rl("clear_enchant_filter"), consumer);
        this.clearFilter((ItemLike)BloodMagicItems.ITEM_MOD_FILTER.get(), BloodMagic.rl("clear_mod_filter"), consumer);
        this.clearFilter((ItemLike)BloodMagicItems.ITEM_COMPOSITE_FILTER.get(), BloodMagic.rl("clear_composite_filter"), consumer);
        SpecialRecipeBuilder.m_245676_(BloodMagicRecipeSerializers.FILTER_COPY.getRecipeSerializer()).m_126359_(consumer, "bloodmagic:filter_copy");
    }

    private void clearFilter(ItemLike filter, ResourceLocation path, Consumer<FinishedRecipe> output) {
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)filter).m_126209_(filter).m_126132_("has_filter", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)filter)).m_126140_(output, path);
    }

    private void addVanillaSmithingRecipes(Consumer<FinishedRecipe> consumer) {
        String basePath = "smelting/";
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_204132_(BloodMagicTags.DUST_IRON), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42416_, (float)0.0f, (int)200).m_126132_("has_iron_sand", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.IRON_SAND.get()))).m_126140_(consumer, BloodMagic.rl(basePath + "ingot_iron"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_204132_(BloodMagicTags.DUST_GOLD), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42417_, (float)0.0f, (int)200).m_126132_("has_gold_sand", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.GOLD_SAND.get()))).m_126140_(consumer, BloodMagic.rl(basePath + "ingot_gold"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_204132_(BloodMagicTags.DUST_COPPER), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_151052_, (float)0.0f, (int)200).m_126132_("has_copper_sand", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.COPPER_SAND.get()))).m_126140_(consumer, BloodMagic.rl(basePath + "ingot_copper"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_204132_(BloodMagicTags.DUST_NETHERITE_SCRAP), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42419_, (float)0.0f, (int)200).m_126132_("has_netherite_dust", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.NETHERITE_SCRAP_SAND.get()))).m_126140_(consumer, BloodMagic.rl(basePath + "ingot_netherite_scrap"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_204132_(BloodMagicTags.DUST_HELLFORGED), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_INGOT.get()), (float)0.0f, (int)200).m_126132_("has_hellforged_dust", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_SAND.get()))).m_126140_(consumer, BloodMagic.rl(basePath + "ingot_hellforged"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicItems.DEMONITE_RAW.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_INGOT.get()), (float)0.0f, (int)200).m_126132_("has_raw_demonite", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.DEMONITE_RAW.get()))).m_126140_(consumer, BloodMagic.rl(basePath + "ingot_from_raw_hellforged"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicBlocks.DUNGEON_ORE.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_INGOT.get()), (float)0.0f, (int)200).m_126132_("has_demonite", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicBlocks.DUNGEON_ORE.get()))).m_126140_(consumer, BloodMagic.rl(basePath + "ingot_from_demonite"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicItems.PLANT_OIL.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.SALTPETER.get()), (float)0.0f, (int)200).m_126132_("has_plant_oil", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.PLANT_OIL.get()))).m_126140_(consumer, BloodMagic.rl(basePath + "saltpeter"));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_204132_(BloodMagicTags.DUST_IRON), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42416_, (float)0.0f, (int)100).m_126132_("has_iron_sand", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.IRON_SAND.get()))).m_126140_(consumer, BloodMagic.rl(basePath + "blasting_ingot_iron"));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_204132_(BloodMagicTags.DUST_GOLD), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42417_, (float)0.0f, (int)100).m_126132_("has_gold_sand", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.GOLD_SAND.get()))).m_126140_(consumer, BloodMagic.rl(basePath + "blasting_ingot_gold"));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_204132_(BloodMagicTags.DUST_COPPER), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_151052_, (float)0.0f, (int)100).m_126132_("has_copper_sand", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.COPPER_SAND.get()))).m_126140_(consumer, BloodMagic.rl(basePath + "blasting_ingot_copper"));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_204132_(BloodMagicTags.DUST_NETHERITE_SCRAP), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42419_, (float)0.0f, (int)100).m_126132_("has_netherite_dust", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.NETHERITE_SCRAP_SAND.get()))).m_126140_(consumer, BloodMagic.rl(basePath + "blasting_ingot_netherite_scrap"));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_204132_(BloodMagicTags.DUST_HELLFORGED), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_INGOT.get()), (float)0.0f, (int)100).m_126132_("has_hellforged_dust", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_SAND.get()))).m_126140_(consumer, BloodMagic.rl(basePath + "blasting_ingot_hellforged"));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicItems.DEMONITE_RAW.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_INGOT.get()), (float)0.0f, (int)100).m_126132_("has_raw_demonite", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.DEMONITE_RAW.get()))).m_126140_(consumer, BloodMagic.rl(basePath + "blasting_ingot_from_raw_hellforged"));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicBlocks.DUNGEON_ORE.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_INGOT.get()), (float)0.0f, (int)100).m_126132_("has_demonite", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicBlocks.DUNGEON_ORE.get()))).m_126140_(consumer, BloodMagic.rl(basePath + "blasting_ingot_from_demonite"));
    }

    private void addBloodOrbRecipes(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.INCENSE_ALTAR.get())).m_206416_(Character.valueOf('s'), Tags.Items.STONE).m_206416_(Character.valueOf('c'), Tags.Items.COBBLESTONE).m_126127_(Character.valueOf('h'), (ItemLike)Items.f_42414_).m_126124_(Character.valueOf('o'), (Ingredient)IngredientBloodOrb.fromOrb((BloodOrb)BloodMagicItems.ORB_WEAK.get())).m_126130_("s s").m_126130_("shs").m_126130_("coc").m_126132_("has_weak_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.WEAK_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("incense_altar"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.BLANK_RUNE.get())).m_206416_(Character.valueOf('a'), Tags.Items.STONE).m_126124_(Character.valueOf('s'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicItems.SLATE.get()})).m_126124_(Character.valueOf('o'), (Ingredient)IngredientBloodOrb.fromOrb((BloodOrb)BloodMagicItems.ORB_WEAK.get())).m_126130_("asa").m_126130_("aoa").m_126130_("aaa").m_126132_("has_weak_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.WEAK_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("blood_rune_blank"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.SPEED_RUNE.get())).m_206416_(Character.valueOf('a'), Tags.Items.STONE).m_126124_(Character.valueOf('b'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicItems.SLATE.get()})).m_126124_(Character.valueOf('c'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42501_})).m_126127_(Character.valueOf('d'), (ItemLike)BloodMagicBlocks.BLANK_RUNE.get()).m_126130_("aba").m_126130_("cdc").m_126130_("aba").m_126132_("has_blank_rune", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.BLANK_RUNE_ITEM.get()))).m_126140_(consumer, BloodMagic.rl("blood_rune_speed"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.SACRIFICE_RUNE.get())).m_206416_(Character.valueOf('a'), Tags.Items.STONE).m_126127_(Character.valueOf('b'), (ItemLike)BloodMagicItems.REINFORCED_SLATE.get()).m_206416_(Character.valueOf('c'), Tags.Items.INGOTS_GOLD).m_126127_(Character.valueOf('d'), (ItemLike)BloodMagicBlocks.BLANK_RUNE.get()).m_126124_(Character.valueOf('e'), (Ingredient)IngredientBloodOrb.fromOrb((BloodOrb)BloodMagicItems.ORB_APPRENTICE.get())).m_126130_("aba").m_126130_("cdc").m_126130_("aea").m_126132_("has_apprentice_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.APPRENTICE_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("blood_rune_sacrifice"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.SELF_SACRIFICE_RUNE.get())).m_206416_(Character.valueOf('a'), Tags.Items.STONE).m_126124_(Character.valueOf('b'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicItems.REINFORCED_SLATE.get()})).m_126124_(Character.valueOf('c'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42525_})).m_126124_(Character.valueOf('d'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicItems.BLANK_RUNE_ITEM.get()})).m_126124_(Character.valueOf('e'), (Ingredient)IngredientBloodOrb.fromOrb((BloodOrb)BloodMagicItems.ORB_APPRENTICE.get())).m_126130_("aba").m_126130_("cdc").m_126130_("aea").m_126132_("has_apprentice_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.APPRENTICE_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("blood_rune_self_sacrifice"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.CAPACITY_RUNE.get())).m_206416_(Character.valueOf('a'), Tags.Items.STONE).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42446_).m_126127_(Character.valueOf('c'), (ItemLike)BloodMagicBlocks.BLANK_RUNE.get()).m_126127_(Character.valueOf('d'), (ItemLike)BloodMagicItems.IMBUED_SLATE.get()).m_126130_("aba").m_126130_("bcb").m_126130_("ada").m_126132_("has_imbued_slate", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.IMBUED_SLATE.get()))).m_126140_(consumer, BloodMagic.rl("blood_rune_capacity"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.ORB_RUNE.get())).m_206416_(Character.valueOf('a'), Tags.Items.STONE).m_126124_(Character.valueOf('b'), (Ingredient)IngredientBloodOrb.fromOrb((BloodOrb)BloodMagicItems.ORB_WEAK.get())).m_126127_(Character.valueOf('c'), (ItemLike)BloodMagicBlocks.BLANK_RUNE.get()).m_126124_(Character.valueOf('d'), (Ingredient)IngredientBloodOrb.fromOrb((BloodOrb)BloodMagicItems.ORB_MASTER.get())).m_126130_("aba").m_126130_("cdc").m_126130_("aba").m_126132_("has_master_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.MASTER_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("blood_rune_orb"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.CHARGING_RUNE.get())).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_126127_(Character.valueOf('r'), (ItemLike)BloodMagicBlocks.BLANK_RUNE.get()).m_126127_(Character.valueOf('s'), (ItemLike)BloodMagicItems.DEMONIC_SLATE.get()).m_126124_(Character.valueOf('e'), (Ingredient)IngredientBloodOrb.fromOrb((BloodOrb)BloodMagicItems.ORB_MASTER.get())).m_206416_(Character.valueOf('G'), Tags.Items.DUSTS_GLOWSTONE).m_126130_("RsR").m_126130_("GrG").m_126130_("ReR").m_126132_("has_master_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.MASTER_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("blood_rune_charging"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.DISPLACEMENT_RUNE.get())).m_206416_(Character.valueOf('a'), Tags.Items.STONE).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42447_).m_126127_(Character.valueOf('c'), (ItemLike)BloodMagicBlocks.BLANK_RUNE.get()).m_126127_(Character.valueOf('d'), (ItemLike)BloodMagicItems.IMBUED_SLATE.get()).m_126130_("aba").m_126130_("bcb").m_126130_("ada").m_126132_("has_imbued_slate", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.IMBUED_SLATE.get()))).m_126140_(consumer, BloodMagic.rl("blood_rune_displacement"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.AUGMENTED_CAPACITY_RUNE.get())).m_206416_(Character.valueOf('a'), Tags.Items.OBSIDIAN).m_126127_(Character.valueOf('b'), (ItemLike)BloodMagicItems.DEMONIC_SLATE.get()).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42446_).m_126127_(Character.valueOf('d'), (ItemLike)BloodMagicBlocks.CAPACITY_RUNE.get()).m_126124_(Character.valueOf('e'), (Ingredient)IngredientBloodOrb.fromOrb((BloodOrb)BloodMagicItems.ORB_MASTER.get())).m_126130_("aba").m_126130_("cdc").m_126130_("aea").m_126132_("has_master_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.MASTER_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("blood_rune_aug_capacity"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.ACCELERATION_RUNE.get())).m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42446_).m_126127_(Character.valueOf('b'), (ItemLike)BloodMagicItems.DEMONIC_SLATE.get()).m_206416_(Character.valueOf('c'), Tags.Items.INGOTS_GOLD).m_126127_(Character.valueOf('d'), (ItemLike)BloodMagicBlocks.SPEED_RUNE.get()).m_126124_(Character.valueOf('e'), (Ingredient)IngredientBloodOrb.fromOrb((BloodOrb)BloodMagicItems.ORB_MASTER.get())).m_126130_("aba").m_126130_("cdc").m_126130_("aea").m_126132_("has_master_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.MASTER_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("blood_rune_acceleration"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.BLANK_RITUAL_STONE.get()), (int)4).m_206416_(Character.valueOf('a'), Tags.Items.OBSIDIAN).m_126127_(Character.valueOf('b'), (ItemLike)BloodMagicItems.REINFORCED_SLATE.get()).m_126124_(Character.valueOf('c'), (Ingredient)IngredientBloodOrb.fromOrb((BloodOrb)BloodMagicItems.ORB_APPRENTICE.get())).m_126130_("aba").m_126130_("bcb").m_126130_("aba").m_126132_("has_apprentice_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.APPRENTICE_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("ritual_stone_blank"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.MASTER_RITUAL_STONE.get())).m_206416_(Character.valueOf('a'), Tags.Items.OBSIDIAN).m_126127_(Character.valueOf('b'), (ItemLike)BloodMagicBlocks.BLANK_RITUAL_STONE.get()).m_126124_(Character.valueOf('c'), (Ingredient)IngredientBloodOrb.fromOrb((BloodOrb)BloodMagicItems.ORB_MAGICIAN.get())).m_126130_("aba").m_126130_("bcb").m_126130_("aba").m_126132_("has_magician_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.MAGICIAN_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("ritual_stone_master"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.ALCHEMICAL_REACTION_CHAMBER.get())).m_206416_(Character.valueOf('s'), Tags.Items.STONE).m_126127_(Character.valueOf('f'), (ItemLike)Blocks.f_50094_).m_126124_(Character.valueOf('o'), (Ingredient)IngredientBloodOrb.fromOrb((BloodOrb)BloodMagicItems.ORB_MAGICIAN.get())).m_206416_(Character.valueOf('I'), Tags.Items.STORAGE_BLOCKS_IRON).m_126127_(Character.valueOf('S'), (ItemLike)BloodMagicItems.IMBUED_SLATE.get()).m_126130_("sss").m_126130_("SoS").m_126130_("IfI").m_126132_("has_magician_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.MAGICIAN_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("arc"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.PRIMITIVE_FURNACE_CELL.get())).m_206416_(Character.valueOf('c'), Tags.Items.COBBLESTONE).m_206416_(Character.valueOf('f'), Tags.Items.STORAGE_BLOCKS_COAL).m_126124_(Character.valueOf('s'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicItems.SLATE.get()})).m_126124_(Character.valueOf('o'), (Ingredient)IngredientBloodOrb.fromOrb((BloodOrb)BloodMagicItems.ORB_MAGICIAN.get())).m_126130_("csc").m_126130_("cfc").m_126130_("coc").m_126132_("has_magician_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.MAGICIAN_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("primitive_furnace_cell"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.LAVA_CRYSTAL.get())).m_206416_(Character.valueOf('a'), Tags.Items.GLASS).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42448_).m_126124_(Character.valueOf('c'), (Ingredient)IngredientBloodOrb.fromOrb((BloodOrb)BloodMagicItems.ORB_WEAK.get())).m_206416_(Character.valueOf('d'), Tags.Items.OBSIDIAN).m_206416_(Character.valueOf('e'), Tags.Items.GEMS_DIAMOND).m_126130_("aba").m_126130_("bcb").m_126130_("ded").m_126132_("has_weak_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.WEAK_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("lava_crystal"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.PRIMITIVE_HYDRATION_CELL.get())).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42447_).m_206416_(Character.valueOf('c'), Tags.Items.COBBLESTONE).m_126124_(Character.valueOf('o'), (Ingredient)IngredientBloodOrb.fromOrb((BloodOrb)BloodMagicItems.ORB_MAGICIAN.get())).m_126127_(Character.valueOf('s'), (ItemLike)BloodMagicItems.SLATE.get()).m_126130_("csc").m_126130_("cBc").m_126130_("coc").m_126132_("has_magician_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.MAGICIAN_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("primitive_hydration_cell"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.WOOD_PATH.get()), (int)4).m_206419_(ItemTags.f_13168_).m_206419_(ItemTags.f_13168_).m_206419_(ItemTags.f_13168_).m_206419_(ItemTags.f_13168_).m_126184_((Ingredient)IngredientBloodOrb.fromOrb((BloodOrb)BloodMagicItems.ORB_APPRENTICE.get())).m_126132_("has_apprentice_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.APPRENTICE_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("path/path_wood"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.STONE_PATH.get()), (int)4).m_206419_(Tags.Items.STONE).m_206419_(Tags.Items.STONE).m_206419_(Tags.Items.STONE).m_206419_(Tags.Items.STONE).m_126184_((Ingredient)IngredientBloodOrb.fromOrb((BloodOrb)BloodMagicItems.ORB_MAGICIAN.get())).m_126132_("has_magician_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.MAGICIAN_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("path/path_stone"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.WORN_STONE_PATH.get()), (int)4).m_126209_((ItemLike)BloodMagicBlocks.STONE_PATH.get()).m_126209_((ItemLike)BloodMagicBlocks.STONE_PATH.get()).m_126209_((ItemLike)BloodMagicBlocks.STONE_PATH.get()).m_126209_((ItemLike)BloodMagicBlocks.STONE_PATH.get()).m_126184_((Ingredient)IngredientBloodOrb.fromOrb((BloodOrb)BloodMagicItems.ORB_MASTER.get())).m_126132_("has_master_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.MASTER_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("path/path_wornstone"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.OBSIDIAN_PATH.get()), (int)4).m_126209_((ItemLike)Blocks.f_50080_).m_126209_((ItemLike)Blocks.f_50080_).m_126209_((ItemLike)Blocks.f_50080_).m_126209_((ItemLike)Blocks.f_50080_).m_126184_((Ingredient)IngredientBloodOrb.fromOrb((BloodOrb)BloodMagicItems.ORB_ARCHMAGE.get())).m_126132_("has_archmage_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.ARCHMAGE_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("path/path_obsidian"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.RITUAL_READER.get())).m_126127_(Character.valueOf('s'), (ItemLike)BloodMagicItems.DEMONIC_SLATE.get()).m_206416_(Character.valueOf('g'), Tags.Items.GLASS).m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_GOLD).m_126124_(Character.valueOf('o'), (Ingredient)IngredientBloodOrb.fromOrb((BloodOrb)BloodMagicItems.ORB_MASTER.get())).m_126130_("gog").m_126130_("isi").m_126130_(" s ").m_126132_("has_master_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.MASTER_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("ritual_reader"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicItems.EXPERIENCE_TOME.get())).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42690_).m_206416_(Character.valueOf('s'), Tags.Items.STRING).m_206416_(Character.valueOf('e'), Tags.Items.STORAGE_BLOCKS_LAPIS).m_206416_(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).m_126127_(Character.valueOf('l'), (ItemLike)BloodMagicItems.IMBUED_SLATE.get()).m_126124_(Character.valueOf('o'), (Ingredient)IngredientBloodOrb.fromOrb((BloodOrb)BloodMagicItems.ORB_MAGICIAN.get())).m_126130_("ses").m_126130_("lbl").m_126130_("gog").m_126132_("has_magician_orb", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.MAGICIAN_BLOOD_ORB.get()))).m_126140_(consumer, BloodMagic.rl("experience_tome"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.SPEED_RUNE_2.get())).m_126130_("sps").m_126130_("drd").m_126130_("sos").m_126127_(Character.valueOf('r'), (ItemLike)BloodMagicBlocks.SPEED_RUNE.get()).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42419_).m_126127_(Character.valueOf('p'), (ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()).m_126127_(Character.valueOf('d'), (ItemLike)BloodMagicItems.BLOODSTONE_ITEM.get()).m_126127_(Character.valueOf('o'), (ItemLike)BloodMagicItems.ETHEREAL_SLATE.get()).m_126132_("has_hellforged_parts", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()))).m_126140_(consumer, BloodMagic.rl("blood_rune_speed_2"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.ACCELERATION_RUNE_2.get())).m_126130_("sps").m_126130_("drd").m_126130_("sos").m_126127_(Character.valueOf('r'), (ItemLike)BloodMagicBlocks.ACCELERATION_RUNE.get()).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42419_).m_126127_(Character.valueOf('p'), (ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()).m_126127_(Character.valueOf('d'), (ItemLike)BloodMagicItems.BLOODSTONE_ITEM.get()).m_126127_(Character.valueOf('o'), (ItemLike)BloodMagicItems.ETHEREAL_SLATE.get()).m_126132_("has_hellforged_parts", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()))).m_126140_(consumer, BloodMagic.rl("blood_rune_acceleration_2"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.AUGMENTED_CAPACITY_RUNE_2.get())).m_126130_("sps").m_126130_("drd").m_126130_("sos").m_126127_(Character.valueOf('r'), (ItemLike)BloodMagicBlocks.AUGMENTED_CAPACITY_RUNE.get()).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42419_).m_126127_(Character.valueOf('p'), (ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()).m_126127_(Character.valueOf('d'), (ItemLike)BloodMagicItems.BLOODSTONE_ITEM.get()).m_126127_(Character.valueOf('o'), (ItemLike)BloodMagicItems.ETHEREAL_SLATE.get()).m_126132_("has_hellforged_parts", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()))).m_126140_(consumer, BloodMagic.rl("blood_rune_aug_capacity_2"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.CAPACITY_RUNE_2.get())).m_126130_("sps").m_126130_("drd").m_126130_("sos").m_126127_(Character.valueOf('r'), (ItemLike)BloodMagicBlocks.CAPACITY_RUNE.get()).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42419_).m_126127_(Character.valueOf('p'), (ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()).m_126127_(Character.valueOf('d'), (ItemLike)BloodMagicItems.BLOODSTONE_ITEM.get()).m_126127_(Character.valueOf('o'), (ItemLike)BloodMagicItems.ETHEREAL_SLATE.get()).m_126132_("has_hellforged_parts", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()))).m_126140_(consumer, BloodMagic.rl("blood_rune_capacity_2"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.CHARGING_RUNE_2.get())).m_126130_("sps").m_126130_("drd").m_126130_("sos").m_126127_(Character.valueOf('r'), (ItemLike)BloodMagicBlocks.CHARGING_RUNE.get()).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42419_).m_126127_(Character.valueOf('p'), (ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()).m_126127_(Character.valueOf('d'), (ItemLike)BloodMagicItems.BLOODSTONE_ITEM.get()).m_126127_(Character.valueOf('o'), (ItemLike)BloodMagicItems.ETHEREAL_SLATE.get()).m_126132_("has_hellforged_parts", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()))).m_126140_(consumer, BloodMagic.rl("blood_rune_charging_2"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.DISPLACEMENT_RUNE_2.get())).m_126130_("sps").m_126130_("drd").m_126130_("sos").m_126127_(Character.valueOf('r'), (ItemLike)BloodMagicBlocks.DISPLACEMENT_RUNE.get()).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42419_).m_126127_(Character.valueOf('p'), (ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()).m_126127_(Character.valueOf('d'), (ItemLike)BloodMagicItems.BLOODSTONE_ITEM.get()).m_126127_(Character.valueOf('o'), (ItemLike)BloodMagicItems.ETHEREAL_SLATE.get()).m_126132_("has_hellforged_parts", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()))).m_126140_(consumer, BloodMagic.rl("blood_rune_displacement_2"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.ORB_RUNE_2.get())).m_126130_("sps").m_126130_("drd").m_126130_("sos").m_126127_(Character.valueOf('r'), (ItemLike)BloodMagicBlocks.ORB_RUNE.get()).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42419_).m_126127_(Character.valueOf('p'), (ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()).m_126127_(Character.valueOf('d'), (ItemLike)BloodMagicItems.BLOODSTONE_ITEM.get()).m_126127_(Character.valueOf('o'), (ItemLike)BloodMagicItems.ETHEREAL_SLATE.get()).m_126132_("has_hellforged_parts", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()))).m_126140_(consumer, BloodMagic.rl("blood_rune_orb_2"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.SELF_SACRIFICE_RUNE_2.get())).m_126130_("sps").m_126130_("drd").m_126130_("sos").m_126127_(Character.valueOf('r'), (ItemLike)BloodMagicBlocks.SELF_SACRIFICE_RUNE.get()).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42419_).m_126127_(Character.valueOf('p'), (ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()).m_126127_(Character.valueOf('d'), (ItemLike)BloodMagicItems.BLOODSTONE_ITEM.get()).m_126127_(Character.valueOf('o'), (ItemLike)BloodMagicItems.ETHEREAL_SLATE.get()).m_126132_("has_hellforged_parts", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()))).m_126140_(consumer, BloodMagic.rl("blood_rune_self_sac_2"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BloodMagicBlocks.SACRIFICE_RUNE_2.get())).m_126130_("sps").m_126130_("drd").m_126130_("sos").m_126127_(Character.valueOf('r'), (ItemLike)BloodMagicBlocks.SACRIFICE_RUNE.get()).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42419_).m_126127_(Character.valueOf('p'), (ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()).m_126127_(Character.valueOf('d'), (ItemLike)BloodMagicItems.BLOODSTONE_ITEM.get()).m_126127_(Character.valueOf('o'), (ItemLike)BloodMagicItems.ETHEREAL_SLATE.get()).m_126132_("has_hellforged_parts", (CriterionTriggerInstance)GeneratorRecipes.m_125977_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()))).m_126140_(consumer, BloodMagic.rl("blood_rune_sac_2"));
    }
}

