/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="felling")
public class RitualFelling
extends Ritual {
    public static final String FELLING_RANGE = "fellingRange";
    public static final String CHEST_RANGE = "chest";
    private ArrayList<BlockPos> treePartsCache;
    private Iterator<BlockPos> blockPosIterator;
    private boolean cached = false;
    private BlockPos currentPos;
    private static final ItemStack mockAxe = new ItemStack((ItemLike)Items.f_42391_, 1);

    public RitualFelling() {
        super("ritualFelling", 0, 20000, "ritual.bloodmagic.fellingRitual");
        this.addBlockRange(FELLING_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-10, -3, -10), new BlockPos(11, 27, 11)));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(FELLING_RANGE, 14000, 15, 30);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
        this.treePartsCache = new ArrayList();
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Level world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos masterPos = masterRitualStone.getMasterBlockPos();
        AreaDescriptor chestRange = masterRitualStone.getBlockRange(CHEST_RANGE);
        BlockEntity tileInventory = world.m_7702_(chestRange.getContainedPositions(masterPos).get(0));
        if (world.f_46443_) {
            return;
        }
        if (tileInventory != null && Utils.getNumberOfFreeSlots(tileInventory, Direction.DOWN) < 1) {
            return;
        }
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        if (!this.cached || this.treePartsCache.isEmpty()) {
            for (BlockPos blockPos : masterRitualStone.getBlockRange(FELLING_RANGE).getContainedPositions(masterRitualStone.getMasterBlockPos())) {
                if (this.treePartsCache.contains(blockPos) || world.m_46859_(blockPos) || !world.m_8055_(blockPos).m_204336_(BlockTags.f_13106_) && !world.m_8055_(blockPos).m_204336_(BlockTags.f_13035_)) continue;
                this.treePartsCache.add(blockPos);
            }
            this.cached = true;
            this.blockPosIterator = this.treePartsCache.iterator();
        }
        if (this.blockPosIterator.hasNext() && tileInventory != null) {
            masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
            this.currentPos = this.blockPosIterator.next();
            IItemHandler inventory = Utils.getInventory(tileInventory, Direction.DOWN);
            BlockState state = world.m_8055_(this.currentPos);
            this.placeInInventory(state, world, this.currentPos, inventory);
            BlockPlaceContext ctx = new BlockPlaceContext(world, null, InteractionHand.MAIN_HAND, ItemStack.f_41583_, BlockHitResult.m_82426_((Vec3)new Vec3(0.0, 0.0, 0.0), (Direction)Direction.UP, (BlockPos)this.currentPos));
            this.spawnParticlesAndSound((ServerLevel)world, this.currentPos, state, ctx);
            world.m_46597_(this.currentPos, Blocks.f_50016_.m_49966_());
            this.blockPosIterator.remove();
        }
    }

    public void spawnParticlesAndSound(ServerLevel world, BlockPos pos, BlockState state, BlockPlaceContext context) {
        SoundType soundtype = state.getSoundType((LevelReader)world, pos, (Entity)context.m_43723_());
        world.m_5594_(context.m_43723_(), pos, state.getSoundType((LevelReader)world, pos, (Entity)context.m_43723_()).m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        BlockParticleOption particleData = new BlockParticleOption(ParticleTypes.f_123794_, state);
        world.m_8767_((ParticleOptions)particleData, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 8, 0.2, 0.2, 0.2, 0.03);
    }

    @Override
    public int getRefreshCost() {
        return 10;
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.EARTH);
        this.addCornerRunes(components, 1, 1, EnumRuneType.EARTH);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualFelling();
    }

    private void placeInInventory(BlockState choppedState, Level world, BlockPos choppedPos, @Nullable IItemHandler inventory) {
        if (inventory == null) {
            return;
        }
        LootParams.Builder lootBuilder = new LootParams.Builder((ServerLevel)world);
        Vec3 blockCenter = new Vec3((double)choppedPos.m_123341_() + 0.5, (double)choppedPos.m_123342_() + 0.5, (double)choppedPos.m_123343_() + 0.5);
        List silkDrops = choppedState.m_287290_(lootBuilder.m_287286_(LootContextParams.f_81460_, (Object)blockCenter).m_287286_(LootContextParams.f_81463_, (Object)mockAxe));
        for (ItemStack stack : silkDrops) {
            ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)inventory, (ItemStack)stack, (boolean)false);
            if (remainder.m_41619_()) continue;
            world.m_7967_((Entity)new ItemEntity(world, (double)choppedPos.m_123341_() + 0.4, (double)(choppedPos.m_123342_() + 2), (double)choppedPos.m_123343_() + 0.4, remainder));
        }
    }
}

