/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util.handler.event;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.level.ChunkDataEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IDemonWill;
import wayoftime.bloodmagic.api.compat.IDemonWillWeapon;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.demonaura.PosXY;
import wayoftime.bloodmagic.demonaura.WillChunk;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.potion.BloodMagicPotions;
import wayoftime.bloodmagic.will.DemonWillHolder;
import wayoftime.bloodmagic.will.PlayerDemonWillHandler;

@Mod.EventBusSubscriber(modid="bloodmagic", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WillHandler {
    private static final HashMap<ResourceLocation, Integer> SERVER_TICKS = new HashMap();

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        ItemStack stack = event.getItem().m_32055_();
        if (stack.m_41720_() instanceof IDemonWill) {
            Player player = event.getEntity();
            EnumDemonWillType pickupType = ((IDemonWill)stack.m_41720_()).getType(stack);
            ItemStack remainder = PlayerDemonWillHandler.addDemonWill(player, stack);
            if (remainder == null || ((IDemonWill)stack.m_41720_()).getWill(pickupType, stack) < 1.0E-4 || PlayerDemonWillHandler.isDemonWillFull(pickupType, player)) {
                stack.m_41764_(0);
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        IDemonWillWeapon demonWillWeapon;
        List<ItemStack> droppedSouls;
        Player player;
        ItemStack heldStack;
        LivingEntity attackedEntity = event.getEntity();
        DamageSource source = event.getSource();
        Entity entity = source.m_7639_();
        if (attackedEntity.m_21023_((MobEffect)BloodMagicPotions.SOUL_SNARE.get()) && (attackedEntity instanceof Mob || attackedEntity.m_20193_().m_46791_() == Difficulty.PEACEFUL)) {
            MobEffectInstance eff = attackedEntity.m_21124_((MobEffect)BloodMagicPotions.SOUL_SNARE.get());
            int lvl = eff.m_19564_();
            double amountOfSouls = attackedEntity.m_20193_().f_46441_.m_188500_() * (double)(lvl + 1) * (double)(lvl + 1) * 4.0 + 1.0;
            ItemStack soulStack = ((IDemonWill)BloodMagicItems.MONSTER_SOUL_RAW.get()).createWill(amountOfSouls);
            event.getDrops().add(new ItemEntity(attackedEntity.m_20193_(), attackedEntity.m_20185_(), attackedEntity.m_20186_(), attackedEntity.m_20189_(), soulStack));
        }
        if (entity != null && entity instanceof Player && (heldStack = (player = (Player)entity).m_21205_()).m_41720_() instanceof IDemonWillWeapon && !player.m_20193_().f_46443_ && !(droppedSouls = (demonWillWeapon = (IDemonWillWeapon)heldStack.m_41720_()).getRandomDemonWillDrop(attackedEntity, (LivingEntity)player, heldStack, event.getLootingLevel())).isEmpty()) {
            for (ItemStack willStack : droppedSouls) {
                ItemStack remainder = PlayerDemonWillHandler.addDemonWill(player, willStack);
                if (remainder.m_41619_()) continue;
                EnumDemonWillType pickupType = ((IDemonWill)remainder.m_41720_()).getType(remainder);
                if (!(((IDemonWill)remainder.m_41720_()).getWill(pickupType, remainder) >= 1.0E-4)) continue;
                event.getDrops().add(new ItemEntity(attackedEntity.m_20193_(), attackedEntity.m_20185_(), attackedEntity.m_20186_(), attackedEntity.m_20189_(), remainder));
            }
            player.f_36095_.m_38946_();
        }
    }

    @SubscribeEvent
    public void onServerWorldTick(TickEvent.LevelTickEvent event) {
        if (event.level.f_46443_) {
            return;
        }
        ResourceLocation rl = WorldDemonWillHandler.getDimensionResourceLocation(event.level);
        if (event.phase == TickEvent.Phase.END) {
            ConcurrentLinkedQueue<PosXY> dirtyChunks;
            int ticks;
            if (!SERVER_TICKS.containsKey(rl)) {
                SERVER_TICKS.put(rl, 0);
            }
            if ((ticks = SERVER_TICKS.get(rl).intValue()) % 20 == 0 && (dirtyChunks = WorldDemonWillHandler.dirtyChunks.get(rl)) != null && dirtyChunks.size() > 0) {
                for (PosXY pos : dirtyChunks) {
                    ChunkAccess chunk = event.level.m_6522_(pos.x, pos.y, ChunkStatus.f_62326_, false);
                    if (chunk == null) continue;
                    chunk.m_8092_(true);
                }
                dirtyChunks.clear();
            }
            SERVER_TICKS.put(rl, ticks + 1);
        }
    }

    public static boolean isBlockLoaded(BlockGetter world, BlockPos pos) {
        if (world == null || pos.m_123342_() < world.m_141937_() || pos.m_123342_() > world.m_151558_()) {
            return false;
        }
        if (world instanceof LevelReader) {
            return ((LevelReader)world).m_46805_(pos);
        }
        return true;
    }

    @SubscribeEvent
    public void chunkSave(ChunkDataEvent.Save event) {
        if (!(event.getLevel() instanceof Level)) {
            return;
        }
        ResourceLocation rl = WorldDemonWillHandler.getDimensionResourceLocation((Level)event.getLevel());
        ChunkPos loc = event.getChunk().m_7697_();
        WillChunk ac = WorldDemonWillHandler.getWillChunk(rl, loc.f_45578_, loc.f_45579_);
        if (ac != null) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128376_("base", ac.getBase());
            ac.getCurrentWill().writeToNBT(nbt, "current");
            event.getData().m_128365_("BloodMagic", (Tag)nbt);
        }
    }

    @SubscribeEvent
    public void chunkUnload(ChunkEvent.Unload event) {
        if (!(event.getLevel() instanceof Level)) {
            return;
        }
        ResourceLocation rl = WorldDemonWillHandler.getDimensionResourceLocation((Level)event.getLevel());
        ChunkPos loc = event.getChunk().m_7697_();
        WillChunk ac = WorldDemonWillHandler.getWillChunk(rl, loc.f_45578_, loc.f_45579_);
        if (ac != null) {
            WorldDemonWillHandler.removeWillChunk(rl, loc.f_45578_, loc.f_45579_);
        }
    }

    @SubscribeEvent
    public void chunkLoad(ChunkDataEvent.Load event) {
        if (!(event.getLevel() instanceof Level)) {
            return;
        }
        ResourceLocation rl = WorldDemonWillHandler.getDimensionResourceLocation((Level)event.getLevel());
        if (event.getData().m_128469_("BloodMagic").m_128441_("base")) {
            CompoundTag nbt = event.getData().m_128469_("BloodMagic");
            short base = nbt.m_128448_("base");
            DemonWillHolder current = new DemonWillHolder();
            current.readFromNBT(nbt, "current");
            WorldDemonWillHandler.addWillChunk(rl, event.getChunk(), base, current);
        } else {
            WorldDemonWillHandler.generateWill(event.getChunk(), (Level)event.getLevel());
        }
    }
}

