/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.throwable.entity;

import com.google.common.base.Suppliers;
import com.iafenvoy.throwable.config.ThrowableConfig;
import com.iafenvoy.throwable.mixin.PersistentProjectileEntityAccessor;
import com.iafenvoy.throwable.util.EnchantmentUtil;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownWeaponEntity
extends AbstractArrow {
    public static final String ID = "thrown_weapon";
    public static final Supplier<EntityType<ThrownWeaponEntity>> TYPE = Suppliers.memoize(() -> EntityType.Builder.of(ThrownWeaponEntity::new, (MobCategory)MobCategory.MISC).clientTrackingRange(64).updateInterval(1).sized(0.5f, 0.5f).build(ID));
    private static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.defineId(ThrownWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.defineId(ThrownWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private boolean hitEntity;
    private boolean canReturn;
    private boolean returning;

    public ThrownWeaponEntity(Level world, LivingEntity owner, ItemStack stack) {
        super(TYPE.get(), owner, world, stack, null);
        this.setPickupItemStack(stack);
        this.setNoPhysics(false);
    }

    public ThrownWeaponEntity(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
        this.setNoPhysics(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STACK, (Object)ItemStack.EMPTY);
        builder.define(SCALE, (Object)Float.valueOf(1.0f));
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setPickupItemStack(ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)nbt.getCompound("stack")));
        this.setScale(nbt.getFloat("scale"));
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.put("stack", this.getPickupItem().saveOptional((HolderLookup.Provider)this.registryAccess()));
        nbt.putFloat("scale", this.getScale());
    }

    protected void tickDespawn() {
        int despawnTime = ThrowableConfig.INSTANCE.despawnDelayTicks;
        if (despawnTime <= -1) {
            return;
        }
        PersistentProjectileEntityAccessor accessor = (PersistentProjectileEntityAccessor)((Object)this);
        int life = accessor.getLife();
        if (this.pickup == AbstractArrow.Pickup.CREATIVE_ONLY) {
            if (life >= 1200) {
                this.discard();
            }
        } else if (life >= despawnTime) {
            if (ThrowableConfig.INSTANCE.dropWhenDespawn) {
                this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), this.getPickupItem()));
            }
            this.discard();
        }
        if (!this.isRemoved()) {
            accessor.setLife(life + 1);
        }
    }

    public void tick() {
        if (this.inGroundTime > 4) {
            this.canReturn = true;
        }
        Entity entity = this.getOwner();
        int i = EnchantmentUtil.getEnchantmentLevel(this.level().registryAccess(), (ResourceKey<Enchantment>)Enchantments.LOYALTY, this.getPickupItem());
        if (i > 0 && (this.canReturn || this.isNoPhysics()) && entity != null && entity.isAlive()) {
            if (this.pickup == AbstractArrow.Pickup.DISALLOWED) {
                this.pickup = AbstractArrow.Pickup.ALLOWED;
            }
            this.setNoPhysics(true);
            Vec3 vec3d = entity.getEyePosition().subtract(this.position());
            this.setPosRaw(this.getX(), this.getY() + vec3d.y * 0.015 * (double)i, this.getZ());
            if (this.level().isClientSide) {
                this.yOld = this.getY();
            }
            double d = 0.05 * (double)i;
            this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vec3d.normalize().scale(d)));
            if (!this.returning) {
                this.returning = true;
                this.playSound(SoundEvents.TRIDENT_RETURN, 10.0f, 1.0f);
            }
        }
        super.tick();
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.pickup == AbstractArrow.Pickup.DISALLOWED && (!ThrowableConfig.INSTANCE.ownerPickUpOnly || this.getOwner() == player) && player.getItemInHand(hand).isEmpty()) {
            player.setItemInHand(hand, this.getPickupItem());
            this.discard();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected boolean canHitEntity(Entity entity) {
        return !(entity instanceof ThrownWeaponEntity);
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        DamageSource damageSource;
        Entity entity2;
        if (this.hitEntity) {
            return;
        }
        Entity entity = entityHitResult.getEntity();
        float f = (float)this.getDeltaMovement().length();
        int i = Mth.ceil((double)Mth.clamp((double)((double)f * this.getBaseDamage()), (double)0.0, (double)2.147483647E9));
        if (this.isCritArrow()) {
            long l = this.random.nextInt(i / 2 + 2);
            i = (int)Math.min(l + (long)i, Integer.MAX_VALUE);
        }
        if ((entity2 = this.getOwner()) == null) {
            damageSource = this.damageSources().arrow((AbstractArrow)this, (Entity)this);
        } else {
            damageSource = this.damageSources().arrow((AbstractArrow)this, entity2);
            if (entity2 instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity2;
                living.setLastHurtMob(entity);
            }
        }
        boolean bl = entity.getType() == EntityType.ENDERMAN;
        int j = entity.getRemainingFireTicks();
        int level = EnchantmentUtil.getEnchantmentLevel(this.level().registryAccess(), (ResourceKey<Enchantment>)Enchantments.FIRE_ASPECT, this.getPickupItem());
        if ((this.isOnFire() || level > 0) && !bl) {
            entity.igniteForSeconds((float)((this.isOnFire() ? 5 : 0) + level * 5));
        }
        if (entity.hurt(damageSource, (float)i)) {
            if (bl) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (!this.level().isClientSide && this.getPierceLevel() <= 0) {
                    living.setArrowCount(living.getArrowCount() + 1);
                }
                this.doKnockback(living, damageSource);
                Level var13 = this.level();
                if (var13 instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)var13;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverWorld, (Entity)living, (DamageSource)damageSource, (ItemStack)this.getWeaponItem());
                }
                this.doPostHurtEffects(living);
                if (living != entity2 && living instanceof Player && entity2 instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity2;
                    if (!this.isSilent()) {
                        serverPlayer.connection.sendPacket((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                    }
                }
            }
            this.playSound(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0) {
                this.hitEntity = true;
            }
        } else {
            entity.setRemainingFireTicks(j);
            this.setDeltaMovement(this.getDeltaMovement().scale(-0.1));
            this.setYRot(this.getYRot() + 180.0f);
            this.yRotO += 180.0f;
            if (!this.level().isClientSide && this.getDeltaMovement().lengthSqr() < 1.0E-7) {
                if (this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.hitEntity = true;
            }
        }
        this.setDeltaMovement(0.0, 0.0, 0.0);
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        SoundEvent soundEvent = this.getHitGroundSoundEvent();
        super.onHitBlock(blockHitResult);
        this.setSoundEvent(soundEvent);
    }

    protected Component getTypeName() {
        return this.getPickupItem().getHoverName();
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public void setBaseDamage(double scale) {
        double damage = 1.0;
        Integer component = (Integer)this.getPickupItem().get(DataComponents.DAMAGE);
        if (component != null) {
            damage = component.intValue();
        }
        super.setBaseDamage(damage * scale);
    }

    public ItemStack getPickupItem() {
        return ((ItemStack)this.entityData.get(STACK)).copy();
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    public void setPickupItemStack(ItemStack stack) {
        this.entityData.set(STACK, (Object)stack);
    }

    public float getScale() {
        return ((Float)this.entityData.get(SCALE)).floatValue();
    }

    public void setScale(float scale) {
        this.entityData.set(SCALE, (Object)Float.valueOf(scale));
    }
}

