/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.throwable.mixin;

import com.iafenvoy.throwable.config.ThrowableConfig;
import com.iafenvoy.throwable.data.ThrowableData;
import com.iafenvoy.throwable.data.ThrowableItemExtension;
import com.iafenvoy.throwable.data.ThrowableRegistry;
import com.iafenvoy.throwable.entity.ThrownWeaponEntity;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public abstract class ItemMixin
implements ThrowableItemExtension {
    @Shadow
    public abstract Holder.Reference<Item> builtInRegistryHolder();

    @Override
    public ThrowableData throwable$getData(RegistryAccess registries) {
        return ThrowableRegistry.get(registries, (Item)this);
    }

    @Override
    public boolean throwable$canThrow() {
        return this.builtInRegistryHolder().is(THROWABLE);
    }

    @Inject(method={"getUseAnimation(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/UseAnim;"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleUseAction(ItemStack stack, CallbackInfoReturnable<UseAnim> cir) {
        if (this.throwable$canThrow()) {
            cir.setReturnValue((Object)UseAnim.SPEAR);
        }
    }

    @Inject(method={"getUseDuration(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleMaxUseTime(ItemStack stack, LivingEntity user, CallbackInfoReturnable<Integer> cir) {
        RegistryAccess manager = ThrowableRegistry.DYNAMIC_REGISTRY_GETTER.get();
        if (this.throwable$canThrow() && manager != null) {
            cir.setReturnValue((Object)this.throwable$getData(manager).maxUseTime());
        }
    }

    @Inject(method={"releaseUsing(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleStoppedUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks, CallbackInfo ci) {
        if (this.throwable$canThrow() && user instanceof Player) {
            Player player = (Player)user;
            ThrowableData data = this.throwable$getData(world.registryAccess());
            int i = data.maxUseTime() - remainingUseTicks;
            if (i >= 10) {
                if (!world.isClientSide) {
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)user.getUsedItemHand()));
                    ThrownWeaponEntity weapon = new ThrownWeaponEntity(world, (LivingEntity)player, stack);
                    weapon.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.5f, 1.0f);
                    if (player.getAbilities().instabuild) {
                        weapon.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                    } else {
                        weapon.pickup = ThrowableConfig.INSTANCE.autoPick ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.DISALLOWED;
                        player.getInventory().removeItem(stack);
                    }
                    if (remainingUseTicks <= 0) {
                        weapon.setCritArrow(true);
                    }
                    weapon.setSoundEvent(data.hitGroundSound());
                    weapon.setBaseDamage(data.damageScale());
                    world.addFreshEntity((Entity)weapon);
                    world.playSound(null, (Entity)weapon, data.throwSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                ci.cancel();
            }
        }
    }

    @Inject(method={"use(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleUse(Level world, Player user, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (!user.isShiftKeyDown() && ThrowableConfig.INSTANCE.sneakThrow) {
            return;
        }
        if (hand == InteractionHand.MAIN_HAND && user.getOffhandItem().is(DISABLE_WHEN_OFFHAND)) {
            return;
        }
        if (this.throwable$canThrow()) {
            ItemStack stack = user.getItemInHand(hand);
            if (stack.getDamageValue() >= stack.getMaxDamage() - 1) {
                cir.setReturnValue((Object)InteractionResultHolder.fail((Object)stack));
            } else {
                user.startUsingItem(hand);
                cir.setReturnValue((Object)InteractionResultHolder.consume((Object)stack));
            }
        }
    }
}

