/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.throwable.render;

import com.iafenvoy.throwable.data.ThrowableData;
import com.iafenvoy.throwable.data.ThrowableItemExtension;
import com.iafenvoy.throwable.entity.ThrownWeaponEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class ThrownWeaponEntityRenderer
extends EntityRenderer<ThrownWeaponEntity> {
    private final ItemRenderer itemRenderer;

    public ThrownWeaponEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.itemRenderer = ctx.getItemRenderer();
    }

    public void render(ThrownWeaponEntity entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        ThrowableData throwableData;
        assert (Minecraft.getInstance().level != null);
        RegistryAccess registries = Minecraft.getInstance().level.registryAccess();
        ItemStack stack = entity.getPickupItem();
        Item item = stack.getItem();
        if (item instanceof ThrowableItemExtension) {
            ThrowableItemExtension item2 = (ThrowableItemExtension)item;
            throwableData = item2.throwable$getData(registries);
        } else {
            throwableData = null;
        }
        ThrowableData data = throwableData;
        matrices.pushPose();
        if (data != null) {
            float scale = data.scale();
            matrices.scale(scale, scale, scale);
        }
        matrices.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)tickDelta, (float)entity.yRotO, (float)entity.getYRot()) - 90.0f));
        matrices.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)tickDelta, (float)entity.xRotO, (float)entity.getXRot()) + (data != null ? data.rotateOffset() : 0.0f) - 135.0f));
        matrices.translate(-0.125, 0.0, 0.0);
        this.itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, matrices, vertexConsumers, entity.getCommandSenderWorld(), 0);
        matrices.popPose();
    }

    public ResourceLocation getTexture(ThrownWeaponEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"", (String)"");
    }

    public static void applyThrowTransform(PoseStack matrices) {
        matrices.mulPose(Axis.ZP.rotationDegrees(180.0f));
        matrices.translate(0.0, 0.25, 0.0);
    }
}

