/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.throwable.entity;

import com.google.common.base.Suppliers;
import com.iafenvoy.throwable.config.ThrowableConfig;
import com.iafenvoy.throwable.mixin.PersistentProjectileEntityAccessor;
import com.iafenvoy.throwable.util.EnchantmentUtil;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2668;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_9334;

public class ThrownWeaponEntity
extends class_1665 {
    public static final String ID = "thrown_weapon";
    public static final Supplier<class_1299<ThrownWeaponEntity>> TYPE = Suppliers.memoize(() -> class_1299.class_1300.method_5903(ThrownWeaponEntity::new, (class_1311)class_1311.field_17715).method_27299(64).method_27300(1).method_17687(0.5f, 0.5f).method_5905(ID));
    private static final class_2940<class_1799> STACK = class_2945.method_12791(ThrownWeaponEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Float> SCALE = class_2945.method_12791(ThrownWeaponEntity.class, (class_2941)class_2943.field_13320);
    private boolean hitEntity;
    private boolean canReturn;
    private boolean returning;

    public ThrownWeaponEntity(class_1937 world, class_1309 owner, class_1799 stack) {
        super(TYPE.get(), owner, world, stack, null);
        this.method_57313(stack);
        this.method_7433(false);
    }

    public ThrownWeaponEntity(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
        this.method_7433(false);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(STACK, (Object)class_1799.field_8037);
        builder.method_56912(SCALE, (Object)Float.valueOf(1.0f));
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.method_57313(class_1799.method_57359((class_7225.class_7874)this.method_56673(), (class_2487)nbt.method_10562("stack")));
        this.setScale(nbt.method_10583("scale"));
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10566("stack", this.method_7445().method_57375((class_7225.class_7874)this.method_56673()));
        nbt.method_10548("scale", this.getScale());
    }

    protected void method_7446() {
        int despawnTime = ThrowableConfig.INSTANCE.despawnDelayTicks;
        if (despawnTime <= -1) {
            return;
        }
        PersistentProjectileEntityAccessor accessor = (PersistentProjectileEntityAccessor)((Object)this);
        int life = accessor.getLife();
        if (this.field_7572 == class_1665.class_1666.field_7594) {
            if (life >= 1200) {
                this.method_31472();
            }
        } else if (life >= despawnTime) {
            if (ThrowableConfig.INSTANCE.dropWhenDespawn) {
                this.method_37908().method_8649((class_1297)new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), this.method_7445()));
            }
            this.method_31472();
        }
        if (!this.method_31481()) {
            accessor.setLife(life + 1);
        }
    }

    public void method_5773() {
        if (this.field_7576 > 4) {
            this.canReturn = true;
        }
        class_1297 entity = this.method_24921();
        int i = EnchantmentUtil.getEnchantmentLevel(this.method_37908().method_30349(), (class_5321<class_1887>)class_1893.field_9120, this.method_7445());
        if (i > 0 && (this.canReturn || this.method_7441()) && entity != null && entity.method_5805()) {
            if (this.field_7572 == class_1665.class_1666.field_7592) {
                this.field_7572 = class_1665.class_1666.field_7593;
            }
            this.method_7433(true);
            class_243 vec3d = entity.method_33571().method_1020(this.method_19538());
            this.method_23327(this.method_23317(), this.method_23318() + vec3d.field_1351 * 0.015 * (double)i, this.method_23321());
            if (this.method_37908().field_9236) {
                this.field_5971 = this.method_23318();
            }
            double d = 0.05 * (double)i;
            this.method_18799(this.method_18798().method_1021(0.95).method_1019(vec3d.method_1029().method_1021(d)));
            if (!this.returning) {
                this.returning = true;
                this.method_5783(class_3417.field_14698, 10.0f, 1.0f);
            }
        }
        super.method_5773();
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (this.field_7572 == class_1665.class_1666.field_7592 && (!ThrowableConfig.INSTANCE.ownerPickUpOnly || this.method_24921() == player) && player.method_5998(hand).method_7960()) {
            player.method_6122(hand, this.method_7445());
            this.method_31472();
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    protected boolean method_26958(class_1297 entity) {
        return !(entity instanceof ThrownWeaponEntity);
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1282 damageSource;
        class_1297 entity2;
        if (this.hitEntity) {
            return;
        }
        class_1297 entity = entityHitResult.method_17782();
        float f = (float)this.method_18798().method_1033();
        int i = class_3532.method_15384((double)class_3532.method_15350((double)((double)f * this.method_7448()), (double)0.0, (double)2.147483647E9));
        if (this.method_7443()) {
            long l = this.field_5974.method_43048(i / 2 + 2);
            i = (int)Math.min(l + (long)i, Integer.MAX_VALUE);
        }
        if ((entity2 = this.method_24921()) == null) {
            damageSource = this.method_48923().method_48803((class_1665)this, (class_1297)this);
        } else {
            damageSource = this.method_48923().method_48803((class_1665)this, entity2);
            if (entity2 instanceof class_1309) {
                class_1309 living = (class_1309)entity2;
                living.method_6114(entity);
            }
        }
        boolean bl = entity.method_5864() == class_1299.field_6091;
        int j = entity.method_20802();
        int level = EnchantmentUtil.getEnchantmentLevel(this.method_37908().method_30349(), (class_5321<class_1887>)class_1893.field_9124, this.method_7445());
        if ((this.method_5809() || level > 0) && !bl) {
            entity.method_5639((float)((this.method_5809() ? 5 : 0) + level * 5));
        }
        if (entity.method_5643(damageSource, (float)i)) {
            if (bl) {
                return;
            }
            if (entity instanceof class_1309) {
                class_1309 living = (class_1309)entity;
                if (!this.method_37908().field_9236 && this.method_7447() <= 0) {
                    living.method_6097(living.method_6022() + 1);
                }
                this.method_59957(living, damageSource);
                class_1937 var13 = this.method_37908();
                if (var13 instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)var13;
                    class_1890.method_60619((class_3218)serverWorld, (class_1297)living, (class_1282)damageSource, (class_1799)this.method_59958());
                }
                this.method_7450(living);
                if (living != entity2 && living instanceof class_1657 && entity2 instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)entity2;
                    if (!this.method_5701()) {
                        serverPlayer.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25651, 0.0f));
                    }
                }
            }
            this.method_5783(this.method_20011(), 1.0f, 1.2f / (this.field_5974.method_43057() * 0.2f + 0.9f));
            if (this.method_7447() <= 0) {
                this.hitEntity = true;
            }
        } else {
            entity.method_20803(j);
            this.method_18799(this.method_18798().method_1021(-0.1));
            this.method_36456(this.method_36454() + 180.0f);
            this.field_5982 += 180.0f;
            if (!this.method_37908().field_9236 && this.method_18798().method_1027() < 1.0E-7) {
                if (this.field_7572 == class_1665.class_1666.field_7593) {
                    this.method_5699(this.method_7445(), 0.1f);
                }
                this.hitEntity = true;
            }
        }
        this.method_18800(0.0, 0.0, 0.0);
    }

    protected void method_24920(class_3965 blockHitResult) {
        class_3414 soundEvent = this.method_20011();
        super.method_24920(blockHitResult);
        this.method_7444(soundEvent);
    }

    protected class_2561 method_23315() {
        return this.method_7445().method_7964();
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public void method_7438(double scale) {
        double damage = 1.0;
        Integer component = (Integer)this.method_7445().method_57824(class_9334.field_49629);
        if (component != null) {
            damage = component.intValue();
        }
        super.method_7438(damage * scale);
    }

    public class_1799 method_7445() {
        return ((class_1799)this.field_6011.method_12789(STACK)).method_7972();
    }

    protected class_1799 method_57314() {
        return class_1799.field_8037;
    }

    public void method_57313(class_1799 stack) {
        this.field_6011.method_12778(STACK, (Object)stack);
    }

    public float getScale() {
        return ((Float)this.field_6011.method_12789(SCALE)).floatValue();
    }

    public void setScale(float scale) {
        this.field_6011.method_12778(SCALE, (Object)Float.valueOf(scale));
    }
}

