/*
 * Decompiled with CFR 0.152.
 */
package net.creativity0.livetranslator;

import java.nio.file.Path;
import net.creativity0.livetranslator.chat.ChatTranslatorListener;
import net.creativity0.livetranslator.chat.ServerChatInterceptor;
import net.creativity0.livetranslator.command.ServerTranslateCommand;
import net.creativity0.livetranslator.event.TranslatorEventBus;
import net.creativity0.livetranslator.event.TranslatorLoggerListener;
import net.creativity0.livetranslator.event.TranslatorStateUpdater;
import net.creativity0.livetranslator.translation.TranslatorManager;
import net.creativity0.livetranslator.utility.LiveTranslatorLogger;
import net.creativity0.livetranslator.utility.ModDataFolder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod(value="livetranslator")
public class LiveTranslator {
    public static final String MOD_ID = "livetranslator";

    public LiveTranslator() {
        Path baseDir = FMLPaths.CONFIGDIR.get();
        ModDataFolder.setup(baseDir, MOD_ID);
        LiveTranslator.createShutdownHook();
        LiveTranslator.registerListenersServerAndClient();
        MinecraftForge.EVENT_BUS.addListener(LiveTranslator::onRegisterCommands);
        MinecraftForge.EVENT_BUS.addListener(LiveTranslator::onServerStopping);
        ServerChatInterceptor.register();
    }

    private static void onRegisterCommands(RegisterCommandsEvent event) {
        ServerTranslateCommand.register(event);
    }

    private static void onServerStopping(ServerStoppingEvent event) {
        LiveTranslator.shutdown();
    }

    private static void createShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(LiveTranslator::shutdown));
    }

    private static void shutdown() {
        LiveTranslatorLogger.LOGGER.info("shutting down....");
        TranslatorManager.stopTranslator();
        LiveTranslatorLogger.LOGGER.info("shutdown complete.");
    }

    private static void registerListenersServerAndClient() {
        TranslatorEventBus.register(new TranslatorStateUpdater());
        TranslatorEventBus.register(new TranslatorLoggerListener());
    }

    private static void registerClientOnlyListeners() {
        TranslatorEventBus.register(new ChatTranslatorListener());
    }

    @Mod.EventBusSubscriber(modid="livetranslator", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LiveTranslator.registerClientOnlyListeners();
        }
    }
}

