/*
 * Decompiled with CFR 0.152.
 */
package net.creativity0.livetranslator.chat;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class ChatMessenger {
    private static final String PREFIX = "[LiveTranslator] ";
    public static final Component ON_TEXT = ChatMessenger.green("ON");
    public static final Component OFF_TEXT = ChatMessenger.red("OFF");
    public static final Component LOADING_TEXT = ChatMessenger.blue("LOADING");
    private static final Style SYSTEM_STYLE = Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true));

    private static Component color(String message, ChatFormatting color) {
        return Component.literal((String)message).setStyle(Style.EMPTY.withColor(color));
    }

    public static Component grayItalic(String text) {
        return Component.literal((String)text).setStyle(SYSTEM_STYLE);
    }

    public static Component red(String msg) {
        return ChatMessenger.color(msg, ChatFormatting.RED);
    }

    public static Component green(String msg) {
        return ChatMessenger.color(msg, ChatFormatting.GREEN);
    }

    public static Component blue(String msg) {
        return ChatMessenger.color(msg, ChatFormatting.BLUE);
    }

    public static void sendToPlayer(Component text) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            player.sendSystemMessage((Component)Component.literal((String)PREFIX).append(text));
        }
    }

    public static MutableComponent buildPlayerText(String message, String playerName) {
        return Component.literal((String)("<" + playerName + "> ")).append(message);
    }
}

