/*
 * Decompiled with CFR 0.152.
 */
package net.creativity0.livetranslator.chat;

import net.creativity0.livetranslator.chat.ChatMessenger;
import net.creativity0.livetranslator.event.TranslatorEvent;
import net.creativity0.livetranslator.event.TranslatorEventListener;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public class ChatTranslatorListener
implements TranslatorEventListener {
    @Override
    public void onTranslatorEvent(TranslatorEvent event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        mc.execute(() -> {
            Component msg = null;
            switch (event.getType()) {
                case TRANSLATOR_START: {
                    msg = Component.literal((String)"Translator is ").append(ChatMessenger.LOADING_TEXT);
                    break;
                }
                case DEPENDENCY_CHECK_START: {
                    msg = ChatMessenger.grayItalic("Checking Python installation...");
                    break;
                }
                case ENV_SETUP_START: {
                    msg = ChatMessenger.grayItalic("Setting up Python virtual environment...");
                    break;
                }
                case DEPENDENCIES_INSTALL_START: {
                    msg = ChatMessenger.grayItalic("Installing Python dependencies...");
                    break;
                }
                case MODEL_DOWNLOAD_PROGRESS: {
                    msg = Component.literal((String)"Downloading model... ").append(ChatMessenger.blue(event.getProgress() + "%"));
                    break;
                }
                case MODEL_DOWNLOAD_COMPLETE: {
                    msg = ChatMessenger.green("Model download complete.");
                    break;
                }
                case SERVER_STARTING: {
                    msg = ChatMessenger.grayItalic("Starting Python translation server...");
                    break;
                }
                case TRANSLATOR_READY: {
                    msg = Component.literal((String)"Translator is ").append(ChatMessenger.ON_TEXT);
                    break;
                }
                case STOPPED: {
                    msg = Component.literal((String)"Translator is ").append(ChatMessenger.OFF_TEXT);
                    break;
                }
                case ERROR: {
                    Component.empty().append(ChatMessenger.red("Translator failed: " + event.getMessage())).append((Component)Component.literal((String)"\n")).append((Component)Component.literal((String)"Translator is ").append(ChatMessenger.OFF_TEXT));
                    break;
                }
            }
            if (msg != null) {
                ChatMessenger.sendToPlayer(msg);
            }
        });
    }
}

