/*
 * Decompiled with CFR 0.152.
 */
package net.creativity0.livetranslator.chat;

import net.creativity0.livetranslator.chat.ChatMessenger;
import net.creativity0.livetranslator.config.TranslationSettings;
import net.creativity0.livetranslator.translation.Translator;
import net.creativity0.livetranslator.translation.TranslatorManager;
import net.creativity0.livetranslator.utility.LiveTranslatorLogger;
import net.creativity0.livetranslator.utility.OutgoingMessageCache;
import net.creativity0.livetranslator.utility.OutgoingShortcutFeedbackCache;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="livetranslator", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class IncomingChatTranslator {
    @SubscribeEvent
    public static void onClientChat(ClientChatReceivedEvent event) {
        try {
            Component messageComponent = event.getMessage();
            String rawMessage = messageComponent.getString();
            String senderName = IncomingChatTranslator.extractSender(rawMessage);
            String messageText = IncomingChatTranslator.extractMessage(rawMessage);
            LocalPlayer currentPlayer = Minecraft.getInstance().player;
            boolean isSelf = currentPlayer != null && senderName.equals(currentPlayer.getGameProfile().getName());
            Component handled = IncomingChatTranslator.handleIncoming(senderName, messageText, isSelf);
            event.setMessage(handled);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Component handleIncoming(String senderName, String message, boolean isSelf) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (isSelf && player != null) {
            MutableComponent displayText;
            LiveTranslatorLogger.LOGGER.info("Message is outgoing, checking cache...");
            OutgoingMessageCache.CachedMessage cachedOriginal = OutgoingMessageCache.pop(player.getUUID());
            boolean showFeedback = OutgoingShortcutFeedbackCache.pop(player.getUUID());
            if (cachedOriginal != null && cachedOriginal.translatedText() != null) {
                MutableComponent hoverText = Component.literal((String)message);
                displayText = IncomingChatTranslator.prefixWithLang((Component)ChatMessenger.buildPlayerText(cachedOriginal.translatedText(), senderName).setStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)hoverText))), cachedOriginal.targetLang());
            } else {
                displayText = ChatMessenger.buildPlayerText(message, senderName);
            }
            if (showFeedback) {
                mc.execute(() -> {
                    LocalPlayer currentPlayer = Minecraft.getInstance().player;
                    if (currentPlayer != null) {
                        currentPlayer.displayClientMessage((Component)Component.literal((String)"[LiveTranslator] Shortcut feature is disabled.").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}), false);
                    }
                });
            }
            return displayText;
        }
        if (!TranslationSettings.getTranslationEnabled() || !TranslationSettings.getIsIncomingTranslationEnabled()) {
            return ChatMessenger.buildPlayerText(message, senderName);
        }
        Translator.TranslationResult translationResult = TranslatorManager.translate(message, TranslationSettings.getIncomingTranslationLanguage());
        String translatedMessage = translationResult.translatedText();
        String detectedSourceLanguage = translationResult.detectedSourceLang();
        if (translatedMessage == null || translatedMessage.isEmpty()) {
            return ChatMessenger.buildPlayerText(message, senderName);
        }
        LiveTranslatorLogger.LOGGER.info("Translated chat message from {}: {}, lang: {}", new Object[]{senderName, translatedMessage, detectedSourceLanguage});
        return IncomingChatTranslator.prefixWithLang((Component)ChatMessenger.buildPlayerText(translatedMessage, senderName).setStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)message)))), detectedSourceLanguage, isSelf);
    }

    private static MutableComponent prefixWithLang(Component text, String lang) {
        return IncomingChatTranslator.prefixWithLang(text, lang, true);
    }

    private static MutableComponent prefixWithLang(Component text, String lang, boolean isSelf) {
        Style prefixStyle = Style.EMPTY.withColor(ChatFormatting.BLUE).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "@" + lang + " ")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Click to reply with \"@" + lang + " \""))));
        return Component.literal((String)"[").append((Component)Component.literal((String)lang).setStyle(prefixStyle)).append("] ").append(text);
    }

    private static String extractSender(String full) {
        if (full.startsWith("<") && full.contains(">")) {
            int end = full.indexOf(62);
            return full.substring(1, end).trim();
        }
        return "Unknown";
    }

    private static String extractMessage(String full) {
        if (full.startsWith("<") && full.contains(">")) {
            int end = full.indexOf(62);
            return full.substring(end + 1).trim();
        }
        return full;
    }
}

