/*
 * Decompiled with CFR 0.152.
 */
package net.creativity0.livetranslator.chat;

import net.creativity0.livetranslator.config.TranslationSettings;
import net.creativity0.livetranslator.translation.Translator;
import net.creativity0.livetranslator.translation.TranslatorManager;
import net.creativity0.livetranslator.utility.ChatShortcutParser;
import net.creativity0.livetranslator.utility.OutgoingMessageCache;
import net.creativity0.livetranslator.utility.OutgoingShortcutFeedbackCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="livetranslator", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class OutgoingChatTranslator {
    private static boolean isSendingTranslatedMessage = false;

    @SubscribeEvent
    public static void onClientChat(ClientChatEvent event) {
        if (isSendingTranslatedMessage) {
            return;
        }
        String message = event.getMessage();
        try {
            boolean shouldTranslate;
            ChatShortcutParser.Result result = ChatShortcutParser.parse(message);
            boolean isShortcut = result.isShortcut();
            String targetLang = isShortcut && TranslationSettings.getIsOutgoingShortcutEnabled() ? result.targetLang() : TranslationSettings.getOutgoingTranslationLanguage();
            String actualMessage = isShortcut && TranslationSettings.getIsOutgoingShortcutEnabled() ? result.strippedMessage() : message;
            boolean bl = shouldTranslate = TranslationSettings.getTranslationEnabled() && TranslationSettings.getIsOutgoingTranslationEnabled() || isShortcut && TranslationSettings.getIsOutgoingShortcutEnabled();
            if (isShortcut && !TranslationSettings.getIsOutgoingShortcutEnabled()) {
                LocalPlayer player = Minecraft.getInstance().player;
                if (player != null) {
                    OutgoingShortcutFeedbackCache.mark(player.getUUID());
                }
                if (!TranslationSettings.getIsOutgoingTranslationEnabled() || !TranslationSettings.getTranslationEnabled()) {
                    return;
                }
            }
            if (!shouldTranslate) {
                return;
            }
            String incomingLang = TranslationSettings.getIncomingTranslationLanguage();
            Translator.TranslationResult translationResult = TranslationSettings.getIsIncomingTranslationLanguageUsedForOutGoingSourceLang() ? TranslatorManager.translate(actualMessage, targetLang, incomingLang) : TranslatorManager.translate(actualMessage, targetLang);
            String translatedMessage = translationResult.translatedText();
            LocalPlayer player = Minecraft.getInstance().player;
            if (translatedMessage != null && player != null) {
                event.setCanceled(true);
                OutgoingMessageCache.put(player.getUUID(), actualMessage, targetLang);
                isSendingTranslatedMessage = true;
                player.connection.sendChat(translatedMessage);
                isSendingTranslatedMessage = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            isSendingTranslatedMessage = false;
        }
    }
}

