/*
 * Decompiled with CFR 0.152.
 */
package net.creativity0.livetranslator.chat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.creativity0.livetranslator.chat.ChatMessenger;
import net.creativity0.livetranslator.config.PlayerTranslationSettings;
import net.creativity0.livetranslator.config.TranslationSettings;
import net.creativity0.livetranslator.settings.ServerPlayerTranslationSettings;
import net.creativity0.livetranslator.translation.Translator;
import net.creativity0.livetranslator.translation.TranslatorManager;
import net.creativity0.livetranslator.utility.LiveTranslatorLogger;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;

public final class ServerChatInterceptor {
    private static final ExecutorService TRANSLATION_EXECUTOR = Executors.newFixedThreadPool(2, r -> {
        Thread t = new Thread(r, "LiveTranslator-Server-Translator");
        t.setDaemon(true);
        return t;
    });

    private ServerChatInterceptor() {
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.addListener(ServerChatInterceptor::onServerChat);
    }

    private static void onServerChat(ServerChatEvent event) {
        ServerPlayer sender = event.getPlayer();
        MinecraftServer server = sender.getServer();
        if (server == null) {
            return;
        }
        if (!(server instanceof DedicatedServer)) {
            return;
        }
        if (!TranslationSettings.getTranslationEnabled()) {
            return;
        }
        event.setCanceled(true);
        Component msgComponent = event.getMessage();
        String originalMessage = msgComponent.getString();
        String senderName = sender.getGameProfile().getName();
        ServerPlayerTranslationSettings state = ServerPlayerTranslationSettings.get(server);
        ArrayList<Object> noTranslate = new ArrayList<Object>();
        HashMap<String, List> byLang = new HashMap<String, List>();
        for (Object target : server.getPlayerList().getPlayers()) {
            if (target.getUUID().equals(sender.getUUID())) {
                noTranslate.add(target);
                continue;
            }
            PlayerTranslationSettings playerTranslationSettings = state.get(target.getUUID());
            if (!playerTranslationSettings.translationsEnabled()) {
                noTranslate.add(target);
                continue;
            }
            byLang.computeIfAbsent(playerTranslationSettings.language(), k -> new ArrayList()).add(target);
        }
        MutableComponent originalText = Component.literal((String)("<" + senderName + "> ")).append((Component)Component.literal((String)originalMessage));
        for (ServerPlayer serverPlayer : noTranslate) {
            serverPlayer.sendSystemMessage((Component)originalText);
        }
        if (byLang.isEmpty()) {
            return;
        }
        ArrayList targetLangs = new ArrayList(byLang.keySet());
        TRANSLATION_EXECUTOR.submit(() -> ServerChatInterceptor.lambda$onServerChat$4(originalMessage, targetLangs, server, byLang, (Component)originalText, senderName));
    }

    private static Component prefixWithLang(Component text, String lang) {
        return Component.literal((String)"[").append((Component)Component.literal((String)lang).withStyle(style -> style.withColor(ChatFormatting.BLUE))).append((Component)Component.literal((String)"] ")).append(text);
    }

    private static /* synthetic */ void lambda$onServerChat$4(String originalMessage, List targetLangs, MinecraftServer server, Map byLang, Component originalText, String senderName) {
        Map<String, Translator.TranslationResult> results;
        try {
            results = TranslatorManager.translateBatch(originalMessage, targetLangs);
        }
        catch (Exception e) {
            LiveTranslatorLogger.LOGGER.error("Failed to batch-translate chat message: \"{}\"", (Object)originalMessage, (Object)e);
            server.execute(() -> {
                for (List targets : byLang.values()) {
                    for (ServerPlayer target : targets) {
                        target.sendSystemMessage(originalText);
                    }
                }
            });
            return;
        }
        server.execute(() -> {
            for (String targetLang : targetLangs) {
                List targets = (List)byLang.get(targetLang);
                if (targets == null || targets.isEmpty()) continue;
                Translator.TranslationResult result = (Translator.TranslationResult)results.get(targetLang);
                if (result == null) {
                    for (ServerPlayer target : targets) {
                        target.sendSystemMessage(originalText);
                    }
                    continue;
                }
                String translatedText = result.translatedText();
                String detectedSourceLang = result.detectedSourceLang();
                Component translated = ServerChatInterceptor.prefixWithLang((Component)ChatMessenger.buildPlayerText(translatedText, senderName).setStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)originalMessage)))), detectedSourceLang);
                for (ServerPlayer target : targets) {
                    target.sendSystemMessage(translated);
                }
            }
        });
    }
}

