/*
 * Decompiled with CFR 0.152.
 */
package net.creativity0.livetranslator.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class IsoLanguageArgumentType
implements ArgumentType<String> {
    private static final Set<String> VALID_CODES = new HashSet<String>(Arrays.asList(Locale.getISOLanguages()));
    private static final Map<String, String> NAME_TO_CODE = new HashMap<String, String>();
    private static final Map<String, String> CODE_TO_NAME = new HashMap<String, String>();
    private static final SimpleCommandExceptionType INVALID_LANGUAGE;

    public static IsoLanguageArgumentType isoLanguage() {
        return new IsoLanguageArgumentType();
    }

    public static String getLanguage(CommandContext<?> ctx, String name) {
        return (String)ctx.getArgument(name, String.class);
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        String input = reader.readUnquotedString().toLowerCase(Locale.ROOT);
        if (VALID_CODES.contains(input)) {
            return input;
        }
        String code = NAME_TO_CODE.get(input);
        if (code != null) {
            return code;
        }
        throw INVALID_LANGUAGE.create();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        List<String> formatted = CODE_TO_NAME.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(entry -> (String)entry.getKey() + " (" + (String)entry.getValue() + ")").toList();
        return SharedSuggestionProvider.suggest(formatted, (SuggestionsBuilder)builder);
    }

    static {
        for (String code : VALID_CODES) {
            Locale locale = new Locale(code);
            String display = locale.getDisplayLanguage(Locale.ENGLISH);
            if (display.isBlank()) continue;
            String lowerDisplay = display.toLowerCase(Locale.ROOT);
            NAME_TO_CODE.put(lowerDisplay, code);
            CODE_TO_NAME.put(code, display);
        }
        INVALID_LANGUAGE = new SimpleCommandExceptionType((Message)Component.literal((String)"Invalid language code. Use codes like 'en', 'es', 'fr', etc."));
    }
}

