/*
 * Decompiled with CFR 0.152.
 */
package net.creativity0.livetranslator.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.creativity0.livetranslator.chat.ChatMessenger;
import net.creativity0.livetranslator.config.PlayerTranslationSettings;
import net.creativity0.livetranslator.config.TranslationSettings;
import net.creativity0.livetranslator.settings.ServerPlayerTranslationSettings;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.RegisterCommandsEvent;

public final class ServerTranslateCommand {
    private static final String BASE_COMMAND = "livetranslator";
    private static final String MOD_PREFIX = "[LiveTranslator] ";
    private static final Component ENABLED_TEXT = ChatMessenger.green("ENABLED");
    private static final Component DISABLED_TEXT = ChatMessenger.red("DISABLED");

    private static void sendText(Component message, CommandContext<CommandSourceStack> ctx) {
        MutableComponent text = Component.literal((String)MOD_PREFIX).append(message);
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        source.sendSuccess(() -> ServerTranslateCommand.lambda$sendText$0((Component)text), false);
    }

    private ServerTranslateCommand() {
    }

    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)BASE_COMMAND).executes(ServerTranslateCommand::baseCommand)).then(((LiteralArgumentBuilder)Commands.literal((String)"on").requires(source -> source.hasPermission(2))).executes(ctx -> ServerTranslateCommand.toggleTranslate(true, (CommandContext<CommandSourceStack>)ctx)))).then(((LiteralArgumentBuilder)Commands.literal((String)"off").requires(source -> source.hasPermission(2))).executes(ctx -> ServerTranslateCommand.toggleTranslate(false, (CommandContext<CommandSourceStack>)ctx)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"language").requires(source -> source.getEntity() instanceof ServerPlayer)).executes(ServerTranslateCommand::getPlayerLanguage)).then(Commands.argument((String)"lang", (ArgumentType)StringArgumentType.word()).executes(ctx -> ServerTranslateCommand.setPlayerLanguage((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"lang")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"translations").requires(source -> source.getEntity() instanceof ServerPlayer)).executes(ServerTranslateCommand::getPlayerTranslationsEnabled)).then(Commands.literal((String)"on").executes(ctx -> ServerTranslateCommand.setPlayerTranslationsEnabled((CommandContext<CommandSourceStack>)ctx, true)))).then(Commands.literal((String)"off").executes(ctx -> ServerTranslateCommand.setPlayerTranslationsEnabled((CommandContext<CommandSourceStack>)ctx, false)))));
    }

    private static int baseCommand(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer p;
        ServerPlayer player;
        Component translatorState = switch (TranslationSettings.getTranslatorState()) {
            default -> throw new MatchException(null, null);
            case TranslationSettings.TranslatorState.ON -> ChatMessenger.ON_TEXT;
            case TranslationSettings.TranslatorState.LOADING -> ChatMessenger.LOADING_TEXT;
            case TranslationSettings.TranslatorState.OFF -> ChatMessenger.OFF_TEXT;
        };
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        Entity entity = source.getEntity();
        ServerPlayer serverPlayer = player = entity instanceof ServerPlayer ? (p = (ServerPlayer)entity) : null;
        if (player != null) {
            ServerPlayerTranslationSettings serverState = ServerPlayerTranslationSettings.get(source.getServer());
            PlayerTranslationSettings playerState = serverState.get(player.getUUID());
            String playerLang = playerState.language();
            boolean playerTranslationEnabled = playerState.translationsEnabled();
            MutableComponent playerStatusText = Component.literal((String)"").append(translatorState).append((Component)Component.literal((String)", ")).append(ChatMessenger.blue(playerLang)).append((Component)Component.literal((String)", ")).append(playerTranslationEnabled ? ENABLED_TEXT : DISABLED_TEXT);
            ServerTranslateCommand.sendText((Component)playerStatusText, ctx);
        } else {
            ServerTranslateCommand.sendText(translatorState, ctx);
        }
        return 1;
    }

    private static int toggleTranslate(boolean toggle, CommandContext<CommandSourceStack> ctx) {
        if (toggle) {
            if (TranslationSettings.getTranslatorState() == TranslationSettings.TranslatorState.LOADING) {
                ServerTranslateCommand.sendText((Component)Component.literal((String)"Translator is already ").append(ChatMessenger.LOADING_TEXT), ctx);
                return 0;
            }
            if (TranslationSettings.getTranslatorState() == TranslationSettings.TranslatorState.ON) {
                ServerTranslateCommand.sendText((Component)Component.literal((String)"Translator is already ").append(ChatMessenger.ON_TEXT), ctx);
                return 0;
            }
            TranslationSettings.toggleTranslator(true);
        } else {
            if (TranslationSettings.getTranslatorState() == TranslationSettings.TranslatorState.OFF) {
                ServerTranslateCommand.sendText((Component)Component.literal((String)"Translator is already ").append(ChatMessenger.OFF_TEXT), ctx);
                return 0;
            }
            TranslationSettings.toggleTranslator(false);
        }
        return 1;
    }

    private static int getPlayerLanguage(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        ServerPlayerTranslationSettings serverState = ServerPlayerTranslationSettings.get(((CommandSourceStack)ctx.getSource()).getServer());
        PlayerTranslationSettings settings = serverState.get(player.getUUID());
        ServerTranslateCommand.sendText((Component)Component.literal((String)"Your current language is: ").append(ChatMessenger.blue(settings.language())), ctx);
        return 1;
    }

    private static int setPlayerLanguage(CommandContext<CommandSourceStack> ctx, String lang) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = source.getPlayerOrException();
        ServerPlayerTranslationSettings serverState = ServerPlayerTranslationSettings.get(source.getServer());
        serverState.setLanguage(player.getUUID(), lang);
        ServerTranslateCommand.sendText((Component)Component.literal((String)"Your language is now: ").append(ChatMessenger.blue(lang)), ctx);
        return 1;
    }

    private static int getPlayerTranslationsEnabled(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        ServerPlayerTranslationSettings serverState = ServerPlayerTranslationSettings.get(((CommandSourceStack)ctx.getSource()).getServer());
        PlayerTranslationSettings settings = serverState.get(player.getUUID());
        ServerTranslateCommand.sendText((Component)Component.literal((String)"Translations are currently: ").append(settings.translationsEnabled() ? ENABLED_TEXT : DISABLED_TEXT), ctx);
        return 1;
    }

    private static int setPlayerTranslationsEnabled(CommandContext<CommandSourceStack> ctx, boolean enabled) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = source.getPlayerOrException();
        ServerPlayerTranslationSettings serverState = ServerPlayerTranslationSettings.get(source.getServer());
        serverState.setTranslationsEnabled(player.getUUID(), enabled);
        MutableComponent msg = enabled ? Component.literal((String)"Translations ").append(ENABLED_TEXT) : Component.literal((String)"Translations ").append(DISABLED_TEXT);
        ServerTranslateCommand.sendText((Component)msg, ctx);
        return 1;
    }

    private static /* synthetic */ Component lambda$sendText$0(Component text) {
        return text;
    }
}

