/*
 * Decompiled with CFR 0.152.
 */
package net.creativity0.livetranslator.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Set;
import net.creativity0.livetranslator.chat.ChatMessenger;
import net.creativity0.livetranslator.command.IsoLanguageArgumentType;
import net.creativity0.livetranslator.config.TranslationSettings;
import net.creativity0.livetranslator.translation.TranslatorManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="livetranslator", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TranslateCommand {
    private static final String BASE_COMMAND = "livetranslator";

    @SubscribeEvent
    public static void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        event.getDispatcher().register(TranslateCommand.buildCommand());
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)BASE_COMMAND).executes(ctx -> TranslateCommand.baseCommand())).then(Commands.literal((String)"on").executes(ctx -> TranslateCommand.toggleTranslate(true)))).then(Commands.literal((String)"off").executes(ctx -> TranslateCommand.toggleTranslate(false)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"incomingTranslation").executes(ctx -> TranslateCommand.incomingTranslationCommand())).then(Commands.literal((String)"setLanguage").then(Commands.argument((String)"lang", (ArgumentType)IsoLanguageArgumentType.isoLanguage()).executes(ctx -> TranslateCommand.setIncomingTranslationLanguageCommand(StringArgumentType.getString((CommandContext)ctx, (String)"lang")))))).then(Commands.literal((String)"on").executes(ctx -> TranslateCommand.toggleIncomingTranslationCommand(true)))).then(Commands.literal((String)"off").executes(ctx -> TranslateCommand.toggleIncomingTranslationCommand(false))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"outgoingTranslation").executes(ctx -> TranslateCommand.outgoingTranslationCommand())).then(Commands.literal((String)"setLanguage").then(Commands.argument((String)"lang", (ArgumentType)IsoLanguageArgumentType.isoLanguage()).executes(ctx -> TranslateCommand.setOutgoingTranslationLanguageCommand(StringArgumentType.getString((CommandContext)ctx, (String)"lang")))))).then(Commands.literal((String)"on").executes(ctx -> TranslateCommand.toggleOutGoingTranslationCommand(true)))).then(Commands.literal((String)"off").executes(ctx -> TranslateCommand.toggleOutGoingTranslationCommand(false)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"useIncomingTranslationLanguageAsSource").executes(ctx -> TranslateCommand.useIncomingTranslationLanguageAsSourceCommand())).then(Commands.literal((String)"on").executes(ctx -> TranslateCommand.toggleUseIncomingTranslationLanguageAsSourceCommand(true)))).then(Commands.literal((String)"off").executes(ctx -> TranslateCommand.toggleUseIncomingTranslationLanguageAsSourceCommand(false))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"shortcut").executes(ctx -> TranslateCommand.outgoingTranslationShortcutCommand())).then(Commands.literal((String)"on").executes(ctx -> TranslateCommand.toggleOutgoingTranslationShortcutCommand(true)))).then(Commands.literal((String)"off").executes(ctx -> TranslateCommand.toggleOutgoingTranslationShortcutCommand(false)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"model").executes(ctx -> TranslateCommand.modelCommand())).then(Commands.literal((String)"switch").then(Commands.argument((String)"modelName", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String modelName = StringArgumentType.getString((CommandContext)ctx, (String)"modelName");
            return TranslateCommand.switchModelCommand(modelName);
        }))));
    }

    private static int baseCommand() {
        Component state = switch (TranslationSettings.getTranslatorState()) {
            default -> throw new MatchException(null, null);
            case TranslationSettings.TranslatorState.ON -> ChatMessenger.ON_TEXT;
            case TranslationSettings.TranslatorState.LOADING -> ChatMessenger.LOADING_TEXT;
            case TranslationSettings.TranslatorState.OFF -> ChatMessenger.OFF_TEXT;
        };
        ChatMessenger.sendToPlayer((Component)Component.literal((String)"\nTranslator status: ").append(state).append("\n").append(TranslateCommand.currentModelText()).append("\n").append(TranslateCommand.incomingTranslationCommandText()).append("\n").append(TranslateCommand.outgoingTranslationCommandText()));
        return 1;
    }

    private static int toggleTranslate(boolean toggle) {
        if (toggle) {
            if (TranslationSettings.getTranslatorState() == TranslationSettings.TranslatorState.LOADING) {
                ChatMessenger.sendToPlayer((Component)Component.literal((String)"Translator is already ").append(ChatMessenger.LOADING_TEXT));
                return 0;
            }
            if (TranslationSettings.getTranslatorState() == TranslationSettings.TranslatorState.ON) {
                ChatMessenger.sendToPlayer((Component)Component.literal((String)"Translator is already ").append(ChatMessenger.ON_TEXT));
                return 0;
            }
            TranslationSettings.toggleTranslator(true);
        } else {
            if (TranslationSettings.getTranslatorState() == TranslationSettings.TranslatorState.OFF) {
                ChatMessenger.sendToPlayer((Component)Component.literal((String)"Translator is already ").append(ChatMessenger.OFF_TEXT));
                return 0;
            }
            TranslationSettings.toggleTranslator(false);
        }
        return 1;
    }

    private static Component incomingTranslationCommandText() {
        return Component.literal((String)"Incoming language translation").append("\nStatus: ").append(TranslationSettings.getIsIncomingTranslationEnabled() ? ChatMessenger.ON_TEXT : ChatMessenger.OFF_TEXT).append("\nLanguage: ").append(ChatMessenger.blue(TranslationSettings.getIncomingTranslationLanguage()));
    }

    private static int incomingTranslationCommand() {
        ChatMessenger.sendToPlayer(TranslateCommand.incomingTranslationCommandText());
        return 1;
    }

    private static int setIncomingTranslationLanguageCommand(String lang) {
        TranslationSettings.setIncomingTranslationLanguage(lang);
        ChatMessenger.sendToPlayer((Component)Component.literal((String)"Incoming language set to: ").append(ChatMessenger.blue(lang)));
        return 1;
    }

    private static int toggleIncomingTranslationCommand(boolean toggle) {
        TranslationSettings.setIsIncomingTranslationEnabled(toggle);
        ChatMessenger.sendToPlayer((Component)Component.literal((String)"Incoming message translation is : ").append(toggle ? ChatMessenger.ON_TEXT : ChatMessenger.OFF_TEXT));
        return 1;
    }

    private static Component outgoingTranslationCommandText() {
        return Component.literal((String)"Outgoing language translation").append("\nStatus: ").append(TranslationSettings.getIsOutgoingTranslationEnabled() ? ChatMessenger.ON_TEXT : ChatMessenger.OFF_TEXT).append("\nLanguage: ").append(ChatMessenger.blue(TranslationSettings.getOutgoingTranslationLanguage())).append("\nUse incoming language as source: ").append(TranslationSettings.getIsIncomingTranslationLanguageUsedForOutGoingSourceLang() ? ChatMessenger.ON_TEXT : ChatMessenger.OFF_TEXT).append("\nShortcut (@lang) enabled: ").append(TranslationSettings.getIsOutgoingShortcutEnabled() ? ChatMessenger.ON_TEXT : ChatMessenger.OFF_TEXT);
    }

    private static int outgoingTranslationCommand() {
        ChatMessenger.sendToPlayer(TranslateCommand.outgoingTranslationCommandText());
        return 1;
    }

    private static int setOutgoingTranslationLanguageCommand(String lang) {
        TranslationSettings.setOutgoingTranslationLanguage(lang);
        ChatMessenger.sendToPlayer((Component)Component.literal((String)"Outgoing language set to: ").append(ChatMessenger.blue(lang)));
        return 1;
    }

    private static int toggleOutGoingTranslationCommand(boolean toggle) {
        TranslationSettings.setIsOutgoingTranslationEnabled(toggle);
        ChatMessenger.sendToPlayer((Component)Component.literal((String)"Outgoing message translation is : ").append(toggle ? ChatMessenger.ON_TEXT : ChatMessenger.OFF_TEXT));
        return 1;
    }

    private static int useIncomingTranslationLanguageAsSourceCommand() {
        boolean isOn = TranslationSettings.getIsIncomingTranslationLanguageUsedForOutGoingSourceLang();
        ChatMessenger.sendToPlayer((Component)Component.literal((String)"Use incoming language as source: ").append(isOn ? ChatMessenger.ON_TEXT : ChatMessenger.OFF_TEXT).append("\nWhen translating outgoing messages, the source language is ").append(isOn ? ChatMessenger.blue(TranslationSettings.getIncomingTranslationLanguage()) : ChatMessenger.blue("auto")));
        return 1;
    }

    private static int toggleUseIncomingTranslationLanguageAsSourceCommand(boolean toggle) {
        TranslationSettings.setIsIncomingTranslationLanguageUsedForOutGoingSourceLang(toggle);
        ChatMessenger.sendToPlayer((Component)Component.literal((String)"Turned: ").append(toggle ? ChatMessenger.ON_TEXT : ChatMessenger.OFF_TEXT).append("\nWhen translating outgoing messages, the source language is ").append(toggle ? ChatMessenger.blue(TranslationSettings.getIncomingTranslationLanguage()) : ChatMessenger.blue("auto")));
        return 1;
    }

    private static int outgoingTranslationShortcutCommand() {
        ChatMessenger.sendToPlayer((Component)Component.literal((String)"Outgoing translation shortcut is: ").append(TranslationSettings.getIsOutgoingShortcutEnabled() ? ChatMessenger.ON_TEXT : ChatMessenger.OFF_TEXT));
        return 1;
    }

    private static int toggleOutgoingTranslationShortcutCommand(boolean toggle) {
        TranslationSettings.setIsOutgoingShortcutEnabled(toggle);
        ChatMessenger.sendToPlayer((Component)Component.literal((String)"Outgoing translation shortcut turned ").append(toggle ? ChatMessenger.ON_TEXT : ChatMessenger.OFF_TEXT));
        return 1;
    }

    private static Component currentModelText() {
        return Component.literal((String)"Current model: ").append(ChatMessenger.blue(TranslatorManager.getCurrentTranslatorName()));
    }

    private static int modelCommand() {
        Set<String> modelNames = TranslatorManager.getAvailableTranslatorNames();
        String currentModelName = TranslatorManager.getCurrentTranslatorName();
        MutableComponent message = Component.literal((String)"Available models:");
        for (String modelName : modelNames) {
            MutableComponent modelText = modelName.equals(currentModelName) ? Component.literal((String)modelName).withStyle(style -> style.withColor(ChatFormatting.BLUE)) : Component.literal((String)modelName);
            message.append("\n").append((Component)modelText);
        }
        ChatMessenger.sendToPlayer((Component)message);
        return 1;
    }

    private static int switchModelCommand(String modelName) {
        String newModelName = TranslatorManager.setCurrentTranslator(modelName);
        if (newModelName != null) {
            ChatMessenger.sendToPlayer((Component)Component.literal((String)"Switched to: ").append(newModelName));
            return 1;
        }
        ChatMessenger.sendToPlayer(ChatMessenger.red("Could not switch to: " + modelName));
        return 0;
    }
}

