/*
 * Decompiled with CFR 0.152.
 */
package net.creativity0.livetranslator.event;

public class TranslatorEvent {
    private final Type type;
    private final int progress;
    private final Throwable throwable;

    public TranslatorEvent(Type type) {
        this(type, -1, null);
    }

    public TranslatorEvent(Type type, int progress) {
        this(type, progress, null);
    }

    public TranslatorEvent(Type type, Throwable throwable) {
        this(type, -1, throwable);
    }

    public TranslatorEvent(Type type, int progress, Throwable throwable) {
        this.type = type;
        this.progress = progress;
        this.throwable = throwable;
    }

    public Type getType() {
        return this.type;
    }

    public double getProgress() {
        return this.progress;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean hasProgress() {
        return this.progress >= 0;
    }

    public boolean hasError() {
        return this.throwable != null;
    }

    public String getMessage() {
        if (this.throwable == null) {
            return "";
        }
        return this.throwable.getMessage() != null ? this.throwable.getMessage() : this.throwable.toString();
    }

    public static enum Type {
        TRANSLATOR_START,
        TRANSLATOR_READY,
        DEPENDENCY_CHECK_START,
        ENV_SETUP_START,
        DEPENDENCIES_INSTALL_START,
        MODEL_DOWNLOAD_PROGRESS,
        MODEL_DOWNLOAD_COMPLETE,
        SERVER_STARTING,
        STOPPED,
        ERROR;

    }
}

